/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.table;

import java.util.List;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.core.gps.RouteSegment;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.table.StrippedDataTable;
import main.java.guru.vfrflight.gui.table.header.DataTableHeader;
import main.java.guru.vfrflight.gui.table.model.ResultTableModel;

public class ResultDataTable
extends StrippedDataTable
implements ListSelectionListener {
    private static final long serialVersionUID = 1008304705082943548L;
    private int prevSelection = -1;

    public ResultDataTable() {
        super(new ResultTableModel());
        ResultTableModel model = (ResultTableModel)this.getTable().getModel();
        this.getTable().getColumnModel().getColumn(0).setPreferredWidth(250);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(0);
        for (int i = 1; i < this.getModel().getColumnCount(); ++i) {
            this.getTable().getColumnModel().getColumn(i).setCellRenderer(renderer);
        }
        this.getTable().getSelectionModel().addListSelectionListener(this);
        DataTableHeader header = new DataTableHeader(this.getTable().getColumnModel());
        header.setToolTipStrings(model.getToolTips());
        this.getTable().setTableHeader(header);
    }

    public void setData(List<RouteSegment> segments) {
        this.clearData();
        for (RouteSegment segment : segments) {
            this.addSegment(segment);
        }
    }

    public void addSegment(RouteSegment segment) {
        ResultTableModel model = (ResultTableModel)this.getModel();
        model.addSegment(segment);
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
        int row = this.getTable().getSelectedRow();
        if (row != this.prevSelection) {
            FlightPlanBean.getInstance().selectSegment(row);
            MapFrame.getInstance().updateMap();
            this.prevSelection = row;
        }
    }
}

