/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.table;

import java.util.Collections;
import java.util.List;
import javax.swing.table.DefaultTableCellRenderer;
import main.java.guru.vfrflight.core.AirspaceReservation;
import main.java.guru.vfrflight.gui.table.StrippedDataTable;
import main.java.guru.vfrflight.gui.table.model.ReservedAirspacesTableModel;

public class ReservedAirspacesDataTable
extends StrippedDataTable {
    private static final long serialVersionUID = 329266425091635824L;

    public ReservedAirspacesDataTable(List<AirspaceReservation> reservations) {
        super(new ReservedAirspacesTableModel());
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(0);
        for (int i = 0; i < this.getModel().getColumnCount() - 1; ++i) {
            this.getTable().getColumnModel().getColumn(i).setCellRenderer(renderer);
        }
        this.getTable().getColumnModel().getColumn(0).setPreferredWidth(50);
        this.getTable().getColumnModel().getColumn(1).setPreferredWidth(100);
        this.getTable().getColumnModel().getColumn(7).setPreferredWidth(200);
        if (reservations != null) {
            Collections.sort(reservations);
            this.setData(reservations);
        }
    }

    public void setData(List<AirspaceReservation> reservations) {
        this.clearData();
        for (AirspaceReservation r : reservations) {
            this.addRow(r);
        }
    }

    @Override
    public ReservedAirspacesTableModel getModel() {
        return (ReservedAirspacesTableModel)this.table.getModel();
    }

    public void addRow(AirspaceReservation r) {
        this.getModel().addRow(r);
    }
}

