/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.table;

import java.awt.Font;
import java.util.List;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.core.gps.RoutePlace;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.swing.LatitudeComboBoxEditor;
import main.java.guru.vfrflight.gui.swing.LongitudeComboBoxEditor;
import main.java.guru.vfrflight.gui.table.model.PointsTableModel;
import main.java.guru.vfrflight.gui.table.waypoints.WaypointsDataTable;

public class PointsDataTable
extends WaypointsDataTable
implements ListSelectionListener,
TableModelListener {
    private static final long serialVersionUID = 1008304705082943548L;
    private int prevSelection = -1;
    protected boolean suppressValueChanged = false;

    public PointsDataTable() {
        this(false);
    }

    public PointsDataTable(boolean enableMouseWheel) {
        super(new PointsTableModel());
        if (!enableMouseWheel) {
            this.disableMouseWheel();
        }
        DefaultTableCellRenderer rightRenderer = new DefaultTableCellRenderer();
        rightRenderer.setHorizontalAlignment(4);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(0);
        this.getTable().getColumnModel().getColumn(0).setPreferredWidth(200);
        this.getTable().getColumnModel().getColumn(0).setCellRenderer(rightRenderer);
        this.getTable().getColumnModel().getColumn(4).setPreferredWidth(25);
        this.getTable().getColumnModel().getColumn(4).setCellRenderer(renderer);
        this.getTable().getColumnModel().getColumn(4).setCellEditor(new LatitudeComboBoxEditor());
        this.getTable().getColumnModel().getColumn(4).setResizable(false);
        this.getTable().getColumnModel().getColumn(8).setPreferredWidth(25);
        this.getTable().getColumnModel().getColumn(8).setCellRenderer(renderer);
        this.getTable().getColumnModel().getColumn(8).setCellEditor(new LongitudeComboBoxEditor());
        this.getTable().getColumnModel().getColumn(8).setResizable(false);
        this.getTable().getSelectionModel().addListSelectionListener(this);
        this.getTable().getColumnModel().getColumn(9).setPreferredWidth(100);
        this.getTable().getTableHeader().setFont(new Font("SansSerif", 1, 9));
        this.getTable().setFont(new Font("SansSerif", 0, 10));
        this.getModel().addTableModelListener(this);
    }

    @Override
    public void setData(List<RoutePlace> points) {
        this.suppressValueChanged = true;
        this.clearData();
        for (RoutePlace point : points) {
            this.addPoint(point);
        }
        this.suppressValueChanged = false;
    }

    @Override
    public PointsTableModel getModel() {
        return (PointsTableModel)this.table.getModel();
    }

    @Override
    public RoutePlace getPointAtRow(int row) {
        return this.getModel().getPointAtRow(row);
    }

    @Override
    public List<RoutePlace> getData() {
        return this.getModel().getData();
    }

    @Override
    public void addPoint(RoutePlace point, Integer index) {
        this.getModel().addPoint(point, index);
    }

    @Override
    public void addPoint(RoutePlace point) {
        this.addPoint(point, null);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!this.suppressValueChanged && this.getTable().getSelectedRow() != this.prevSelection) {
            FlightPlanBean.getInstance().selectPoint(this.getTable().getSelectedRow());
            MapFrame.getInstance().updateMap();
            this.prevSelection = this.getTable().getSelectedRow();
        }
    }

    @Override
    public void selectRow(int row) {
        this.suppressValueChanged = true;
        super.selectRow(row);
        this.suppressValueChanged = false;
    }

    @Override
    public void tableChanged(TableModelEvent tablemodelevent) {
        if (!this.suppressValueChanged) {
            MapFrame.getInstance().getUIPanel().saveBeanPointsData(true);
        }
    }
}

