/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.table;

import java.awt.Color;
import javax.swing.table.DefaultTableCellRenderer;
import main.java.guru.vfrflight.core.FuelValues;
import main.java.guru.vfrflight.gui.table.ColorColumnCellRenderer;
import main.java.guru.vfrflight.gui.table.DataTable;
import main.java.guru.vfrflight.gui.table.header.DataTableHeader;
import main.java.guru.vfrflight.gui.table.model.FuelTableModel;

public class FuelDataTable
extends DataTable {
    private static final long serialVersionUID = 2735098483902162147L;

    public FuelDataTable() {
        super(new FuelTableModel());
        FuelTableModel model = (FuelTableModel)this.getTable().getModel();
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(0);
        for (int i = 0; i < this.getModel().getColumnCount(); ++i) {
            this.getTable().getColumnModel().getColumn(i).setCellRenderer(renderer);
        }
        DataTableHeader header = new DataTableHeader(this.getTable().getColumnModel());
        header.setToolTipStrings(model.getToolTips());
        this.getTable().setTableHeader(header);
    }

    public void setValues(FuelValues values) {
        this.clearData();
        FuelTableModel model = (FuelTableModel)this.getModel();
        model.setValues(values);
        if (values.getQlft() != null && values.getQlft() <= 0.0) {
            this.showFuelWarning();
        }
    }

    public void showFuelWarning() {
        ColorColumnCellRenderer colorRenderer = new ColorColumnCellRenderer(Color.RED);
        colorRenderer.setHorizontalAlignment(0);
        this.getTable().getColumnModel().getColumn(4).setCellRenderer(colorRenderer);
    }
}

