/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.table;

import java.awt.BorderLayout;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import main.java.guru.vfrflight.gui.table.model.DataTableModel;

public class DataTable
extends JPanel {
    private static final long serialVersionUID = 6482286730999742709L;
    protected JTable table;
    protected JScrollPane tableScroll;

    public DataTable(DataTableModel tableModel) {
        this.setLayout(new BorderLayout(0, 0));
        this.tableScroll = new JScrollPane();
        this.add(this.tableScroll);
        this.table = new JTable();
        this.tableScroll.setViewportView(this.table);
        this.table.setModel(tableModel);
    }

    public void addRow() {
        this.getModel().addRow(new String[this.getModel().getColumnCount()]);
        this.selectRow(this.getModel().getRowCount() - 1);
    }

    public void duplicateRow(int rowNum) {
        this.getModel().addRow(this.getRow(rowNum));
        this.getModel().moveRow(this.getModel().getRowCount() - 1, this.getModel().getRowCount() - 1, rowNum + 1);
    }

    public Object[] getRow(int rowNum) {
        Object[] data = new Object[this.getModel().getColumnCount()];
        for (int i = 0; i < this.getModel().getColumnCount(); ++i) {
            data[i] = this.getModel().getValueAt(rowNum, i);
        }
        return data;
    }

    public void addRow(Object[] row) {
        this.getModel().addRow(row);
    }

    public void removeRow(int row) {
        this.getModel().removeRow(row);
    }

    public void selectRow(int row) {
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        selectionModel.setSelectionInterval(row, row);
    }

    public void scrollToBottom() {
        JScrollBar vertical = this.tableScroll.getVerticalScrollBar();
        vertical.setValue(vertical.getMaximum());
    }

    public DataTableModel getModel() {
        return (DataTableModel)this.table.getModel();
    }

    public JTable getTable() {
        return this.table;
    }

    public void clearData() {
        while (this.getModel().getRowCount() > 0) {
            this.getModel().removeRow(0);
        }
    }

    public boolean hasCompleteRows() {
        return this.getModel().hasCompleteRows();
    }

    public boolean isEmpty() {
        return this.getModel().isEmpty();
    }

    public int getRowCount() {
        return this.getModel().getRowCount();
    }

    public void disableMouseWheel() {
        this.tableScroll.removeMouseWheelListener(this.tableScroll.getMouseWheelListeners()[0]);
    }
}

