/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.table;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.table.DefaultTableCellRenderer;
import main.java.guru.vfrflight.gui.table.StrippedDataTable;
import main.java.guru.vfrflight.gui.table.model.BooleanTableModel;

public class BooleanDataTable
extends StrippedDataTable {
    private static final long serialVersionUID = 5552103606369082949L;

    public BooleanDataTable(Map<String, Boolean> values, boolean useMessages) {
        super(new BooleanTableModel(useMessages));
        this.getTable().setTableHeader(null);
        this.getTable().getColumnModel().getColumn(1).setMaxWidth(50);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(0);
        for (int i = 0; i < this.getModel().getColumnCount() - 2; ++i) {
            this.getTable().getColumnModel().getColumn(i).setCellRenderer(renderer);
        }
        if (values != null) {
            this.addRows(values);
        }
    }

    public void setData(Map<String, Boolean> values) {
        this.clear();
        this.addRows(values);
    }

    public void clear() {
        while (this.getModel().getRowCount() > 0) {
            this.getModel().removeRow(0);
        }
    }

    public void addRows(Map<String, Boolean> values) {
        BooleanTableModel model = this.getModel();
        for (Map.Entry<String, Boolean> entry : values.entrySet()) {
            model.addRow(entry.getKey(), entry.getValue());
        }
    }

    public void setValue(String key, Boolean value) {
        for (int i = 0; i < this.getModel().getRowCount(); ++i) {
            if (!key.equals(this.getModel().getKeyAt(i))) continue;
            this.getModel().setValueAt(value, i, 1);
            break;
        }
    }

    public void toggleValue(String key) {
        for (int i = 0; i < this.getModel().getRowCount(); ++i) {
            if (!key.equals(this.getModel().getKeyAt(i))) continue;
            this.getModel().setValueAt((Boolean)this.getModel().getValueAt(i, 1) == false, i, 1);
            break;
        }
    }

    public Map<String, Boolean> getData() {
        BooleanTableModel model = this.getModel();
        LinkedHashMap<String, Boolean> result = new LinkedHashMap<String, Boolean>();
        for (int row = 0; row < model.getRowCount(); ++row) {
            result.put(model.getKeyAt(row), model.getValueAt(row));
        }
        return result;
    }

    public boolean deselectAll() {
        BooleanTableModel model = this.getModel();
        for (int row = 0; row < model.getRowCount(); ++row) {
            this.getModel().setValueAt(Boolean.FALSE, row, 1);
        }
        return true;
    }

    public boolean selectAll() {
        BooleanTableModel model = this.getModel();
        for (int row = 0; row < model.getRowCount(); ++row) {
            this.getModel().setValueAt(Boolean.TRUE, row, 1);
        }
        return true;
    }

    public boolean isAllUnchecked() {
        BooleanTableModel model = this.getModel();
        for (int row = 0; row < model.getRowCount(); ++row) {
            if (!Boolean.TRUE.equals(model.getValueAt(row))) continue;
            return false;
        }
        return true;
    }

    public boolean isAnySelected() {
        BooleanTableModel model = this.getModel();
        for (int row = 0; row < model.getRowCount(); ++row) {
            if (!Boolean.TRUE.equals(model.getValueAt(row))) continue;
            return true;
        }
        return false;
    }

    @Override
    public BooleanTableModel getModel() {
        return (BooleanTableModel)this.table.getModel();
    }
}

