/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.table;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.DefaultTableCellRenderer;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.table.DataTable;
import main.java.guru.vfrflight.gui.table.model.AlternatesSearchResultTableModel;

public class AlternatesSearchResultDataTable
extends DataTable
implements MouseListener {
    private static final long serialVersionUID = -5595663743454358933L;
    private List<Airport> airports;

    public AlternatesSearchResultDataTable() {
        super(new AlternatesSearchResultTableModel());
        this.getTable().getColumnModel().getColumn(0).setPreferredWidth(250);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(0);
        for (int i = 1; i < this.getModel().getColumnCount(); ++i) {
            this.getTable().getColumnModel().getColumn(i).setCellRenderer(renderer);
        }
        this.getTable().addMouseListener(this);
    }

    public void setData(List<Airport> airports) {
        this.clearData();
        for (Airport airport : airports) {
            this.addRow(airport);
        }
    }

    @Override
    public void clearData() {
        this.getAirports().clear();
        super.clearData();
    }

    public void addRow(Airport airport) {
        AlternatesSearchResultTableModel model = (AlternatesSearchResultTableModel)this.getModel();
        model.addRow(airport);
        this.getAirports().add(airport);
    }

    public void centerOnSelected() {
        if (this.getTable().getSelectedRow() >= 0) {
            this.showPointOnMap(this.getTable().getSelectedRow());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.centerOnSelected();
        }
    }

    public void showPointOnMap(int i) {
        GpsPlace place = this.getAirports().get(i).getGpsPlace();
        MapFrame.getInstance().centerOnPoint(place, 8);
        MapFrame.getInstance().setMarkerPlace(place);
        MapFrame.getInstance().updateMap();
    }

    public List<Airport> getAirports() {
        if (this.airports == null) {
            this.airports = new ArrayList<Airport>();
        }
        return this.airports;
    }

    public void setAirports(List<Airport> airports) {
        this.airports = airports;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

