/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.table;

import java.awt.Font;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.core.AlternateAirport;
import main.java.guru.vfrflight.gui.table.StrippedDataTable;
import main.java.guru.vfrflight.gui.table.model.AlternateAirportsTableModel;

public class AlternateAirportsDataTable
extends StrippedDataTable
implements TableModelListener {
    private static final long serialVersionUID = -8774882089083318454L;
    private boolean suppressChanges = false;

    public AlternateAirportsDataTable(List<AlternateAirport> airports) {
        super(new AlternateAirportsTableModel());
        this.disableMouseWheel();
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(0);
        this.getTable().getColumnModel().getColumn(0).setPreferredWidth(200);
        this.getTable().getTableHeader().setFont(new Font("SansSerif", 1, 9));
        this.getTable().setFont(new Font("SansSerif", 0, 10));
        for (int i = 1; i < this.getModel().getColumnCount(); ++i) {
            this.getTable().getColumnModel().getColumn(i).setCellRenderer(renderer);
            this.getTable().getColumnModel().getColumn(i).setPreferredWidth(150);
        }
        if (airports.size() > 3) {
            this.getTable().setAutoResizeMode(0);
        }
        this.setData(airports);
        this.getModel().addTableModelListener(this);
    }

    public void setData(List<AlternateAirport> airports) {
        this.clearData();
        for (AlternateAirport a : airports) {
            this.addAirport(a);
        }
    }

    @Override
    public void clearData() {
        this.suppressChanges = true;
        super.clearData();
        this.suppressChanges = false;
    }

    @Override
    public AlternateAirportsTableModel getModel() {
        return (AlternateAirportsTableModel)this.table.getModel();
    }

    public void addAirport(AlternateAirport airport) {
        this.suppressChanges = true;
        this.getModel().addAirport(airport);
        this.suppressChanges = false;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (!this.suppressChanges) {
            int row = e.getFirstRow();
            AlternateAirport oldRow = FlightPlanBean.getInstance().getRoute().getAlternateAirports().get(row);
            if (2 == e.getColumn()) {
                oldRow.setFrequency(this.getFreqAt(row));
            } else if (1 == e.getColumn()) {
                oldRow.setElev(this.getElevAt(row));
            }
        }
    }

    private Double getFreqAt(int row) {
        return (Double)this.getModel().getValueAt(row, 2);
    }

    private Integer getElevAt(int row) {
        return (Integer)this.getModel().getValueAt(row, 1);
    }
}

