/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.table;

import java.awt.Dimension;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import main.java.guru.vfrflight.gui.flightplan.panel.AirspacesFilterCollapsablePanel;
import main.java.guru.vfrflight.gui.table.StrippedDataTable;
import main.java.guru.vfrflight.gui.table.model.AirspaceTypeVisibilityTableModel;
import main.java.guru.vfrflight.gui.table.model.row.AirspaceTypeVisibilityRow;

public class AirspaceTypeVisibilityDataTable
extends StrippedDataTable
implements TableModelListener {
    private static final long serialVersionUID = 503952890508425457L;
    private boolean suppressValueChanged = false;
    private final AirspacesFilterCollapsablePanel mainPanel;

    public AirspaceTypeVisibilityDataTable(AirspacesFilterCollapsablePanel mainPanel, List<AirspaceTypeVisibilityRow> values) {
        super(new AirspaceTypeVisibilityTableModel());
        this.getTable().setTableHeader(null);
        this.getTable().getColumnModel().getColumn(2).setMaxWidth(40);
        this.getTable().getColumnModel().getColumn(1).setMaxWidth(55);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(2);
        this.getTable().getColumnModel().getColumn(0).setCellRenderer(renderer);
        this.getTable().getColumnModel().getColumn(0).setMinWidth(100);
        if (values != null) {
            this.addRows(values);
        }
        this.disableMouseWheel();
        this.mainPanel = mainPanel;
        this.setPreferredSize(new Dimension(270, 170));
        this.getModel().addTableModelListener(this);
    }

    public void setData(List<AirspaceTypeVisibilityRow> values) {
        this.clear();
        this.addRows(values);
    }

    public void clear() {
        while (this.getModel().getRowCount() > 0) {
            this.getModel().removeRow(0);
        }
    }

    public void addRows(List<AirspaceTypeVisibilityRow> values) {
        AirspaceTypeVisibilityTableModel model = this.getModel();
        Collections.sort(values);
        for (AirspaceTypeVisibilityRow row : values) {
            model.addRow(row);
        }
    }

    public void setValue(String key, Boolean value) {
        for (int i = 0; i < this.getModel().getRowCount(); ++i) {
            if (!key.equals(this.getModel().getKeyAt(i))) continue;
            this.getModel().setValueAt(value, i, 2);
            break;
        }
    }

    public void toggleValue(String key) {
        for (int i = 0; i < this.getModel().getRowCount(); ++i) {
            if (!key.equals(this.getModel().getKeyAt(i))) continue;
            this.getModel().setValueAt((Boolean)this.getModel().getValueAt(i, 2) == false, i, 2);
            break;
        }
    }

    public Map<String, Boolean> getData() {
        AirspaceTypeVisibilityTableModel model = this.getModel();
        LinkedHashMap<String, Boolean> result = new LinkedHashMap<String, Boolean>();
        for (int row = 0; row < model.getRowCount(); ++row) {
            result.put(model.getKeyAt(row), model.getValueAt(row));
        }
        return result;
    }

    public boolean deselectAll() {
        AirspaceTypeVisibilityTableModel model = this.getModel();
        for (int row = 0; row < model.getRowCount(); ++row) {
            this.getModel().setValueAt(Boolean.FALSE, row, 2);
        }
        return true;
    }

    public boolean selectAll() {
        AirspaceTypeVisibilityTableModel model = this.getModel();
        for (int row = 0; row < model.getRowCount(); ++row) {
            this.getModel().setValueAt(Boolean.TRUE, row, 2);
        }
        return true;
    }

    public boolean isAllUnchecked() {
        AirspaceTypeVisibilityTableModel model = this.getModel();
        for (int row = 0; row < model.getRowCount(); ++row) {
            if (!Boolean.TRUE.equals(model.getValueAt(row))) continue;
            return false;
        }
        return true;
    }

    public boolean isAnySelected() {
        AirspaceTypeVisibilityTableModel model = this.getModel();
        for (int row = 0; row < model.getRowCount(); ++row) {
            if (!Boolean.TRUE.equals(model.getValueAt(row))) continue;
            return true;
        }
        return false;
    }

    @Override
    public AirspaceTypeVisibilityTableModel getModel() {
        return (AirspaceTypeVisibilityTableModel)this.table.getModel();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (!this.suppressValueChanged && 2 == e.getColumn()) {
            this.mainPanel.visibilityTableAction(this.getModel().getKeyAt(e.getFirstRow()), this.getModel().getValueAt(e.getFirstRow()));
        }
    }
}

