/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.table;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.table.DefaultTableCellRenderer;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.core.table.NavaidsRow;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.table.StrippedDataTable;
import main.java.guru.vfrflight.gui.table.model.AirportInfoNavaidsTableModel;
import main.java.guru.vfrflight.sql.facade.NavaidFacade;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.GpsUtil;

public class AirportInfoNavaidsDataTable
extends StrippedDataTable
implements MouseListener {
    private static final long serialVersionUID = -2682344090206471501L;
    private List<NavaidsRow> rows;

    public AirportInfoNavaidsDataTable(GpsPlace airportCenter, Double magvar) {
        super(new AirportInfoNavaidsTableModel());
        this.getTable().getColumnModel().getColumn(1).setMaxWidth(50);
        this.getTable().getColumnModel().getColumn(0).setMaxWidth(50);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(0);
        for (int i = 0; i < this.getModel().getColumnCount(); ++i) {
            this.getTable().getColumnModel().getColumn(i).setCellRenderer(renderer);
        }
        NavaidFacade navaidFacade = new NavaidFacade(DBUtil.getDataSource());
        Set<GpsPlace> navaidsList = navaidFacade.findInRadius(airportCenter, 100.0, true, false, false);
        navaidsList.addAll(navaidFacade.findInRadius(airportCenter, 10.0, false, true, true));
        ArrayList<NavaidsRow> rows = new ArrayList<NavaidsRow>();
        for (GpsPlace p : navaidsList) {
            NavaidsRow n = new NavaidsRow();
            n.setType(p.getType());
            n.setIdent(p.getName());
            if ("VOR".equals(p.getType()) || "VOR-DME".equals(p.getType()) || "DME".equals(p.getType())) {
                n.setFreq(FormatUtil.formatVorFrequency(p.getDataInt("freq")));
            } else {
                n.setFreq(FormatUtil.formatNdbFrequency(p.getDataInt("freq")));
            }
            LineSegment seg = GpsUtil.getVorRadial(p, airportCenter);
            n.setRadDist(FormatUtil.formatRadial(seg));
            n.setDist(seg.getDiagonalDistance() != null ? seg.getDiagonalDistance() : seg.getDistance());
            n.setPlace(p);
            rows.add(n);
        }
        Collections.sort(rows);
        this.addRows(rows);
        this.getTable().addMouseListener(this);
    }

    public void addRows(List<NavaidsRow> rows) {
        AirportInfoNavaidsTableModel model = (AirportInfoNavaidsTableModel)this.getModel();
        this.rows = rows;
        for (NavaidsRow row : rows) {
            model.addRow(row);
        }
    }

    public List<NavaidsRow> getRows() {
        return this.rows;
    }

    public void setRows(List<NavaidsRow> rows) {
        this.rows = rows;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.showPointOnMap(this.getTable().getSelectedRow());
        }
    }

    public void showPointOnMap(int i) {
        MapFrame.getInstance().centerOnPoint(this.rows.get(i).getPlace(), 7);
        MapFrame.getInstance().setMarkerPlace(this.rows.get(i).getPlace());
        MapFrame.getInstance().updateMap();
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }
}

