/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.table;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.DefaultTableCellRenderer;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.Ils;
import main.java.guru.vfrflight.core.sql.entity.Runway;
import main.java.guru.vfrflight.core.table.RunwayRow;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.table.StrippedDataTable;
import main.java.guru.vfrflight.gui.table.model.AirportInfoTableModel;

public class AirportInfoDataTable
extends StrippedDataTable
implements MouseListener {
    private static final long serialVersionUID = -6425637939086993730L;
    private Double magvar;
    private List<RunwayRow> rows;

    public AirportInfoDataTable(List<Runway> runways, Double magvar) {
        super(new AirportInfoTableModel());
        this.magvar = magvar;
        this.getTable().getColumnModel().getColumn(0).setMaxWidth(60);
        this.getTable().getColumnModel().getColumn(1).setMinWidth(90);
        this.getTable().getColumnModel().getColumn(4).setMinWidth(90);
        this.getTable().getColumnModel().getColumn(5).setMinWidth(110);
        this.getTable().getColumnModel().getColumn(6).setMaxWidth(50);
        this.getTable().getColumnModel().getColumn(7).setMaxWidth(50);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(0);
        for (int i = 0; i < this.getModel().getColumnCount() - 2; ++i) {
            this.getTable().getColumnModel().getColumn(i).setCellRenderer(renderer);
        }
        ArrayList<RunwayRow> rows = new ArrayList<RunwayRow>();
        for (Runway rwy : runways) {
            rows.addAll(this.getRunwayRows(rwy));
        }
        Collections.sort(rows);
        this.addRows(rows);
        this.getTable().addMouseListener(this);
    }

    public void addRows(List<RunwayRow> rows) {
        AirportInfoTableModel model = (AirportInfoTableModel)this.getModel();
        this.rows = rows;
        for (RunwayRow row : rows) {
            model.addRow(row);
        }
    }

    public List<RunwayRow> getRows() {
        AirportInfoTableModel model = (AirportInfoTableModel)this.getModel();
        return model.getRows();
    }

    private List<RunwayRow> getRunwayRows(Runway rwy) {
        ArrayList<RunwayRow> rows = new ArrayList<RunwayRow>();
        GpsPlace rwyCenter = null;
        if (rwy.getLat() != null && rwy.getLon() != null) {
            rwyCenter = new GpsPlace(new GpsCoord(rwy.getLat()), new GpsCoord(rwy.getLon()));
        }
        if (rwy.getHeading() != null) {
            RunwayRow primaryRow = new RunwayRow();
            primaryRow.setName(rwy.getPrimaryName());
            primaryRow.setHeading((int)Math.round(rwy.getHeading()));
            primaryRow.setLength((int)Math.round(rwy.getLength()));
            primaryRow.setWidth((int)Math.round(rwy.getWidth()));
            if (rwy.getSurface() != null) {
                primaryRow.setType(Messages.getInstance().get("surface_type_" + rwy.getSurface().toString().toLowerCase()));
            }
            primaryRow.setPlace(rwyCenter);
            this.setIls(rwy.getIls(), primaryRow, true);
            rows.add(primaryRow);
            RunwayRow secondaryRow = new RunwayRow();
            secondaryRow.setName(rwy.getSecondaryName());
            secondaryRow.setHeading((int)Math.round(rwy.getSecondaryHeading()));
            secondaryRow.setLength((int)Math.round(rwy.getLength()));
            secondaryRow.setWidth((int)Math.round(rwy.getWidth()));
            if (rwy.getSurface() != null) {
                secondaryRow.setType(Messages.getInstance().get("surface_type_" + rwy.getSurface().toString().toLowerCase()));
            }
            secondaryRow.setPlace(rwyCenter);
            this.setIls(rwy.getIls(), secondaryRow, false);
            rows.add(secondaryRow);
        } else if (rwy.getDesc() != null) {
            RunwayRow primaryRow = new RunwayRow();
            primaryRow.setName(rwy.getDesc());
            if (rwy.getLength() != null) {
                primaryRow.setLength((int)Math.round(rwy.getLength()));
            }
            if (rwy.getWidth() != null) {
                primaryRow.setWidth((int)Math.round(rwy.getWidth()));
            }
            if (rwy.getSurface() != null) {
                primaryRow.setType(Messages.getInstance().get("surface_type_" + rwy.getSurface().toString().toLowerCase()));
            }
            primaryRow.setPlace(rwyCenter);
            rows.add(primaryRow);
        }
        return rows;
    }

    public Double getMagvar() {
        return this.magvar;
    }

    public void setMagvar(Double magvar) {
        this.magvar = magvar;
    }

    private void setIls(List<Ils> ilsList, RunwayRow row, boolean primaryRunway) {
        for (Ils ils : ilsList) {
            if (!(Math.abs((double)row.getHeading().intValue() - ils.getMagHeading()) <= 45.0)) continue;
            row.setDme(ils.isDme());
            row.setGs(ils.isGs());
            row.setIls(ils.getIdent() + " " + ils.getFrequency() + "/" + Math.round(ils.getMagHeading()) + "\u00b0");
            break;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.showPointOnMap(this.getTable().getSelectedRow());
        }
    }

    public void showPointOnMap(int i) {
        GpsPlace center = this.rows.get(i).getPlace();
        if (center != null) {
            MapFrame.getInstance().centerOnPoint(center, 4);
            MapFrame.getInstance().setMarkerPlace(center);
            MapFrame.getInstance().updateMap();
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }
}

