/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.swing.textfield;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import main.java.guru.vfrflight.gui.swing.DigitsFilter;
import main.java.guru.vfrflight.gui.swing.PositiveDigitsFilter;
import org.hsqldb.lib.StringUtil;

public class IntegerTextField
extends JTextField
implements FocusListener,
KeyListener {
    private static final long serialVersionUID = 3343430496534657546L;
    public static final int POSITIVE_AND_NEGATIVE_VALUES = 0;
    public static final int POSITIVE_VALUES_ONLY = 1;
    protected boolean suppressChanged = false;
    protected Integer value;
    private boolean nullable = true;
    private Integer minValue;
    private Integer maxValue;

    public IntegerTextField() {
        this(0);
    }

    public IntegerTextField(int type) {
        this.setHorizontalAlignment(0);
        if (type == 0) {
            ((AbstractDocument)this.getDocument()).setDocumentFilter(new DigitsFilter());
        } else {
            ((AbstractDocument)this.getDocument()).setDocumentFilter(new PositiveDigitsFilter());
        }
        this.addFocusListener(this);
        this.addKeyListener(this);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.updateValue();
    }

    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer value) {
        this.value = value;
        if (value == null) {
            this.setText("");
        } else {
            this.setText(String.valueOf(value));
        }
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.updateValue();
    }

    public boolean hasValue() {
        return this.getValue() != null;
    }

    protected void updateValue() {
        if (!this.suppressChanged) {
            if (StringUtil.isEmpty(this.getText())) {
                if (this.nullable) {
                    this.value = null;
                    super.setText("");
                } else {
                    this.value = this.minValue != null ? this.minValue : Integer.valueOf(0);
                    super.setText(String.valueOf(this.value));
                }
            } else {
                try {
                    this.value = Integer.valueOf(this.getText());
                    if (this.minValue != null && this.value < this.minValue) {
                        this.value = this.minValue;
                        this.setText(String.valueOf(this.minValue));
                    } else if (this.maxValue != null && this.value > this.maxValue) {
                        this.value = this.maxValue;
                        super.setText(String.valueOf(this.minValue));
                    }
                }
                catch (NumberFormatException ex) {
                    if (this.value == null) {
                        super.setText("");
                    }
                    super.setText(String.valueOf(this.value));
                }
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (10 == e.getKeyCode()) {
            this.updateValue();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public boolean isSuppressChanged() {
        return this.suppressChanged;
    }

    public void setSuppressChanged(boolean suppressChanged) {
        this.suppressChanged = suppressChanged;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public Integer getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Integer minValue) {
        this.minValue = minValue;
    }

    public Integer getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Integer maxValue) {
        this.maxValue = maxValue;
    }
}

