/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.swing.textfield;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import main.java.guru.vfrflight.gui.swing.DecimalFilter;
import main.java.guru.vfrflight.gui.swing.PositiveDecimalFilter;
import org.hsqldb.lib.StringUtil;

public class DecimalTextField
extends JTextField
implements FocusListener,
KeyListener {
    private static final long serialVersionUID = 4119088604217775855L;
    public static final int POSITIVE_AND_NEGATIVE_VALUES = 0;
    public static final int POSITIVE_VALUES_ONLY = 1;
    private Double value;

    public DecimalTextField() {
        this(0);
        this.setHorizontalAlignment(0);
    }

    public DecimalTextField(int type) {
        if (type == 0) {
            ((AbstractDocument)this.getDocument()).setDocumentFilter(new DecimalFilter());
        } else {
            ((AbstractDocument)this.getDocument()).setDocumentFilter(new PositiveDecimalFilter());
        }
        this.addFocusListener(this);
        this.addKeyListener(this);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.updateValue();
    }

    public Double getValue() {
        return this.value;
    }

    public boolean hasValue() {
        return this.getValue() != null;
    }

    public void setValue(Double value) {
        this.value = value;
        if (value == null) {
            this.setText("");
        } else {
            this.setText(String.valueOf(value));
        }
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.updateValue();
    }

    private void updateValue() {
        if (StringUtil.isEmpty(this.getText())) {
            this.value = null;
        } else {
            try {
                this.value = Double.valueOf(this.getText());
            }
            catch (NumberFormatException ex) {
                this.setValue(this.value);
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (10 == e.getKeyCode()) {
            this.updateValue();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

