/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.swing.popup;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.core.gps.GpsPoint;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.map.listener.AddNewPointListener;
import main.java.guru.vfrflight.gui.swing.panel.vertical.profile.VerticalProfilePanel;
import main.java.guru.vfrflight.util.MapUtil;
import main.java.guru.vfrflight.util.VfrUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;

public class VerticalPanelPopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = -8658087926173038865L;

    public VerticalPanelPopupMenu(final VerticalProfilePanel panel, int x, int y) {
        int pointIdx;
        int index;
        boolean addSeparator = false;
        int width = panel.getSamples().length * panel.getZoom();
        int cursorX = (int)Math.floor((x - 50) / panel.getZoom());
        if (cursorX >= 0 && x < width && panel.getSamples()[cursorX] != null && (index = panel.getSegmentIndexAtPosition(x, y)) >= 0) {
            double terrainElev;
            JMenuItem addItem = new JMenuItem(Messages.getInstance().get("popup_menu_add_point_here"));
            GpsPoint point = MapUtil.getMapPosition((JXMapViewer)MapFrame.getInstance().getMapViewer(), panel.getSamples()[cursorX].getGpsPlace());
            Double[] coofs = VfrUtil.getLinearEquation(panel.getPoints().get(index).getPoint(), panel.getPoints().get(index + 1).getPoint());
            Double alt = panel.calculatePointsToAltitude(coofs[0] * (double)x + coofs[1]);
            if (panel.isLimitAltToTerrain() && (terrainElev = (double)panel.getSamples()[cursorX].getElev().shortValue()) > alt) {
                alt = terrainElev;
            }
            addItem.addActionListener(new AddNewPointListener((int)Math.round(((Point2D)point).getX()), (int)Math.round(((Point2D)point).getY()), Double.valueOf(Math.round(alt)), panel, index));
            this.add(addItem);
            addSeparator = true;
        }
        if ((pointIdx = panel.getPointsIndexAt(x, y)) >= 0 && panel.getPoints().get(pointIdx).isNewlyAdded()) {
            JMenuItem deleteItem = new JMenuItem(Messages.getInstance().get("delete"));
            deleteItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MapFrame.getInstance().getUIPanel().delPtsAction(pointIdx);
                    panel.calculatePointsPositions();
                    panel.repaint();
                    MapFrame.getInstance().getUIPanel().updateRoutePointsInfoLabel();
                    MapFrame.getInstance().updateMap();
                }
            });
            this.add(deleteItem);
            addSeparator = true;
        }
        if (addSeparator) {
            this.add(new JSeparator());
        }
        if (pointIdx >= 0) {
            JMenuItem setAltitude = new JMenuItem(Messages.getInstance().get("popup_menu_set_altitude"));
            setAltitude.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    panel.setAltitude(pointIdx);
                }
            });
            this.add(setAltitude);
            this.add(new JSeparator());
        }
        JCheckBoxMenuItem limitAltitudeToTerrain = new JCheckBoxMenuItem(Messages.getInstance().get("popup_menu_limit_altitude_to_terrain"), panel.isLimitAltToTerrain());
        limitAltitudeToTerrain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel.setLimitAltToTerrain(!panel.isLimitAltToTerrain());
            }
        });
        this.add(limitAltitudeToTerrain);
        JCheckBoxMenuItem showPositionInTheMap = new JCheckBoxMenuItem(Messages.getInstance().get("popup_menu_show_position_in_the_map"), panel.isShowPositionInTheMap());
        showPositionInTheMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel.getWrapperPanel().getPosInMap().toggle();
                panel.getWrapperPanel().getPosInMap().doClick();
            }
        });
        this.add(showPositionInTheMap);
        JCheckBoxMenuItem showRouteAltitude = new JCheckBoxMenuItem(Messages.getInstance().get("popup_menu_show_route_altitude"), panel.isShowRouteAltitude());
        showRouteAltitude.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel.getWrapperPanel().getShowRouteAltitude().toggle();
                panel.getWrapperPanel().getShowRouteAltitude().doClick();
            }
        });
        this.add(showRouteAltitude);
        JCheckBoxMenuItem showDistance = new JCheckBoxMenuItem(Messages.getInstance().get("popup_menu_show_altitude_and_distance"), panel.isShowAltitudeAndDistance());
        showDistance.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel.getWrapperPanel().getShowDistance().toggle();
                panel.getWrapperPanel().getShowDistance().doClick();
            }
        });
        this.add(showDistance);
        JCheckBoxMenuItem showMSAs = new JCheckBoxMenuItem(Messages.getInstance().get("popup_menu_show_msas"), panel.isShowMSAs());
        showMSAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel.getWrapperPanel().getShowMSAs().toggle();
                panel.getWrapperPanel().getShowMSAs().doClick();
            }
        });
        this.add(showMSAs);
        if (panel.anyAirspaces()) {
            this.add(new JSeparator());
            JMenu airspacesMenu = new JMenu(Messages.getInstance().get("popup_menu_airspaces"));
            this.add(airspacesMenu);
            JCheckBoxMenuItem showViolatedAirspaces = new JCheckBoxMenuItem(Messages.getInstance().get("popup_menu_show_violated_airspaces_only"), panel.isShowOnlyViolatedAirspaces());
            showViolatedAirspaces.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    panel.setShowOnlyViolatedAirspaces(!panel.isShowOnlyViolatedAirspaces());
                    panel.setShowOnlyAirspacesInVerticalProfile(!panel.isShowOnlyViolatedAirspaces());
                    panel.showOnlyViolatedAirspacesAction();
                }
            });
            airspacesMenu.add(showViolatedAirspaces);
            JCheckBoxMenuItem showAirspacesInVerticalProfile = new JCheckBoxMenuItem(Messages.getInstance().get("popup_menu_show_airspaces_in_vertical_profile_only"), panel.isShowOnlyAirspacesInVerticalProfile());
            showAirspacesInVerticalProfile.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    panel.setShowOnlyAirspacesInVerticalProfile(!panel.isShowOnlyAirspacesInVerticalProfile());
                    panel.setShowOnlyViolatedAirspaces(!panel.isShowOnlyAirspacesInVerticalProfile());
                    panel.showOnlyAirspacesInVerticalProfileAction();
                }
            });
            airspacesMenu.add(showAirspacesInVerticalProfile);
            airspacesMenu.add(new JSeparator());
            JCheckBoxMenuItem showAllAirspaces = new JCheckBoxMenuItem(Messages.getInstance().get("popup_menu_show_all_airspaces"), !panel.isShowOnlyAirspacesInVerticalProfile() && !panel.isShowOnlyViolatedAirspaces());
            showAllAirspaces.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    panel.setShowOnlyAirspacesInVerticalProfile(false);
                    panel.setShowOnlyViolatedAirspaces(false);
                    panel.showOnlyAirspacesInVerticalProfileAction();
                }
            });
            airspacesMenu.add(showAllAirspaces);
        }
        this.add(new JSeparator());
        JCheckBoxMenuItem lockCursorPosition = new JCheckBoxMenuItem(Messages.getInstance().get("popup_menu_lock_cursor_position"), panel.isLockCursorPosition());
        lockCursorPosition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel.getWrapperPanel().getLockCursorPosition().toggle();
                panel.getWrapperPanel().getLockCursorPosition().doClick();
            }
        });
        this.add(lockCursorPosition);
    }
}

