/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.swing.popup;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.swing.panel.track.UserTrackAnalyzerPanel;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.SimConnectUtil;

public class UserTrackPanelPopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = -140010089325569013L;

    public UserTrackPanelPopupMenu(final UserTrackAnalyzerPanel panel, int x, int y) {
        JCheckBoxMenuItem showPositionOnMap = new JCheckBoxMenuItem(Messages.getInstance().get("popup_menu_show_position_on_map"), panel.isDrawPositionOnMap());
        showPositionOnMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel.setDrawPositionOnMap(!panel.isDrawPositionOnMap());
                if (SimConnectUtil.getInstance().getSelectedUserTrackPoint() != null) {
                    SimConnectUtil.getInstance().setSelectedUserTrackPoint(null);
                } else {
                    SimConnectUtil.getInstance().setSelectedUserTrackPoint(panel.getCurrentIndex());
                }
                MapFrame.getInstance().updateMap();
            }
        });
        this.add(showPositionOnMap);
        if (!panel.isShowMouseInfo()) {
            JCheckBoxMenuItem followMousePosition = new JCheckBoxMenuItem(Messages.getInstance().get("popup_menu_follow_mouse_position"), panel.isFollowMousePosition());
            followMousePosition.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    panel.setFollowMousePosition(!panel.isFollowMousePosition());
                    panel.repaint();
                }
            });
            this.add(followMousePosition);
        }
        if (!panel.isFollowMousePosition()) {
            JCheckBoxMenuItem showMouseInfo = new JCheckBoxMenuItem(Messages.getInstance().get("popup_menu_show_mouse_info"), panel.isShowMouseInfo());
            showMouseInfo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    panel.setShowMouseInfo(!panel.isShowMouseInfo());
                    panel.repaint();
                }
            });
            this.add(showMouseInfo);
        }
        if (panel.getFpsStats() != null) {
            JMenu fpsMenu = new JMenu(Messages.getInstance().get("popup_menu_fps_menu"));
            this.add(fpsMenu);
            JCheckBoxMenuItem showFps = new JCheckBoxMenuItem(Messages.getInstance().get("popup_menu_show_fps"), panel.isShowFps());
            showFps.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    panel.setShowFps(!panel.isShowFps());
                    panel.repaint();
                }
            });
            fpsMenu.add(showFps);
            JCheckBoxMenuItem showFpsLines = new JCheckBoxMenuItem(Messages.getInstance().get("popup_menu_show_fps_lines"), panel.isShowFpsLines());
            showFpsLines.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    panel.setShowFpsLines(!panel.isShowFpsLines());
                    if (panel.isShowFpsLines()) {
                        panel.setShowFps(true);
                    }
                    panel.repaint();
                }
            });
            fpsMenu.add(showFpsLines);
            fpsMenu.add(new JSeparator());
            JMenuItem getFpsStats = new JMenuItem(Messages.getInstance().get("popup_menu_get_fps_stats"));
            getFpsStats.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    panel.getFpsStatsAction();
                }
            });
            fpsMenu.add(getFpsStats);
        }
        this.add(new JSeparator());
        JMenu replaySpeedMenu = new JMenu(Messages.getInstance().get("popup_menu_replay_speed"));
        this.add(replaySpeedMenu);
        JCheckBoxMenuItem replaySpeed1_8 = new JCheckBoxMenuItem(Messages.getInstance().get("popup_menu_replay_speed_1_8"), NumberUtil.floatEqualsFloat(panel.getMainDialog().getReplaySpeed(), 0.125f));
        replaySpeed1_8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel.getMainDialog().changeReplaySpeed(0.125f);
            }
        });
        replaySpeedMenu.add(replaySpeed1_8);
        JCheckBoxMenuItem replaySpeed1_4 = new JCheckBoxMenuItem(Messages.getInstance().get("popup_menu_replay_speed_1_4"), NumberUtil.floatEqualsFloat(panel.getMainDialog().getReplaySpeed(), 0.25f));
        replaySpeed1_4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel.getMainDialog().changeReplaySpeed(0.25f);
            }
        });
        replaySpeedMenu.add(replaySpeed1_4);
        JCheckBoxMenuItem replaySpeed1_2 = new JCheckBoxMenuItem(Messages.getInstance().get("popup_menu_replay_speed_1_2"), NumberUtil.floatEqualsFloat(panel.getMainDialog().getReplaySpeed(), 0.5f));
        replaySpeed1_2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel.getMainDialog().changeReplaySpeed(0.5f);
            }
        });
        replaySpeedMenu.add(replaySpeed1_2);
        JCheckBoxMenuItem replaySpeed1 = new JCheckBoxMenuItem(Messages.getInstance().get("popup_menu_replay_speed_1"), NumberUtil.floatEqualsFloat(panel.getMainDialog().getReplaySpeed(), 1.0f));
        replaySpeed1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel.getMainDialog().changeReplaySpeed(1.0f);
            }
        });
        replaySpeedMenu.add(replaySpeed1);
        JCheckBoxMenuItem replaySpeed2 = new JCheckBoxMenuItem(Messages.getInstance().get("popup_menu_replay_speed_2"), NumberUtil.floatEqualsFloat(panel.getMainDialog().getReplaySpeed(), 2.0f));
        replaySpeed2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel.getMainDialog().changeReplaySpeed(2.0f);
            }
        });
        replaySpeedMenu.add(replaySpeed2);
        JCheckBoxMenuItem replaySpeed4 = new JCheckBoxMenuItem(Messages.getInstance().get("popup_menu_replay_speed_4"), NumberUtil.floatEqualsFloat(panel.getMainDialog().getReplaySpeed(), 4.0f));
        replaySpeed4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel.getMainDialog().changeReplaySpeed(4.0f);
            }
        });
        replaySpeedMenu.add(replaySpeed4);
        JCheckBoxMenuItem replaySpeed8 = new JCheckBoxMenuItem(Messages.getInstance().get("popup_menu_replay_speed_8"), NumberUtil.floatEqualsFloat(panel.getMainDialog().getReplaySpeed(), 8.0f));
        replaySpeed8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel.getMainDialog().changeReplaySpeed(8.0f);
            }
        });
        replaySpeedMenu.add(replaySpeed8);
        JCheckBoxMenuItem replaySpeed16 = new JCheckBoxMenuItem(Messages.getInstance().get("popup_menu_replay_speed_16"), NumberUtil.floatEqualsFloat(panel.getMainDialog().getReplaySpeed(), 16.0f));
        replaySpeed16.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel.getMainDialog().changeReplaySpeed(16.0f);
            }
        });
        replaySpeedMenu.add(replaySpeed16);
        this.add(new JSeparator());
        if (panel.getCurrentUserBean().isOnGround()) {
            JMenuItem findTakeOff = new JMenuItem(Messages.getInstance().get("popup_menu_find_take_off"));
            findTakeOff.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    panel.findTakeOff();
                }
            });
            this.add(findTakeOff);
        } else {
            JMenuItem findTouchDown = new JMenuItem(Messages.getInstance().get("popup_menu_find_touch_down"));
            findTouchDown.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    panel.findTouchDown();
                }
            });
            this.add(findTouchDown);
        }
        this.add(new JSeparator());
        JMenuItem exportToGoogleEarth = new JMenuItem(Messages.getInstance().get("popup_menu_export_track_to_ge"));
        exportToGoogleEarth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimConnectUtil.exportUserTrackToGoogleEarthAction(SimConnectUtil.getInstance().getUserTrack());
            }
        });
        this.add(exportToGoogleEarth);
        JMenuItem exportToCsv = new JMenuItem(Messages.getInstance().get("popup_menu_export_track_to_csv"));
        exportToCsv.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimConnectUtil.exportUserTrackToCsvAction(SimConnectUtil.getInstance().getUserTrack());
            }
        });
        this.add(exportToCsv);
        if (SimConnectUtil.getInstance().getSelectionStart() != null && SimConnectUtil.getInstance().getSelectionEnd() != null) {
            this.add(new JSeparator());
            JMenuItem clearSelection = new JMenuItem(Messages.getInstance().get("popup_menu_clear_selection"));
            clearSelection.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    panel.selectionClearAction();
                }
            });
            this.add(clearSelection);
            this.add(new JSeparator());
            JCheckBoxMenuItem exportSelectedToGoogleEarth = new JCheckBoxMenuItem(Messages.getInstance().get("popup_menu_export_selected_to_ge"));
            exportSelectedToGoogleEarth.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SimConnectUtil.exportUserTrackToGoogleEarthAction(panel.getUserTrack().subList(SimConnectUtil.getInstance().getSelectionStart(), SimConnectUtil.getInstance().getSelectionEnd() + 1));
                }
            });
            this.add(exportSelectedToGoogleEarth);
            JCheckBoxMenuItem exportSelectedToCsv = new JCheckBoxMenuItem(Messages.getInstance().get("popup_menu_export_selected_to_csv"));
            exportSelectedToCsv.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SimConnectUtil.exportUserTrackToCsvAction(panel.getUserTrack().subList(SimConnectUtil.getInstance().getSelectionStart(), SimConnectUtil.getInstance().getSelectionEnd() + 1));
                }
            });
            this.add(exportSelectedToCsv);
        }
    }
}

