/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.swing.panel.vertical.profile;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.border.EtchedBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.dto.AirspaceAreaDTO;
import main.java.guru.vfrflight.core.sql.entity.Elevation;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.VerticalProfileMainDialog;
import main.java.guru.vfrflight.gui.swing.button.ToolbarButton;
import main.java.guru.vfrflight.gui.swing.button.ToolbarStateButton;
import main.java.guru.vfrflight.gui.swing.panel.vertical.profile.VerticalProfilePanel;

public class VerticalProfileWrapperPanel
extends JPanel {
    private static final long serialVersionUID = -3472974431337991202L;
    private final VerticalProfileMainDialog verticalProfileMainDialog;
    private final VerticalProfilePanel mainPanel;
    private ToolbarStateButton lockCursorPosition;
    private ToolbarStateButton posInMap;
    private ToolbarStateButton showDistance;
    private ToolbarStateButton showRouteAltitude;
    private ToolbarStateButton showMSAs;

    public VerticalProfileWrapperPanel(MapFrame mapDialog, VerticalProfileMainDialog verticalProfileMainDialog, BufferedImage image, Elevation[] samples, int maxHeight, List<AirspaceAreaDTO> airspaces) {
        this.verticalProfileMainDialog = verticalProfileMainDialog;
        this.setLayout(new BorderLayout(0, 0));
        this.mainPanel = new VerticalProfilePanel(mapDialog, this, image, samples, maxHeight, airspaces);
        this.mainPanel.setBackground(Color.LIGHT_GRAY);
        JScrollPane scrollPane = new JScrollPane(this.mainPanel);
        scrollPane.setHorizontalScrollBarPolicy(32);
        scrollPane.setVerticalScrollBarPolicy(21);
        this.add((Component)scrollPane, "Center");
        JPanel buttonPanel = new JPanel();
        this.add((Component)buttonPanel, "North");
        buttonPanel.setLayout(new BorderLayout(0, 0));
        JPanel toolbarWrapperPanel = new JPanel();
        buttonPanel.add((Component)toolbarWrapperPanel, "Center");
        this.createToolbar(toolbarWrapperPanel);
        JPanel toolbarClosePanelWrapperPanel = new JPanel();
        buttonPanel.add((Component)toolbarClosePanelWrapperPanel, "East");
        this.createClosePanelToolbar(toolbarClosePanelWrapperPanel);
    }

    private void createToolbar(JPanel parentPanel) {
        JToolBar toolBar = new JToolBar();
        toolBar.setBorder(new EtchedBorder(1, null, null));
        toolBar.setFloatable(false);
        parentPanel.add(toolBar);
        this.posInMap = new ToolbarStateButton("img/gui/pos_in_map.png", Messages.getInstance().get("popup_menu_show_position_in_the_map"), this.mainPanel.isShowPositionInTheMap(), SettingsBean.getInstance().isTouchScreenMode());
        this.posInMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VerticalProfileWrapperPanel.this.mainPanel.setShowPositionInTheMap(!VerticalProfileWrapperPanel.this.mainPanel.isShowPositionInTheMap());
            }
        });
        toolBar.add(this.posInMap);
        this.showDistance = new ToolbarStateButton("img/gui/alt_and_dist.png", Messages.getInstance().get("popup_menu_show_altitude_and_distance"), this.mainPanel.isShowAltitudeAndDistance(), SettingsBean.getInstance().isTouchScreenMode());
        this.showDistance.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VerticalProfileWrapperPanel.this.mainPanel.setShowAltitudeDistance(!VerticalProfileWrapperPanel.this.mainPanel.isShowAltitudeAndDistance());
                VerticalProfileWrapperPanel.this.mainPanel.repaint();
            }
        });
        toolBar.add(this.showDistance);
        this.showRouteAltitude = new ToolbarStateButton("img/gui/route_alt.png", Messages.getInstance().get("popup_menu_show_route_altitude"), this.mainPanel.isShowRouteAltitude(), SettingsBean.getInstance().isTouchScreenMode());
        this.showRouteAltitude.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VerticalProfileWrapperPanel.this.mainPanel.setShowRouteAltitude(!VerticalProfileWrapperPanel.this.mainPanel.isShowRouteAltitude());
                VerticalProfileWrapperPanel.this.mainPanel.repaint();
            }
        });
        toolBar.add(this.showRouteAltitude);
        this.showMSAs = new ToolbarStateButton("img/gui/layer_msa.png", Messages.getInstance().get("popup_menu_show_msas"), this.mainPanel.isShowMSAs(), SettingsBean.getInstance().isTouchScreenMode());
        this.showMSAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VerticalProfileWrapperPanel.this.mainPanel.setShowMSAs(!VerticalProfileWrapperPanel.this.mainPanel.isShowMSAs());
                VerticalProfileWrapperPanel.this.mainPanel.repaint();
            }
        });
        toolBar.add(this.showMSAs);
        toolBar.addSeparator();
        this.lockCursorPosition = new ToolbarStateButton("img/gui/lock_cursor.png", Messages.getInstance().get("popup_menu_lock_cursor_position"), this.mainPanel.isLockCursorPosition(), SettingsBean.getInstance().isTouchScreenMode());
        this.lockCursorPosition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VerticalProfileWrapperPanel.this.mainPanel.setLockCursorPosition(!VerticalProfileWrapperPanel.this.mainPanel.isLockCursorPosition());
            }
        });
        toolBar.add(this.lockCursorPosition);
        toolBar.addSeparator();
        ToolbarButton zoomOut = new ToolbarButton("img/gui/zoom_out.png", "-", SettingsBean.getInstance().isTouchScreenMode());
        zoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VerticalProfileWrapperPanel.this.mainPanel.changeZoom(-1);
            }
        });
        toolBar.add(zoomOut);
        ToolbarButton zoomIn = new ToolbarButton("img/gui/zoom_in.png", "+", SettingsBean.getInstance().isTouchScreenMode());
        zoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VerticalProfileWrapperPanel.this.mainPanel.changeZoom(1);
            }
        });
        toolBar.add(zoomIn);
    }

    public ToolbarStateButton getLockCursorPosition() {
        return this.lockCursorPosition;
    }

    public void setLockCursorPosition(ToolbarStateButton lockCursorPosition) {
        this.lockCursorPosition = lockCursorPosition;
    }

    private void createClosePanelToolbar(JPanel parentPanel) {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        parentPanel.add(toolBar);
        ToolbarButton closeButton = new ToolbarButton("img/gui/cross.png", Messages.getInstance().get("close_button"), SettingsBean.getInstance().isTouchScreenMode());
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VerticalProfileWrapperPanel.this.closeAction();
            }
        });
        toolBar.add(closeButton);
    }

    private void closeAction() {
        if (this.mainPanel.isShowOnlyAirspacesInVerticalProfile() || this.mainPanel.isShowOnlyViolatedAirspaces()) {
            MapObjectsBean.getInstance().setAirspaces(this.mainPanel.getPreviousMapAirspaces());
            MapObjectsBean.getInstance().setHighlightedMapShapes(null);
        }
        this.verticalProfileMainDialog.removeVerticalProfilePanel();
        MapObjectsBean.getInstance().setHighlightedMapShape(null);
        MapFrame.getInstance().updateMap();
    }

    public ToolbarStateButton getPosInMap() {
        return this.posInMap;
    }

    public void setPosInMap(ToolbarStateButton posInMap) {
        this.posInMap = posInMap;
    }

    public ToolbarStateButton getShowDistance() {
        return this.showDistance;
    }

    public void setShowDistance(ToolbarStateButton showDistance) {
        this.showDistance = showDistance;
    }

    public ToolbarStateButton getShowRouteAltitude() {
        return this.showRouteAltitude;
    }

    public void setShowRouteAltitude(ToolbarStateButton showRouteAltitude) {
        this.showRouteAltitude = showRouteAltitude;
    }

    public ToolbarStateButton getShowMSAs() {
        return this.showMSAs;
    }

    public void setShowMSAs(ToolbarStateButton showMSAs) {
        this.showMSAs = showMSAs;
    }
}

