/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.swing.panel.vertical.profile;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.VerticalProfileAirspace;
import main.java.guru.vfrflight.core.VerticalProfileMsa;
import main.java.guru.vfrflight.core.VerticalProfilePoint;
import main.java.guru.vfrflight.core.dto.AirspaceAreaDTO;
import main.java.guru.vfrflight.core.dto.TerrainElevationDTO;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.GpsPoint;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.core.gps.RoutePlace;
import main.java.guru.vfrflight.core.sql.entity.Elevation;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.map.shape.MapShape;
import main.java.guru.vfrflight.gui.swing.panel.image.CenteredImagePanel;
import main.java.guru.vfrflight.gui.swing.panel.vertical.profile.VerticalProfileWrapperPanel;
import main.java.guru.vfrflight.gui.swing.popup.VerticalPanelPopupMenu;
import main.java.guru.vfrflight.sql.facade.ElevationFacade;
import main.java.guru.vfrflight.util.AirspacesUtil;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.guru.vfrflight.util.MapUtil;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.VfrUtil;
import org.apache.log4j.Logger;

public class VerticalProfilePanel
extends CenteredImagePanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private static final long serialVersionUID = -405597455299509006L;
    private static final Logger log = Logger.getLogger(VerticalProfilePanel.class);
    private static final Font WAYPOINT_LABEL_FONT = new Font("SansSerif", 1, 14);
    private static final Font ALT_INFO_LABEL_FONT = new Font("SansSerif", 0, 10);
    private static final Font AIRSPACE_TEXT_FONT = new Font("SansSerif", 0, 9);
    private static final Font AIRSPACE_VIOLATED_TEXT_FONT = new Font("SansSerif", 1, 11);
    private static final Font SEGMENT_INFORMATION_LABEL_FONT = new Font("SansSerif", 1, 12);
    private static final BasicStroke BASIC_STROKE_2 = new BasicStroke(2.0f);
    private static final BasicStroke BASIC_STROKE_3 = new BasicStroke(3.0f);
    private static final BasicStroke BASIC_STROKE_4 = new BasicStroke(4.0f);
    private static final BasicStroke BASIC_STROKE_5 = new BasicStroke(5.0f);
    private static final Color COLOR_ALT_INFO_BACKGROUND = new Color(1.0f, 1.0f, 1.0f, 0.75f);
    private static final Color COLOR_ALT_INFO = Color.BLUE;
    private static final Color COLOR_CURSOR = new Color(1.0f, 0.25f, 0.1f, 0.5f);
    private static final int MAX_ZOOM = 10;
    public static final int BORDER = 50;
    private static final int SCALE_HEIGHT = 10;
    private static final int SCALE_MINIMUM_STEP = 75;
    private static final Font SCALE_FONT = new Font("SansSerif", 1, 12);
    private Double scaleDistance = null;
    private Double scaleStep = null;
    private Double scaleStepPrec = null;
    private Integer scaleStepsNum = null;
    private Double scaleStepWidth = null;
    private int prevMouseY = 0;
    private int selected = -1;
    private boolean mousePressed = false;
    private Elevation[] samples;
    private Integer cursorPos;
    private Integer mouseY;
    private double heightRatio = 1.0;
    private int minElevHeight = 0;
    private int maxHeight;
    private Double distanceRatio = null;
    private List<VerticalProfilePoint> points;
    private boolean limitAltToTerrain = false;
    private boolean showPositionInTheMap = true;
    private boolean lockCursorPosition = false;
    private boolean showRouteAltitude = true;
    private boolean showAltitudeAndDistance = false;
    private boolean showMSAs = true;
    private Double climbSpeedTas;
    private Double descentSpeedTas;
    private Double windSpeed;
    private Double windDirection;
    private int zoom = 1;
    private final MapFrame mapFrame;
    private final VerticalProfileWrapperPanel wrapperPanel;
    private final Double totalDistance;
    private List<VerticalProfileAirspace> airspaces;
    private List<AirspaceAreaDTO> airspacesDTOs;
    private List<VerticalProfileMsa> msas;
    private final List<VerticalProfilePoint> initPoints = new ArrayList<VerticalProfilePoint>();
    private Short maxElevation = null;
    private AirspaceAreaDTO[] previousMapAirspaces = null;
    private boolean showOnlyAirspacesInVerticalProfile = false;
    private boolean showOnlyViolatedAirspaces = true;

    public VerticalProfilePanel(MapFrame mapDialog, VerticalProfileWrapperPanel wrapperPanel, BufferedImage image, Elevation[] samples, int maxHeight, List<AirspaceAreaDTO> airspaces) {
        super(image);
        log.debug("Initializing VerticalProfilePanel ...");
        this.airspacesDTOs = airspaces;
        this.mapFrame = mapDialog;
        this.wrapperPanel = wrapperPanel;
        this.samples = samples;
        this.maxHeight = maxHeight;
        this.climbSpeedTas = SettingsBean.getInstance().getVerticalProfileBean().getClimbSpeed();
        this.descentSpeedTas = SettingsBean.getInstance().getVerticalProfileBean().getDescentSpeed();
        this.previousMapAirspaces = MapObjectsBean.getInstance().getAirspaces();
        if (!"kt".equals(SettingsBean.getInstance().getParamUnitsSpeed())) {
            if (this.climbSpeedTas != null) {
                this.climbSpeedTas = UnitUtil.recalculateSpeed(this.climbSpeedTas, SettingsBean.getInstance().getParamUnitsSpeed(), "kt", false);
            }
            if (this.descentSpeedTas != null) {
                this.descentSpeedTas = UnitUtil.recalculateSpeed(this.descentSpeedTas, SettingsBean.getInstance().getParamUnitsSpeed(), "kt", false);
            }
        }
        this.windSpeed = FlightPlanBean.getInstance().getRoute().getWindSpeed();
        if (this.windSpeed != null && !"kt".equals(SettingsBean.getInstance().getParamUnitsWindSpeed())) {
            this.windSpeed = UnitUtil.recalculateWindSpeed(this.windSpeed, SettingsBean.getInstance().getParamUnitsWindSpeed(), "kt", false);
        }
        this.windDirection = FlightPlanBean.getInstance().getRoute().getWindDirection();
        this.calculateHeightRatio(false);
        this.initPoints.addAll(this.getPoints());
        this.maxElevation = Short.MIN_VALUE;
        for (Elevation elev : samples) {
            if (elev == null || elev.getElev() == null || elev.getElev() <= this.maxElevation) continue;
            this.maxElevation = elev.getElev();
        }
        this.totalDistance = this.getDistanceAt(samples.length, true);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
    }

    private void calculateAirspaces() {
        if (this.airspacesDTOs != null) {
            List<RoutePlace> routePoints = FlightPlanBean.getInstance().getRoute().getPoints();
            ArrayList<LineSegment> segments = new ArrayList<LineSegment>(routePoints.size() - 1);
            for (int i = 1; i < routePoints.size(); ++i) {
                segments.add(new LineSegment(routePoints.get(i - 1), routePoints.get(i)));
            }
            this.airspaces = new ArrayList<VerticalProfileAirspace>();
            for (int airspaceIdx = 0; airspaceIdx < this.airspacesDTOs.size(); ++airspaceIdx) {
                int topAlt;
                AirspaceAreaDTO a = this.airspacesDTOs.get(airspaceIdx);
                ArrayList<Intersection> intersections = new ArrayList<Intersection>();
                for (int i = 0; i < segments.size(); ++i) {
                    LineSegment s = (LineSegment)segments.get(i);
                    List<GpsPlace> intersectionPlaces = MapUtil.getIntersectionPoints(MapFrame.getInstance().getMapViewer(), s, a);
                    for (GpsPlace p : intersectionPlaces) {
                        double distRatio = GpsUtil.getDistance(s.getFrom(), p) / GpsUtil.getDistance(s.getFrom(), s.getTo());
                        int length = Math.round((this.getPoints().get(i + 1).getX() - this.getPoints().get(i).getX()) / this.zoom);
                        int x = Math.round((this.getPoints().get(i).getX() - 50) / this.zoom) + (int)Math.round((double)length * distRatio);
                        intersections.add(new Intersection(i, x));
                    }
                }
                Collections.sort(intersections);
                log.debug("found " + intersections.size() + " intersections for " + a.getName() + " ===> " + intersections);
                if (intersections.size() <= 0 && !MapUtil.areAllSegmentsIsInsideAirspaceArea(MapFrame.getInstance().getMapViewer(), segments, a)) continue;
                int bottomAlt = (int)this.calculateAltitude(a.getBottomAltitude() == null ? 0.0 : (double)a.getBottomAltitude().intValue());
                int n = topAlt = a.getTopAltitude() == null ? 0 : (int)this.calculateAltitude(a.getTopAltitude().intValue());
                if (topAlt < 50) {
                    topAlt = 50;
                }
                if (bottomAlt <= 50) continue;
                VerticalProfileAirspace baseAirspace = new VerticalProfileAirspace();
                baseAirspace.setBottomAlt(bottomAlt);
                baseAirspace.setTopAlt(topAlt);
                baseAirspace.setType(a.getType());
                String namePrefix = a.getType() != null ? a.getType().toString() + " " : "";
                baseAirspace.setName(namePrefix + a.getName());
                baseAirspace.setOrigAirspaceIdx(airspaceIdx);
                if (intersections.size() == 0) {
                    VerticalProfileAirspace airspace = baseAirspace.clone();
                    airspace.setFromX(50);
                    airspace.setToX(50 + this.samples.length * this.zoom);
                    this.airspaces.add(airspace);
                    continue;
                }
                boolean startFromBeginning = false;
                GpsPlace firstRoutePointBeforeIntersection = this.getPoints().get(((Intersection)intersections.get(0)).getPointIndex()).getGpsPlace();
                if (AirspacesUtil.isPlaceInsideShape(MapFrame.getInstance().getMapViewer(), firstRoutePointBeforeIntersection, a)) {
                    startFromBeginning = true;
                }
                boolean addLastOneToTheEnd = false;
                if (startFromBeginning) {
                    VerticalProfileAirspace airspace = baseAirspace.clone();
                    airspace.setFromX(50);
                    airspace.setToX(50 + ((Intersection)intersections.get(0)).getX() * this.zoom);
                    this.airspaces.add(airspace);
                    for (int i = 0; i < (int)Math.ceil((double)intersections.size() / 2.0) - 1; ++i) {
                        airspace = baseAirspace.clone();
                        airspace.setFromX(50 + ((Intersection)intersections.get(i * 2 + 1)).getX() * this.zoom);
                        airspace.setToX(50 + ((Intersection)intersections.get(i * 2 + 2)).getX() * this.zoom);
                        this.airspaces.add(airspace);
                    }
                    if (intersections.size() % 2 == 0) {
                        addLastOneToTheEnd = true;
                    }
                } else {
                    for (int i = 0; i < (int)Math.floor((double)intersections.size() / 2.0); ++i) {
                        VerticalProfileAirspace airspace = baseAirspace.clone();
                        airspace.setFromX(50 + ((Intersection)intersections.get(i * 2)).getX() * this.zoom);
                        airspace.setToX(50 + ((Intersection)intersections.get(i * 2 + 1)).getX() * this.zoom);
                        this.airspaces.add(airspace);
                    }
                    if (intersections.size() % 2 == 1) {
                        addLastOneToTheEnd = true;
                    }
                }
                if (!addLastOneToTheEnd) continue;
                VerticalProfileAirspace airspace = baseAirspace.clone();
                airspace.setFromX(50 + ((Intersection)intersections.get(intersections.size() - 1)).getX() * this.zoom);
                airspace.setToX(50 + this.samples.length * this.zoom);
                this.airspaces.add(airspace);
            }
            if (this.showOnlyViolatedAirspaces) {
                this.showOnlyViolatedAirspacesAction();
            } else if (this.showOnlyAirspacesInVerticalProfile) {
                this.showOnlyAirspacesInVerticalProfileAction();
            }
        }
    }

    public void showOnlyAirspacesInVerticalProfileAction() {
        if (this.showOnlyAirspacesInVerticalProfile) {
            MapObjectsBean.getInstance().setAirspaces(this.airspacesDTOs.toArray(new AirspaceAreaDTO[this.airspacesDTOs.size()]));
        } else {
            MapObjectsBean.getInstance().setAirspaces(this.previousMapAirspaces);
        }
        this.mapFrame.updateMap();
    }

    public void showOnlyViolatedAirspacesAction() {
        if (this.showOnlyViolatedAirspaces) {
            List<AirspaceAreaDTO> violated = this.getViolatedAirspaces();
            MapObjectsBean.getInstance().setAirspaces(violated.toArray(new AirspaceAreaDTO[violated.size()]));
        } else {
            MapObjectsBean.getInstance().setAirspaces(this.previousMapAirspaces);
        }
        this.mapFrame.updateMap();
    }

    private boolean isRescalingNeeded() {
        short maxElev = this.maxElevation;
        for (VerticalProfilePoint p : this.getPoints()) {
            if (p.getAlt() <= maxElev) continue;
            maxElev = p.getAlt().shortValue();
        }
        int y = (int)this.calculateAltitude(maxElev);
        return y <= 12 || (double)y >= 0.4 * (double)this.getImage().getHeight();
    }

    private void refreshImage() {
        this.setImage(GraphicsUtil.createImageFromSamples(VfrUtil.getSamples(this.samples), this.maxHeight, 50, this.zoom));
    }

    public void calculateHeightRatio(boolean createImage) {
        int i;
        if (createImage) {
            this.refreshImage();
        }
        this.minElevHeight = Integer.MAX_VALUE;
        int height = Integer.MIN_VALUE;
        for (i = 0; i < this.samples.length; ++i) {
            if (this.samples[i] == null || this.samples[i].getElev() == null) continue;
            if (this.samples[i].getElev() > height) {
                height = this.samples[i].getElev().shortValue();
            }
            if (this.samples[i].getElev() >= this.minElevHeight) continue;
            this.minElevHeight = this.samples[i].getElev().shortValue();
        }
        for (i = 0; i < FlightPlanBean.getInstance().getRoute().getPoints().size(); ++i) {
            GpsPlace point = FlightPlanBean.getInstance().getRoute().getPoints().get(i);
            if (point.getAlt() == null || !(point.getAlt() > (double)height)) continue;
            height = (int)Math.round(point.getAlt());
        }
        if (this.minElevHeight < 0) {
            height = -this.minElevHeight + height;
            this.minElevHeight = -this.minElevHeight;
        } else {
            this.minElevHeight = 0;
        }
        height = (int)Math.round((double)height * 1.25);
        this.heightRatio = 1.0;
        if (height > this.maxHeight) {
            this.heightRatio = (double)height / (double)this.maxHeight;
        }
        this.calculatePointsPositions();
        this.calculateAirspaces();
        this.calculateMSAs();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        GraphicsUtil.setRenderingHints(g2d, SettingsBean.getInstance().getRenderingHintsQuality());
        if (this.showMSAs) {
            this.paintMSAs(g2d);
        }
        this.paintAirspaces(g2d);
        this.paintTextInfo(g2d);
        this.paintScale(g2d);
        this.paintMaxElevation(g2d);
        this.paintRoute(g2d);
        this.paintWPs(g2d);
        if (this.lockCursorPosition || !this.mousePressed) {
            this.paintMouseInfo(g2d);
        }
    }

    private void paintTextInfo(Graphics2D g2d) {
        StringBuilder sb = new StringBuilder();
        sb.append(Messages.getInstance().get("vertical_profile_panel_speeds_text_info"));
        sb.append(" ");
        if (SettingsBean.getInstance().getVerticalProfileBean().getClimbSpeed() != null) {
            sb.append(SettingsBean.getInstance().getVerticalProfileBean().getClimbSpeed());
            sb.append(SettingsBean.getInstance().getParamUnitsSpeed());
        } else {
            sb.append("---");
        }
        sb.append(" / ");
        if (SettingsBean.getInstance().getVerticalProfileBean().getDescentSpeed() != null) {
            sb.append(SettingsBean.getInstance().getVerticalProfileBean().getDescentSpeed());
            sb.append(SettingsBean.getInstance().getParamUnitsSpeed());
        } else {
            sb.append("---");
        }
        sb.append("   ");
        sb.append(StringUtil.formatWind(this.windDirection, this.windSpeed));
        g2d.setFont(ALT_INFO_LABEL_FONT);
        g2d.setColor(Color.BLACK);
        g2d.drawString(sb.toString(), 50 + this.getImagePosX(), 50 + this.getImagePosY() - 8);
    }

    private void paintMaxElevation(Graphics2D g2d) {
        if (this.maxElevation != null) {
            int y = this.getImagePosY() + (int)this.calculateAltitude(this.maxElevation.shortValue());
            float[] dash = new float[]{4.0f, 2.0f};
            g2d.setStroke(new BasicStroke(1.0f, 0, 0, 2.0f, dash, 0.0f));
            g2d.setColor(Color.ORANGE);
            g2d.drawLine(50 + this.getImagePosX(), y, this.getImagePosX() + this.getImage().getWidth() - 50 - 1, y);
            g2d.setFont(ALT_INFO_LABEL_FONT);
            String txt = this.maxElevation + SettingsBean.getInstance().getParamUnitsAltitude();
            FontMetrics fm = g2d.getFontMetrics();
            Rectangle2D rect = fm.getStringBounds(txt, g2d);
            g2d.setColor(Color.BLACK);
            g2d.drawString(txt, 50 + this.getImagePosX() - (int)rect.getWidth() - 5, y + 3);
        }
    }

    private Double getDistanceAt(int x, boolean fromStart) {
        if (x >= 0 && x <= this.samples.length) {
            return fromStart ? (double)x / this.distanceRatio : (double)(this.samples.length - x) / this.distanceRatio;
        }
        return null;
    }

    private void paintScale(Graphics2D g2d) {
        if (this.distanceRatio != null) {
            int width = this.samples.length * this.zoom;
            if (this.scaleDistance == null) {
                this.scaleDistance = (double)this.samples.length / this.distanceRatio;
                if (!"nm".equals(SettingsBean.getInstance().getParamUnitsDistance())) {
                    this.scaleDistance = UnitUtil.recalculateDistance(this.scaleDistance, "nm", SettingsBean.getInstance().getParamUnitsDistance(), false);
                }
                this.scaleStep = 0.001;
                this.scaleStepPrec = 1000.0;
                if (this.scaleDistance > 500.0) {
                    this.scaleStep = 100.0;
                    this.scaleStepPrec = 1.0;
                } else if (this.scaleDistance > 50.0) {
                    this.scaleStep = 10.0;
                    this.scaleStepPrec = 1.0;
                } else if (this.scaleDistance > 5.0) {
                    this.scaleStep = 1.0;
                    this.scaleStepPrec = 1.0;
                } else if (this.scaleDistance > 0.5) {
                    this.scaleStep = 0.1;
                    this.scaleStepPrec = 10.0;
                } else if (this.scaleDistance > 0.05) {
                    this.scaleStep = 0.01;
                    this.scaleStepPrec = 100.0;
                }
                this.scaleStepsNum = (int)Math.floor(this.scaleDistance / this.scaleStep);
                this.scaleStepWidth = (double)width / this.scaleDistance * this.scaleStep;
                if (this.scaleStepWidth < 75.0) {
                    do {
                        this.scaleStep = this.scaleStep * 2.0;
                        this.scaleStepsNum = (int)Math.floor(this.scaleDistance / this.scaleStep);
                        this.scaleStepWidth = (double)width / this.scaleDistance * this.scaleStep;
                    } while (this.scaleStepWidth < 75.0);
                }
            }
            GpsPoint scStart = new GpsPoint(50 + this.getImagePosX(), this.getImagePosY() + this.getImage().getHeight() + 4 - 50);
            GpsPoint scEnd = new GpsPoint(50 + this.getImagePosX() + this.getImage().getHeight(), this.getImagePosY() + this.getImage().getHeight() + 4 - 50);
            g2d.setFont(SCALE_FONT);
            FontMetrics fm = g2d.getFontMetrics();
            g2d.setStroke(BASIC_STROKE_2);
            g2d.setColor(Color.BLACK);
            for (int i = 0; i <= this.scaleStepsNum; ++i) {
                int pos = (int)Math.round(scStart.getX() + (double)i * this.scaleStepWidth);
                g2d.drawLine(pos, (int)scStart.getY(), pos, (int)scStart.getY() + 10);
                String txt = null;
                txt = this.scaleStepPrec > 1.0 ? String.valueOf((double)Math.round((double)i * this.scaleStep * this.scaleStepPrec) / this.scaleStepPrec) + SettingsBean.getInstance().getParamUnitsDistance() : String.valueOf(Math.round((double)i * this.scaleStep)) + SettingsBean.getInstance().getParamUnitsDistance();
                Rectangle2D rect = fm.getStringBounds(txt, g2d);
                g2d.drawString(txt, (int)((double)pos - rect.getWidth() / 2.0), (int)scStart.getY() + 10 + 15);
            }
            int lastX = (int)scStart.getX() + width - 1;
            g2d.drawLine((int)scStart.getX(), (int)scStart.getY(), lastX, (int)scEnd.getY());
            g2d.drawLine(lastX, (int)scStart.getY(), lastX, (int)scStart.getY() + 10);
            String txt = String.valueOf((double)Math.round(this.scaleDistance * 10.0) / 10.0) + SettingsBean.getInstance().getParamUnitsDistance();
            Rectangle2D rect = fm.getStringBounds(txt, g2d);
            g2d.drawString(txt, (int)((double)lastX - rect.getWidth() / 2.0), (int)scStart.getY() + 10 + 15);
        }
    }

    private void paintMouseInfo(Graphics2D g2d) {
        if (this.cursorPos != null && this.samples[this.cursorPos] != null && this.samples[this.cursorPos].getElev() != null) {
            int pixX = 50 + this.cursorPos * this.zoom + 1;
            if (this.zoom > 1) {
                pixX += Math.round(this.zoom / 2);
            }
            g2d.setColor(COLOR_CURSOR);
            g2d.setStroke(new BasicStroke(3.0f));
            g2d.drawLine(pixX + this.getImagePosX() - 1, 50 + this.getImagePosY() + 1, pixX + this.getImagePosX() - 1, this.getImage().getHeight() - 50 + this.getImagePosY() - 1);
            if (this.samples[this.cursorPos] != null) {
                g2d.setFont(ALT_INFO_LABEL_FONT);
                String txt = this.samples[this.cursorPos].getElev() + SettingsBean.getInstance().getParamUnitsAltitude();
                FontMetrics fm = g2d.getFontMetrics();
                Rectangle2D rect = fm.getStringBounds(txt, g2d);
                g2d.setColor(COLOR_ALT_INFO_BACKGROUND);
                int x = pixX + this.getImagePosX() + 5;
                int y = this.getImagePosY() + (int)this.calculateAltitude(this.samples[this.cursorPos].getElev().shortValue()) - 10;
                g2d.fillRect(pixX + this.getImagePosX() + 2, y - (int)rect.getHeight(), (int)rect.getWidth() + 6, (int)rect.getHeight() + 5);
                g2d.setColor(COLOR_ALT_INFO);
                g2d.drawString(txt, x, y);
            }
            Integer routeAlt = this.calculateRouteAltAtXPos(--pixX);
            if (this.showRouteAltitude) {
                this.paintRouteElevationInfo(g2d, this.calculateAltitude(routeAlt.intValue()), routeAlt);
            }
            if (this.showAltitudeAndDistance) {
                int mouseAlt;
                g2d.setFont(SCALE_FONT);
                double dist = this.getDistanceAt(this.cursorPos, true);
                String txt = NumberUtil.roundDouble(dist, 1) + SettingsBean.getInstance().getParamUnitsDistance();
                if (this.totalDistance != null) {
                    txt = txt + " / " + NumberUtil.roundDouble(this.totalDistance - dist, 1) + SettingsBean.getInstance().getParamUnitsDistance();
                }
                FontMetrics fm = g2d.getFontMetrics();
                Rectangle2D rect = fm.getStringBounds(txt, g2d);
                int x = pixX + this.getImagePosX() - (int)Math.round(rect.getWidth() / 2.0);
                int y = this.getImagePosY() + this.getImage().getHeight() - (int)rect.getHeight() + 10;
                g2d.setColor(COLOR_CURSOR);
                g2d.drawString(txt, x, y);
                if (this.mouseY != null && (mouseAlt = (int)Math.round(this.calculatePointsToAltitude(this.mouseY - this.getImagePosY() + 1))) > 0) {
                    txt = String.valueOf(mouseAlt) + SettingsBean.getInstance().getParamUnitsAltitude();
                    g2d.setColor(COLOR_CURSOR);
                    g2d.drawLine(pixX + this.getImagePosX(), this.mouseY, pixX + this.getImagePosX() + 60, this.mouseY);
                    GraphicsUtil.drawBoxedString(g2d, pixX + this.getImagePosX() + 15, this.mouseY - 5, txt, SCALE_FONT, COLOR_CURSOR, Color.WHITE, 2);
                }
            }
            if (this.getAirspaces().size() > 0) {
                int x;
                Integer routeY = null;
                if (routeAlt != null) {
                    routeY = (int)Math.round(this.calculateAltitude(routeAlt.intValue()));
                }
                StringBuilder violatedAirspacesSb = new StringBuilder();
                StringBuilder notViolatedAirspacesSb = new StringBuilder();
                ArrayList<MapShape> highlightedAirspacesList = new ArrayList<MapShape>();
                for (VerticalProfileAirspace a : this.getAirspaces()) {
                    if (pixX < a.getFromX() || pixX > a.getToX()) continue;
                    if (routeY != null && routeY <= a.getBottomAlt() && routeY >= a.getTopAlt()) {
                        violatedAirspacesSb.append("[" + a.getName() + "] ");
                        if (!this.showPositionInTheMap) continue;
                        MapShape shape = this.airspacesDTOs.get(a.getOrigAirspaceIdx()).toMapShape();
                        shape.setColor(Color.RED);
                        shape.setBackgroundColor(new Color(1.0f, 0.0f, 0.0f, 0.5f));
                        highlightedAirspacesList.add(shape);
                        continue;
                    }
                    notViolatedAirspacesSb.append("[" + a.getName() + "] ");
                }
                if (this.showPositionInTheMap && highlightedAirspacesList.size() > 0) {
                    MapObjectsBean.getInstance().setHighlightedMapShapes(highlightedAirspacesList.toArray(new MapShape[highlightedAirspacesList.size()]));
                } else {
                    MapObjectsBean.getInstance().setHighlightedMapShapes(null);
                }
                String txt = notViolatedAirspacesSb.toString().trim();
                if (!StringUtil.isEmpty(txt)) {
                    g2d.setFont(AIRSPACE_TEXT_FONT);
                    FontMetrics fm = g2d.getFontMetrics();
                    Rectangle2D rect = fm.getStringBounds(txt, g2d);
                    x = this.getImagePosX() + pixX - (int)Math.round(rect.getWidth() / 2.0);
                    if (x < this.getImagePosX() + 50) {
                        x = this.getImagePosX() + 50;
                    } else if (x + (int)rect.getWidth() > this.getImagePosX() + 50 + this.samples.length * this.zoom) {
                        x = this.getImagePosX() + 50 + this.samples.length * this.zoom - (int)rect.getWidth();
                    }
                    GraphicsUtil.drawBoxedString(g2d, x, this.getImagePosY() + 50 - 22, txt, AIRSPACE_TEXT_FONT, Color.BLUE, COLOR_ALT_INFO_BACKGROUND, 2);
                }
                if (!StringUtil.isEmpty(txt = violatedAirspacesSb.toString().trim())) {
                    g2d.setFont(AIRSPACE_VIOLATED_TEXT_FONT);
                    FontMetrics fm = g2d.getFontMetrics();
                    Rectangle2D rect = fm.getStringBounds(txt, g2d);
                    x = this.getImagePosX() + pixX - (int)Math.round(rect.getWidth() / 2.0);
                    if (x < this.getImagePosX() + 50) {
                        x = this.getImagePosX() + 50;
                    } else if (x + (int)rect.getWidth() > this.getImagePosX() + 50 + this.samples.length * this.zoom) {
                        x = this.getImagePosX() + 50 + this.samples.length * this.zoom - (int)rect.getWidth();
                    }
                    GraphicsUtil.drawBoxedString(g2d, x, this.getImagePosY() + 50 - 38, txt, AIRSPACE_VIOLATED_TEXT_FONT, Color.RED, COLOR_ALT_INFO_BACKGROUND, 2);
                }
            }
        }
    }

    private Integer calculateRouteAltAtXPos(int pixX) {
        for (int i = 1; i < this.getPoints().size(); ++i) {
            if (pixX == this.getPoints().get(i - 1).getX()) {
                return this.getPoints().get(i - 1).getAlt();
            }
            if (i == this.getPoints().size() - 1 && pixX + 2 == this.getPoints().get(i).getX()) {
                return this.getPoints().get(i).getAlt();
            }
            if (pixX <= this.getPoints().get(i - 1).getX() || pixX >= this.getPoints().get(i).getX()) continue;
            GpsPoint p1 = this.getPoints().get(i - 1).getPoint();
            p1.setY(this.calculateAltitude(this.getPoints().get(i - 1).getAlt().intValue(), false));
            GpsPoint p2 = this.getPoints().get(i).getPoint();
            p2.setY(this.calculateAltitude(this.getPoints().get(i).getAlt().intValue(), false));
            Double[] coefs = VfrUtil.getLinearEquation(p1, p2);
            if (coefs[0] == null || coefs[1] == null) break;
            double y = coefs[0] * (double)pixX + coefs[1];
            return (int)Math.round(this.calculatePointsToAltitude(y));
        }
        return null;
    }

    private List<AirspaceAreaDTO> getViolatedAirspaces() {
        ArrayList<AirspaceAreaDTO> violatedAirspaces = new ArrayList<AirspaceAreaDTO>();
        if (this.getAirspaces().size() > 0) {
            ArrayList<Integer> airspacesAlreadyAdded = new ArrayList<Integer>();
            for (int i = 0; i < this.samples.length; ++i) {
                int pixX = 50 + i * this.zoom;
                if (this.zoom > 1) {
                    pixX += Math.round(this.zoom / 2);
                }
                int routeAlt = this.calculateRouteAltAtXPos(pixX);
                int routeY = (int)Math.round(this.calculateAltitude(routeAlt));
                for (VerticalProfileAirspace a : this.getAirspaces()) {
                    if (pixX < a.getFromX() || pixX > a.getToX() || routeY > a.getBottomAlt() || routeY < a.getTopAlt() || airspacesAlreadyAdded.contains(a.getOrigAirspaceIdx())) continue;
                    violatedAirspaces.add(this.airspacesDTOs.get(a.getOrigAirspaceIdx()));
                    airspacesAlreadyAdded.add(a.getOrigAirspaceIdx());
                }
            }
        }
        return violatedAirspaces;
    }

    private void paintRouteElevationInfo(Graphics2D g2d, double y, Integer alt) {
        int posY = (int)Math.round((double)this.getImagePosY() + y + 1.0);
        int posX = 50 + this.getImagePosX() + this.cursorPos * this.zoom;
        if (this.zoom > 1) {
            posX += Math.round(this.zoom / 2);
        }
        if (alt == null) {
            alt = (int)Math.round(this.calculatePointsToAltitude(y));
        }
        g2d.setFont(ALT_INFO_LABEL_FONT);
        String txt = alt + SettingsBean.getInstance().getParamUnitsAltitude();
        FontMetrics fm = g2d.getFontMetrics();
        Rectangle2D rect = fm.getStringBounds(txt, g2d);
        g2d.setColor(COLOR_ALT_INFO_BACKGROUND);
        g2d.fillRect(posX - (int)rect.getWidth() - 9, posY - (int)rect.getHeight() * 2, (int)rect.getWidth() + 8, (int)rect.getHeight() + 5);
        g2d.setColor(Color.BLACK);
        g2d.drawString(txt, posX - (int)rect.getWidth() - 5, posY - (int)rect.getHeight());
    }

    public double calculateAltitude(double alt) {
        return this.calculateAltitude(alt, true);
    }

    public double calculateAltitude(double alt, boolean round) {
        double y = (double)this.getImage().getHeight() - (alt + (double)this.minElevHeight) / this.heightRatio - 50.0;
        return round ? (double)Math.round(y) : y;
    }

    public double calculatePointsToAltitude(double y) {
        return ((double)this.getImage().getHeight() - y - 50.0) * this.heightRatio - (double)this.minElevHeight;
    }

    public void calculatePointsPositions() {
        this.getPoints().clear();
        GpsPlace firstPoint = FlightPlanBean.getInstance().getRoute().getPoints().get(0);
        VerticalProfilePoint point = new VerticalProfilePoint();
        point.setX(50);
        if (firstPoint.getAlt() != null) {
            point.setY((int)this.calculateAltitude(firstPoint.getAlt()));
            point.setAlt((int)Math.round(firstPoint.getAlt()));
        }
        point.setName(firstPoint.getName());
        point.setLat(firstPoint.getLat().getValue());
        point.setLon(firstPoint.getLon().getValue());
        this.getPoints().add(point);
        double maxdist = FlightPlanBean.getInstance().getRoute().calculateTotalDistance();
        this.distanceRatio = (double)this.samples.length / maxdist;
        this.msas = new ArrayList<VerticalProfileMsa>();
        for (int i = 1; i < FlightPlanBean.getInstance().getRoute().getPoints().size(); ++i) {
            GpsPlace place = FlightPlanBean.getInstance().getRoute().getPoints().get(i);
            point = new VerticalProfilePoint();
            if (place.getAlt() != null) {
                point.setY((int)this.calculateAltitude(place.getAlt()));
                point.setAlt((int)Math.round(place.getAlt()));
                if (this.isClimbRate(i) || this.isDescentRate(i)) {
                    double speed = this.isClimbRate(i) ? this.climbSpeedTas : this.descentSpeedTas;
                    if (this.isWindData()) {
                        double segmentCourse = GpsUtil.getLineSegment(FlightPlanBean.getInstance().getRoute().getPoints().get(i - 1), FlightPlanBean.getInstance().getRoute().getPoints().get(i)).getCourse();
                        speed = VfrUtil.calculateGSForWind(speed, segmentCourse, this.windSpeed, this.windDirection);
                    }
                    point.setClimbRate(GpsUtil.calculateClimbRate(FlightPlanBean.getInstance().getRoute().getPoints().get(i - 1), FlightPlanBean.getInstance().getRoute().getPoints().get(i), speed, this.isClimbRateInFpm()));
                    point.setClimbAngle(GpsUtil.calculateClimbAngle(FlightPlanBean.getInstance().getRoute().getPoints().get(i - 1), FlightPlanBean.getInstance().getRoute().getPoints().get(i), true).intValue());
                }
            }
            point.setName(place.getName());
            if (i < FlightPlanBean.getInstance().getRoute().getPoints().size() - 1) {
                point.setX(this.getX(place, (int)Math.floor((this.getPoints().get(i - 1).getX() - 50) / this.zoom) + 1));
            } else {
                point.setX(50 + this.samples.length * this.zoom);
            }
            point.setLat(place.getLat().getValue());
            point.setLon(place.getLon().getValue());
            if (this.initPoints.size() > 0) {
                boolean newlyAdded = true;
                for (int q = 0; q < this.initPoints.size(); ++q) {
                    if (!this.initPoints.get(q).equals(point)) continue;
                    newlyAdded = false;
                    break;
                }
                point.setNewlyAdded(newlyAdded);
            }
            this.getPoints().add(point);
        }
    }

    public void calculateMSAs() {
        ElevationFacade elevationFacade = new ElevationFacade(DBUtil.getDataSource());
        FlightPlanBean.getInstance().getRoute().calculateSegments();
        TerrainElevationDTO[] dtos = elevationFacade.getTerrainElevationsForSegments(FlightPlanBean.getInstance().getRoute().getSegments());
        VerticalProfileMsa[] resultArray = new VerticalProfileMsa[this.samples.length - 1];
        block0: for (int i = 0; i < this.samples.length - 1; ++i) {
            GpsPlace place;
            Elevation el = this.samples[i];
            if (el == null || (place = el.getGpsPlace()) == null) continue;
            for (TerrainElevationDTO dto : dtos) {
                if (!place.isInside(dto.getArea())) continue;
                resultArray[i] = new VerticalProfileMsa((short)(dto.getElev() + 10), i * this.zoom + 50, (i + 1) * this.zoom + 50);
                continue block0;
            }
        }
        ArrayList<VerticalProfileMsa> result = new ArrayList<VerticalProfileMsa>();
        if (resultArray[0] != null) {
            result.add(resultArray[0]);
        }
        for (int i = 1; i < resultArray.length - 1; ++i) {
            if (resultArray[i] != null) {
                VerticalProfileMsa prevMsa = resultArray[i - 1];
                VerticalProfileMsa msa = resultArray[i];
                if (prevMsa != null && prevMsa.getMsa() == msa.getMsa()) continue;
                if (prevMsa != null && result.size() > 0) {
                    ((VerticalProfileMsa)result.get(result.size() - 1)).setToX((i - 1) * this.zoom + 50);
                }
                result.add(msa);
                continue;
            }
            if (resultArray[i] != null || resultArray[i - 1] == null || result.size() <= 0) continue;
            ((VerticalProfileMsa)result.get(result.size() - 1)).setToX((i - 1) * this.zoom + 50);
        }
        if (resultArray[resultArray.length - 1] != null) {
            ((VerticalProfileMsa)result.get(result.size() - 1)).setToX(this.samples.length * this.zoom + 50 - 1);
        }
        if (!"ft".equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
            for (VerticalProfileMsa msa : result) {
                msa.setMsa((short)Math.ceil(UnitUtil.recalculateAltitude(msa.getMsa() * 100, "ft", SettingsBean.getInstance().getParamUnitsAltitude(), false) / 100.0));
            }
        }
        this.msas = result;
    }

    private boolean isClimbRate(int idx) {
        Double alt = FlightPlanBean.getInstance().getRoute().getPoints().get(idx - 1).getAlt();
        Double alt2 = FlightPlanBean.getInstance().getRoute().getPoints().get(idx).getAlt();
        if (alt == null || alt2 == null) {
            return false;
        }
        return this.climbSpeedTas != null && alt2 >= alt;
    }

    private boolean isDescentRate(int idx) {
        Double alt = FlightPlanBean.getInstance().getRoute().getPoints().get(idx - 1).getAlt();
        Double alt2 = FlightPlanBean.getInstance().getRoute().getPoints().get(idx).getAlt();
        if (alt == null || alt2 == null) {
            return false;
        }
        return this.descentSpeedTas != null && alt2 < alt;
    }

    private Integer getX(GpsPlace place, int startIdx) {
        double minDist = 10000.0;
        int idx = -1;
        for (int x = startIdx; x < this.samples.length; ++x) {
            if (this.samples[x] == null) continue;
            double dist = GpsUtil.getDistance(place, this.samples[x].getGpsPlace());
            if (dist < minDist) {
                minDist = dist;
                idx = 50 + x * this.zoom;
                if (this.zoom <= 1) continue;
                idx += Math.round(this.zoom / 2);
                continue;
            }
            if (!(dist > minDist) || idx < 0) continue;
            return idx;
        }
        if (idx >= 0) {
            return idx;
        }
        return null;
    }

    public int getPointsIndexAt(int x, int y) {
        GpsPoint p = new GpsPoint(x, y);
        for (int i = 0; i < this.getPoints().size(); ++i) {
            if (!(p.distance(this.getPoints().get(i).getPoint()) <= 12.0)) continue;
            return i;
        }
        return -1;
    }

    private void paintRoute(Graphics2D g) {
        for (int i = 1; i < this.getPoints().size(); ++i) {
            GpsPoint p1 = this.getPoints().get(i - 1).getPoint();
            p1.setY((double)this.getImage().getHeight() - p1.getY());
            GpsPoint p2 = this.getPoints().get(i).getPoint();
            p2.setY((double)this.getImage().getHeight() - p2.getY());
            GpsPoint[] points = VfrUtil.getPointsOnWP(p1, p2, 12.0);
            if (points != null && points[0] != null && points[1] != null) {
                g.setColor(Color.BLACK);
                g.setStroke(BASIC_STROKE_4);
                g.drawLine(this.getImagePosX() + (int)points[0].getX(), this.getImagePosY() + this.getImage().getHeight() - (int)points[0].getY(), this.getImagePosX() + (int)points[1].getX(), this.getImagePosY() + this.getImage().getHeight() - (int)points[1].getY());
                g.setStroke(BASIC_STROKE_2);
                g.setColor(Color.RED);
                g.drawLine(this.getImagePosX() + (int)points[0].getX(), this.getImagePosY() + this.getImage().getHeight() - (int)points[0].getY(), this.getImagePosX() + (int)points[1].getX(), this.getImagePosY() + this.getImage().getHeight() - (int)points[1].getY());
            }
            if (this.getPoints().get(i).getClimbRate() == null || this.getPoints().get(i).getClimbAngle() == null) continue;
            GpsPoint middlePoint = new GpsPoint((p2.getX() + p1.getX()) / 2.0, (p2.getY() + p1.getY()) / 2.0);
            String text = FormatUtil.formatClimbAndAngle(this.getPoints().get(i).getClimbRate(), this.getPoints().get(i).getClimbAngle().intValue(), this.isClimbRateInFpm());
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D rect = fm.getStringBounds(text, g);
            int y = this.getImagePosY() + this.getImage().getHeight() - (int)middlePoint.getY() - 5;
            int x = this.getImagePosX() + (int)middlePoint.getX();
            double rotation = VfrUtil.getLineGradient(p1, p2);
            g.translate(x, y);
            g.rotate(-rotation);
            g.translate(-x, -y);
            GraphicsUtil.drawOutlinedString(g, (int)Math.round((double)x - rect.getWidth() / 2.0), y, text, SEGMENT_INFORMATION_LABEL_FONT, Color.BLACK, new Color(1.0f, 1.0f, 1.0f, 0.9f), 3.0f);
            g.translate(x, y);
            g.rotate(rotation);
            g.translate(-x, -y);
        }
    }

    private void paintAirspaces(Graphics2D g) {
        for (VerticalProfileAirspace a : this.getAirspaces()) {
            int fromX = this.getImagePosX() + a.getFromX();
            int toX = this.getImagePosX() + a.getToX();
            int bottom = this.getImagePosY() + a.getBottomAlt();
            int top = this.getImagePosY() + a.getTopAlt();
            Color color = SettingsBean.getInstance().getAirspacesColorTheme().getAirspaceColor(a.getType());
            Color backgroundColor = SettingsBean.getInstance().getAirspacesColorTheme().getAirspaceBackground(a.getType());
            if (backgroundColor == null) {
                backgroundColor = new Color((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 0.15f);
            }
            g.setColor(backgroundColor);
            g.setStroke(new BasicStroke(1.0f));
            g.fillRect(fromX, top, toX - fromX + 1, bottom - top + 1);
            g.setColor(color);
            g.setStroke(SettingsBean.getInstance().getAirspacesColorTheme().getAirspaceStroke(a.getType()));
            g.drawRect(fromX, top, toX - fromX + 1, bottom - top + 1);
        }
    }

    private void paintMSAs(Graphics2D g) {
        if (this.msas != null) {
            Color color = SettingsBean.getInstance().getColorTheme().getElevColorOnMap(false);
            Color backgroundColor = SettingsBean.getInstance().getColorTheme().getElevStrokeColorOnMap(false);
            for (VerticalProfileMsa msa : this.msas) {
                int fromX = this.getImagePosX() + msa.getFromX();
                int toX = this.getImagePosX() + msa.getToX();
                int x = (int)Math.round((double)(fromX + toX) / 2.0);
                int y = this.getImagePosY() + (int)this.calculateAltitude(msa.getMsa() * 100);
                g.setColor(color);
                g.setStroke(new BasicStroke(1.0f));
                g.drawLine(fromX, y, toX, y);
                GraphicsUtil.drawMSA(g, x, y - 10, String.valueOf(msa.getMsa()), color, backgroundColor, false);
            }
        }
    }

    private void paintWPs(Graphics2D g) {
        for (int i = 0; i < this.getPoints().size(); ++i) {
            int x = this.getImagePosX() + this.getPoints().get(i).getX();
            int y = this.getImagePosY() + this.getPoints().get(i).getY();
            g.setColor(new Color(0.9f, 0.9f, 0.9f, 0.65f));
            g.setStroke(BASIC_STROKE_5);
            g.drawOval(x - 12, y - 12, 23, 23);
            g.setColor(Color.BLUE);
            g.setStroke(BASIC_STROKE_3);
            g.drawOval(x - 12, y - 12, 23, 23);
            g.setFont(WAYPOINT_LABEL_FONT);
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D rect = fm.getStringBounds(this.getPoints().get(i).getName(), g);
            GraphicsUtil.drawOutlinedString(g, (int)Math.round((double)x - rect.getWidth() / 2.0), y + 25, this.getPoints().get(i).getName(), WAYPOINT_LABEL_FONT, SettingsBean.getInstance().getColorTheme().getWpColor(false), SettingsBean.getInstance().getColorTheme().getWpStrokeColor(false), 3.0f);
            if (this.getPoints().get(i).getAlt() == null) continue;
            g.setFont(ALT_INFO_LABEL_FONT);
            String txt = this.getPoints().get(i).getAlt() + SettingsBean.getInstance().getParamUnitsAltitude();
            fm = g.getFontMetrics();
            rect = fm.getStringBounds(txt, g);
            int w = (int)rect.getWidth() + 4;
            g.setColor(COLOR_ALT_INFO_BACKGROUND);
            g.fillRect(x - w / 2, y + 30, w, (int)rect.getHeight() + 3);
            g.setColor(COLOR_ALT_INFO);
            g.drawString(txt, x - w / 2 + 2, y + (int)rect.getHeight() + 29);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int y = e.getY() - this.getImagePosY() + 1;
        if (y <= this.getImage().getHeight() && this.mousePressed) {
            int idx;
            int x = e.getX() - this.getImagePosX() + 1;
            int n = idx = this.selected >= 0 ? this.selected : this.getPointsIndexAt(x, y);
            if (idx >= 0) {
                this.selected = idx;
                int dy = y - this.prevMouseY;
                int newY = y + dy;
                if (newY > this.getImage().getHeight()) {
                    newY = this.getImage().getHeight();
                } else if (e.getY() < 0) {
                    newY -= e.getY();
                }
                double newAlt = this.calculatePointsToAltitude(newY);
                if (this.limitAltToTerrain && this.samples[this.cursorPos] != null && this.samples[this.cursorPos].getElev() != null && newAlt < (double)this.samples[this.cursorPos].getElev().shortValue()) {
                    newAlt = this.samples[this.cursorPos].getElev().shortValue();
                    newY = (int)this.calculateAltitude(newAlt);
                }
                newAlt = Math.round(newAlt);
                this.getPoints().get(idx).setY(newY);
                this.getPoints().get(idx).setAlt((int)newAlt);
                FlightPlanBean.getInstance().getRoute().getPoints().get(idx).setAlt(Math.ceil(newAlt));
                if (this.isRescalingNeeded()) {
                    this.calculateHeightRatio(true);
                    this.mousePressed = false;
                    this.selected = -1;
                    this.updateMouseCursor(e);
                } else {
                    Integer climbAngle;
                    double speed;
                    if (idx > 0) {
                        if (this.isClimbRate(idx) || this.isDescentRate(idx)) {
                            speed = this.isClimbRate(idx) ? this.climbSpeedTas : this.descentSpeedTas;
                            if (this.isWindData()) {
                                double segmentCourse = GpsUtil.getLineSegment(FlightPlanBean.getInstance().getRoute().getPoints().get(idx - 1), FlightPlanBean.getInstance().getRoute().getPoints().get(idx)).getCourse();
                                speed = VfrUtil.calculateGSForWind(speed, segmentCourse, this.windSpeed, this.windDirection);
                            }
                            Double climbRate = GpsUtil.calculateClimbRate(FlightPlanBean.getInstance().getRoute().getPoints().get(idx - 1), FlightPlanBean.getInstance().getRoute().getPoints().get(idx), speed, this.isClimbRateInFpm());
                            this.getPoints().get(idx).setClimbRate(climbRate);
                            climbAngle = GpsUtil.calculateClimbAngle(FlightPlanBean.getInstance().getRoute().getPoints().get(idx - 1), FlightPlanBean.getInstance().getRoute().getPoints().get(idx), true).intValue();
                            this.getPoints().get(idx).setClimbAngle(climbAngle);
                        } else {
                            this.getPoints().get(idx).setClimbRate(null);
                            this.getPoints().get(idx).setClimbAngle(null);
                        }
                    }
                    if (idx < this.getPoints().size() - 1) {
                        if (this.isClimbRate(idx + 1) || this.isDescentRate(idx + 1)) {
                            speed = this.isClimbRate(idx + 1) ? this.climbSpeedTas : this.descentSpeedTas;
                            if (this.isWindData()) {
                                double segmentCourse = GpsUtil.getLineSegment(FlightPlanBean.getInstance().getRoute().getPoints().get(idx), FlightPlanBean.getInstance().getRoute().getPoints().get(idx + 1)).getCourse();
                                speed = VfrUtil.calculateGSForWind(speed, segmentCourse, this.windSpeed, this.windDirection);
                            }
                            Double climbRate = GpsUtil.calculateClimbRate(FlightPlanBean.getInstance().getRoute().getPoints().get(idx), FlightPlanBean.getInstance().getRoute().getPoints().get(idx + 1), speed, this.isClimbRateInFpm());
                            this.getPoints().get(idx + 1).setClimbRate(climbRate);
                            climbAngle = GpsUtil.calculateClimbAngle(FlightPlanBean.getInstance().getRoute().getPoints().get(idx), FlightPlanBean.getInstance().getRoute().getPoints().get(idx + 1), true).intValue();
                            this.getPoints().get(idx + 1).setClimbAngle(climbAngle);
                        } else {
                            this.getPoints().get(idx + 1).setClimbRate(null);
                            this.getPoints().get(idx + 1).setClimbAngle(null);
                        }
                    }
                    MapFrame.getInstance().getUIPanel().updateRoutePoints();
                    this.repaint();
                }
                if (this.showOnlyViolatedAirspaces) {
                    this.showOnlyViolatedAirspacesAction();
                }
            }
        }
        this.mousePressed = true;
        this.prevMouseY = y;
    }

    private void updateMapPosition() {
        if (this.samples[this.cursorPos] != null) {
            if (this.isShowPositionInTheMap()) {
                MapFrame.getInstance().setMarkerPlace(this.samples[this.cursorPos].getGpsPlace());
                MapFrame.getInstance().updateMap();
            }
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.lockCursorPosition) {
            int x = e.getX() - this.getImagePosX() + 1 - 50;
            this.cursorPos = (int)Math.floor(x / this.zoom);
            if (this.cursorPos < 0) {
                this.cursorPos = 0;
            } else if (this.cursorPos >= this.samples.length) {
                this.cursorPos = this.samples.length - 1;
            }
            this.updateMapPosition();
        }
        this.mouseY = e.getY();
        this.updateMouseCursor(e);
    }

    private void updateMouseCursor(MouseEvent e) {
        int y;
        int x = e.getX() - this.getImagePosX() + 1;
        if (this.getPointsIndexAt(x, y = e.getY() - this.getImagePosY() + 1) >= 0) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else if (x >= 0 && y >= 0 && x <= this.getImage().getWidth() && y <= this.getImage().getHeight()) {
            this.setCursor(Cursor.getPredefinedCursor(1));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public List<VerticalProfileAirspace> getAirspaces() {
        if (this.airspaces == null) {
            this.airspaces = new ArrayList<VerticalProfileAirspace>();
        }
        return this.airspaces;
    }

    public void setAirspaces(List<VerticalProfileAirspace> airspaces) {
        this.airspaces = airspaces;
    }

    public List<VerticalProfilePoint> getPoints() {
        if (this.points == null) {
            this.points = new ArrayList<VerticalProfilePoint>();
        }
        return this.points;
    }

    public void setPoints(List<VerticalProfilePoint> points) {
        this.points = points;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getClickCount() == 1) {
            if (e.isPopupTrigger()) {
                this.doPop(e);
            }
        } else if (e.getClickCount() == 2) {
            this.getWrapperPanel().getLockCursorPosition().toggle();
            this.getWrapperPanel().getLockCursorPosition().doClick();
        }
    }

    public VerticalProfileWrapperPanel getWrapperPanel() {
        return this.wrapperPanel;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mousePressed = false;
        this.selected = -1;
        if (e.isPopupTrigger()) {
            this.doPop(e);
        }
    }

    private void doPop(MouseEvent e) {
        int x = e.getX() - this.getImagePosX() + 1;
        int y = e.getY() - this.getImagePosY() + 1;
        if (x >= 0 && y >= 0) {
            VerticalPanelPopupMenu popupMenu = new VerticalPanelPopupMenu(this, x, y);
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    public boolean isLimitAltToTerrain() {
        return this.limitAltToTerrain;
    }

    public void setLimitAltToTerrain(boolean limitAltToTerrain) {
        this.limitAltToTerrain = limitAltToTerrain;
    }

    public int getSegmentIndexAtPosition(int x, int y) {
        GpsPoint point = new GpsPoint(x, y);
        for (int i = 1; i < this.getPoints().size(); ++i) {
            if (x <= this.getPoints().get(i - 1).getX() || x >= this.getPoints().get(i).getX() || !VfrUtil.isPointOnLine(point, this.getPoints().get(i - 1).getPoint(), this.getPoints().get(i).getPoint(), 5.0)) continue;
            return i - 1;
        }
        return -1;
    }

    public Elevation[] getSamples() {
        return this.samples;
    }

    public void setSamples(Elevation[] samples) {
        this.samples = samples;
    }

    public void setAltitude(int idx) {
        Double alt = null;
        String val = null;
        do {
            if (StringUtil.isEmpty(val = JOptionPane.showInputDialog(this.mapFrame, Messages.getInstance().get("vertical_profile_panel_set_altitude"), this.getPoints().get(idx).getAlt()))) continue;
            try {
                alt = Double.valueOf(val);
            }
            catch (NumberFormatException e) {
                val = null;
            }
        } while (val != null && StringUtil.isEmpty(val));
        if (alt != null) {
            alt = Math.round(alt);
            this.getPoints().get(idx).setAlt(alt.intValue());
            this.getPoints().get(idx).setY((int)this.calculateAltitude(alt));
            FlightPlanBean.getInstance().getRoute().getPoints().get(idx).setAlt(alt);
            MapFrame.getInstance().getUIPanel().updateRoutePoints();
            if (this.getPoints().get(idx).getY() <= 12) {
                this.calculateHeightRatio(true);
            } else {
                this.calculatePointsPositions();
            }
            this.repaint();
        }
    }

    private boolean isClimbRateInFpm() {
        return "ft".equals(SettingsBean.getInstance().getParamUnitsAltitude());
    }

    public boolean isShowPositionInTheMap() {
        return this.showPositionInTheMap;
    }

    public void setShowPositionInTheMap(boolean showPositionInTheMap) {
        this.showPositionInTheMap = showPositionInTheMap;
        if (!showPositionInTheMap) {
            MapFrame.getInstance().setMarkerPlace(null);
            MapObjectsBean.getInstance().setHighlightedMapShapes(null);
            MapFrame.getInstance().updateMap();
            this.repaint();
        } else {
            this.updateMapPosition();
        }
    }

    public boolean isLockCursorPosition() {
        return this.lockCursorPosition;
    }

    public void setLockCursorPosition(boolean lockCursorPosition) {
        this.lockCursorPosition = lockCursorPosition;
    }

    public boolean isShowRouteAltitude() {
        return this.showRouteAltitude;
    }

    public void setShowRouteAltitude(boolean showRouteAltitude) {
        this.showRouteAltitude = showRouteAltitude;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.changeZoom(-e.getWheelRotation());
    }

    public void changeZoom(int diff) {
        if (diff < 0 && this.zoom > 1 || diff > 0 && this.zoom < 10) {
            this.zoom += diff;
            this.scaleDistance = null;
            this.calculateHeightRatio(true);
            Dimension dim = MapFrame.getInstance().getSize();
            MapFrame.getInstance().setSize(new Dimension((int)dim.getWidth() + 1, (int)dim.getHeight()));
            MapFrame.getInstance().setSize(new Dimension((int)dim.getWidth() - 1, (int)dim.getHeight()));
        }
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int zoom) {
        this.zoom = zoom;
    }

    private boolean isWindData() {
        return this.windDirection != null && this.windSpeed != null;
    }

    public boolean isShowAltitudeAndDistance() {
        return this.showAltitudeAndDistance;
    }

    public void setShowAltitudeDistance(boolean showAltitudeAndDistance) {
        this.showAltitudeAndDistance = showAltitudeAndDistance;
    }

    public boolean isShowOnlyAirspacesInVerticalProfile() {
        return this.showOnlyAirspacesInVerticalProfile;
    }

    public void setShowOnlyAirspacesInVerticalProfile(boolean showOnlyAirspacesInVerticalProfile) {
        this.showOnlyAirspacesInVerticalProfile = showOnlyAirspacesInVerticalProfile;
    }

    public boolean isShowOnlyViolatedAirspaces() {
        return this.showOnlyViolatedAirspaces;
    }

    public void setShowOnlyViolatedAirspaces(boolean showOnlyViolatedAirspaces) {
        this.showOnlyViolatedAirspaces = showOnlyViolatedAirspaces;
    }

    public AirspaceAreaDTO[] getPreviousMapAirspaces() {
        return this.previousMapAirspaces;
    }

    public void setPreviousMapAirspaces(AirspaceAreaDTO[] previousMapAirspaces) {
        this.previousMapAirspaces = previousMapAirspaces;
    }

    public boolean anyAirspaces() {
        return this.previousMapAirspaces != null && this.previousMapAirspaces.length > 0;
    }

    public boolean isShowMSAs() {
        return this.showMSAs;
    }

    public void setShowMSAs(boolean showMSAs) {
        this.showMSAs = showMSAs;
    }

    private class Intersection
    implements Comparable<Intersection> {
        private final Integer pointIndex;
        private final Integer x;

        public Intersection(Integer pointIndex, Integer x) {
            this.pointIndex = pointIndex;
            this.x = x;
        }

        public Integer getPointIndex() {
            return this.pointIndex;
        }

        public Integer getX() {
            return this.x;
        }

        @Override
        public int compareTo(Intersection o) {
            return this.x.compareTo(o.getX());
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Intersection [pointIndex=");
            builder.append(this.pointIndex);
            builder.append(", x=");
            builder.append(this.x);
            builder.append("]");
            return builder.toString();
        }
    }
}

