/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.swing.panel.track;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.FpsStats;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.SimConnectBean;
import main.java.guru.vfrflight.bean.api.ExtConnectBean;
import main.java.guru.vfrflight.core.gps.GpsPoint;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.UserTrackAnalyzerDialog;
import main.java.guru.vfrflight.gui.swing.panel.image.CenteredImagePanel;
import main.java.guru.vfrflight.gui.swing.popup.UserTrackPanelPopupMenu;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.SimConnectUtil;
import main.java.guru.vfrflight.util.UnitUtil;

public class UserTrackAnalyzerPanel
extends CenteredImagePanel
implements MouseWheelListener,
MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -2967449543656957193L;
    private static final BasicStroke BASIC_STROKE_1 = new BasicStroke(1.0f);
    private static final BasicStroke BASIC_STROKE_3 = new BasicStroke(3.0f);
    private static final Color STROKE_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.5f);
    private static final Font INFO_LABEL_FONT = new Font("SansSerif", 1, 11);
    private static final Font FPS_LABEL_FONT = new Font("SansSerif", 1, 10);
    private static final int MAX_ZOOM = 10;
    public static final int BORDER = 75;
    private List<ExtConnectBean> userTrack;
    private double[] totalDistance;
    private double heightRatio = 1.0;
    private int minElevHeight = 0;
    private int maxHeight;
    private int zoom = 1;
    private UserTrackAnalyzerDialog mainDialog;
    private List<Point2D> points;
    private int currentIndex = 0;
    private static final Color SELECTION_BORDER_COLOR = new Color(0.0f, 0.0f, 1.0f);
    private static final Color SELECTION_FILL_COLOR = new Color(0.0f, 0.0f, 1.0f, 0.25f);
    private static final Font TEXT_UNDER_CURSOR_LABEL_FONT = new Font("Monospaced", 1, 12);
    private static final Color TEXT_UNDER_CURSOR_BORDER_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.5f);
    private static final Color TEXT_UNDER_CURSOR_BACKGROUND_COLOR = Color.YELLOW;
    private static final Color TEXT_CROSS_COLOR = new Color(0.0f, 0.0f, 1.0f, 0.3f);
    private boolean drawPositionOnMap = false;
    private boolean followMousePosition = false;
    private boolean showMouseInfo = false;
    private boolean showFps = false;
    private boolean showFpsLines = false;
    private FpsStats fpsStats = null;
    private boolean mousePressed = false;
    private int mousePosX;
    private int mousePosY;

    public UserTrackAnalyzerPanel(UserTrackAnalyzerDialog mainDialog, BufferedImage image, List<ExtConnectBean> userTrack, int maxHeight) {
        super(image);
        this.setBorder(null);
        this.mainDialog = mainDialog;
        this.userTrack = userTrack;
        this.maxHeight = maxHeight;
        this.calculateHeightRatio(false);
        this.calculateTotalDistance();
        this.fpsStats = SimConnectUtil.calculateStatistics(userTrack);
        this.addMouseWheelListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private void calculateTotalDistance() {
        this.totalDistance = new double[this.userTrack.size()];
        this.totalDistance[0] = 0.0;
        for (int i = 1; i < this.userTrack.size(); ++i) {
            double dist = GpsUtil.getDistance(this.userTrack.get(i - 1).getGpsPlace(), this.userTrack.get(i).getGpsPlace());
            if (!"nm".equals(SettingsBean.getInstance().getParamUnitsDistance())) {
                dist = UnitUtil.recalculateDistance(dist, "nm", SettingsBean.getInstance().getParamUnitsDistance(), false);
            }
            this.totalDistance[i] = dist + this.totalDistance[i - 1];
        }
    }

    private void refreshImage() {
        this.setImage(GraphicsUtil.createAnalyzerFrame(this.userTrack, this.maxHeight, 75, this.zoom));
    }

    public void calculateHeightRatio(boolean createImage) {
        if (createImage) {
            this.refreshImage();
        }
        int minHeight = Integer.MAX_VALUE;
        int height = Integer.MIN_VALUE;
        int gnd = 0;
        for (ExtConnectBean bean : this.userTrack) {
            if (bean.getUserAlt() == null) continue;
            gnd = Math.round(Math.max(bean.getGroundLevel(), bean.getUserAlt().floatValue()));
            if (gnd < minHeight) {
                minHeight = gnd;
            }
            if (gnd <= height) continue;
            height = gnd;
        }
        if (minHeight < 0) {
            height = -minHeight + height;
            minHeight = -minHeight;
        } else {
            minHeight = 0;
        }
        height = (int)Math.round((double)height * 1.25) + 1;
        this.heightRatio = 1.0;
        if (height > this.maxHeight) {
            this.heightRatio = (double)height / (double)this.maxHeight;
        }
        this.calculatePointsPositions();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        GraphicsUtil.setRenderingHints(g2d, SettingsBean.getInstance().getRenderingHintsQuality());
        if (this.fpsStats != null && this.showFps) {
            this.paintFps(g2d);
        }
        if (this.fpsStats != null && this.showFpsLines) {
            this.paintFpsLines(g2d);
        }
        this.paintTrack(g2d);
        this.paintPlane(g2d);
        this.paintSelection(g2d);
        if (this.showMouseInfo && !this.followMousePosition && !this.mousePressed) {
            this.paintMouseInfo(g2d);
        }
        this.paintTextInfo(g2d);
    }

    private void paintTextInfo(Graphics2D g2d) {
        g2d.setFont(INFO_LABEL_FONT);
        g2d.setColor(Color.BLACK);
        g2d.drawString(Messages.getInstance().get("user_track_analyzer_panel_text_info"), 75 + this.getImagePosX(), 75 + this.getImagePosY() - 8);
    }

    public double calculateAltitude(double alt) {
        return this.calculateAltitude(alt, true);
    }

    public double calculateAltitude(double alt, boolean round) {
        double y = (double)this.getImage().getHeight() - (alt + (double)this.minElevHeight) / this.heightRatio - 75.0;
        return round ? (double)Math.round(y) : y;
    }

    public double calculatePointsToAltitude(double y) {
        return ((double)this.getImage().getHeight() - y - 75.0) * this.heightRatio - (double)this.minElevHeight;
    }

    public void calculatePointsPositions() {
        this.getPoints().clear();
        for (int i = 0; i < this.userTrack.size(); ++i) {
            if (this.userTrack.get(i).getUserAlt() == null) continue;
            this.points.add(new GpsPoint(75 + i * this.zoom, (int)Math.round(this.calculateAltitude(this.userTrack.get(i).getUserAlt().floatValue()))));
        }
    }

    private void paintFps(Graphics2D g) {
        float fpsRatio = (float)(this.getImage().getHeight() - 150) / (this.fpsStats.getMax().floatValue() - this.fpsStats.getMin().floatValue() + 1.0f) / 1.5f;
        int index = 0;
        int offsetX = 75 + this.getImagePosX();
        if (this.zoom > 1) {
            offsetX += (int)Math.round((double)this.zoom / 2.0);
            index = this.translatePositionToIndex(this.mousePosX - (int)Math.round((double)this.zoom / 2.0), false);
        } else {
            index = this.translatePositionToIndex(this.mousePosX, false);
        }
        int offsetY = this.getImagePosY() + this.getImage().getHeight() - 75;
        int width = this.zoom > 2 ? this.zoom - 1 : this.zoom;
        g.setFont(TEXT_UNDER_CURSOR_LABEL_FONT);
        for (int i = 0; i < this.userTrack.size(); ++i) {
            Float val = ((SimConnectBean)this.userTrack.get(i)).getFps();
            if (val == null) continue;
            int height = Math.round((val.floatValue() - this.fpsStats.getMin().floatValue() + 1.0f) * fpsRatio);
            if (i == index) {
                g.setColor(Color.RED);
                String txt = String.valueOf(NumberUtil.roundFloat(val.floatValue(), 1));
                g.drawString(txt, offsetX + i * this.zoom - (int)Math.round(g.getFontMetrics().getStringBounds(txt, g).getWidth() / 2.0), offsetY + 15);
            } else {
                g.setColor(new Color(0.0f, 1.0f, 0.0f, 0.5f));
            }
            g.fillRect(offsetX + i * this.zoom, offsetY - height + 1, width, height);
        }
    }

    private void paintFpsLines(Graphics2D g) {
        int fromX = 75 + this.getImagePosX();
        int toX = 75 + this.getImagePosX() + this.userTrack.size() * this.zoom + 5;
        g.setStroke(new BasicStroke(1.0f, 0, 0, 3.0f, new float[]{5.0f}, 0.0f));
        g.setFont(FPS_LABEL_FONT);
        g.setColor(Color.RED);
        int y = this.getFpsValueYPosition(this.fpsStats.getMin().floatValue());
        g.drawLine(fromX, y, toX, y);
        g.drawString(Messages.getInstance().get("user_track_analyzer_panel_fps_min_short").toUpperCase() + " " + NumberUtil.roundFloat(this.fpsStats.getMin().floatValue(), 1), toX + 5, y);
        g.setColor(Color.MAGENTA);
        y = this.getFpsValueYPosition(this.fpsStats.getMax().floatValue());
        g.drawLine(fromX, y, toX, y);
        g.drawString(Messages.getInstance().get("user_track_analyzer_panel_fps_max_short").toUpperCase() + " " + NumberUtil.roundFloat(this.fpsStats.getMax().floatValue(), 1), toX + 5, y);
        g.setColor(Color.BLACK);
        y = this.getFpsValueYPosition(this.fpsStats.getMedian().floatValue());
        g.drawLine(fromX, y, toX, y);
        g.drawString(Messages.getInstance().get("user_track_analyzer_panel_fps_median_short").toUpperCase() + " " + NumberUtil.roundFloat(this.fpsStats.getMedian().floatValue(), 1), toX + 5, y);
        g.setColor(Color.BLUE);
        y = this.getFpsValueYPosition(this.fpsStats.getAverage().floatValue());
        g.drawLine(fromX, y, toX, y);
        g.drawString(Messages.getInstance().get("user_track_analyzer_panel_fps_avg_short").toUpperCase() + " " + NumberUtil.roundFloat(this.fpsStats.getAverage().floatValue(), 1), toX + 5, y);
        g.setColor(new Color(0.0f, 0.0f, 1.0f, 0.2f));
        int y1 = this.getFpsValueYPosition(this.fpsStats.getAverage().floatValue() - this.fpsStats.getStdDev().floatValue());
        int y2 = this.getFpsValueYPosition(this.fpsStats.getAverage().floatValue() + this.fpsStats.getStdDev().floatValue());
        g.fillRect(fromX, y - Math.round(Math.abs(y2 - y1) / 2), Math.abs(toX - fromX - 5), Math.abs(y2 - y1));
    }

    private int getFpsValueYPosition(float fpsValue) {
        float fpsRatio = (float)(this.getImage().getHeight() - 150) / (this.fpsStats.getMax().floatValue() - this.fpsStats.getMin().floatValue() + 1.0f) / 1.5f;
        return this.getImagePosY() + this.getImage().getHeight() - 75 - Math.round((fpsValue - this.fpsStats.getMin().floatValue() + 1.0f) * fpsRatio) + 1;
    }

    private void paintTrack(Graphics2D g) {
        if (this.currentIndex < this.getPoints().size()) {
            int y2;
            int x2;
            int y1;
            int x1;
            int i;
            g.setStroke(BASIC_STROKE_3);
            g.setColor(STROKE_COLOR);
            for (i = 1; i <= this.currentIndex; ++i) {
                x1 = this.getImagePosX() + (int)this.getPoints().get(i - 1).getX();
                y1 = this.getImagePosY() + (int)this.getPoints().get(i - 1).getY();
                x2 = this.getImagePosX() + (int)this.getPoints().get(i).getX();
                y2 = this.getImagePosY() + (int)this.getPoints().get(i).getY();
                g.drawLine(x1, y1, x2, y2);
            }
            for (i = 1; i <= this.currentIndex; ++i) {
                x1 = this.getImagePosX() + (int)this.getPoints().get(i - 1).getX();
                y1 = this.getImagePosY() + (int)this.getPoints().get(i - 1).getY();
                x2 = this.getImagePosX() + (int)this.getPoints().get(i).getX();
                y2 = this.getImagePosY() + (int)this.getPoints().get(i).getY();
                g.setStroke(BASIC_STROKE_1);
                if (this.userTrack.get(i).getUserAltAboveTerrain() != null) {
                    g.setColor(SettingsBean.getInstance().getColorTheme().getTrackColor(this.userTrack.get(i).getUserAltAboveTerrain().floatValue() + SimConnectUtil.getInstance().getGroundAltitudeOffset()));
                } else {
                    g.setColor(Color.WHITE);
                }
                g.drawLine(x1, y1, x2, y2);
            }
        }
    }

    private void paintMouseInfo(Graphics2D g) {
        int index;
        if (this.mousePosX >= 0 && this.mousePosY >= 0 && this.mousePosX < this.getWidth() && this.mousePosY < this.getHeight() && (index = this.translatePositionToIndex(this.mousePosX, false)) >= 0) {
            double totalDist = index > 0 ? this.totalDistance[index - 1] : 0.0;
            double calculatedAltAmsl = this.calculatePointsToAltitude(this.mousePosY);
            double calculatedAltAgl = calculatedAltAmsl - (double)this.userTrack.get(index).getGroundLevel() + (double)SimConnectUtil.getInstance().getGroundAltitudeOffset();
            if (!"ft".equals(SettingsBean.getInstance().getParamUnitsSpeed())) {
                calculatedAltAmsl = UnitUtil.recalculateAltitude(calculatedAltAmsl, "ft", SettingsBean.getInstance().getParamUnitsAltitude(), false);
                calculatedAltAgl = UnitUtil.recalculateAltitude(calculatedAltAgl, "ft", SettingsBean.getInstance().getParamUnitsAltitude(), false);
            }
            String[] txt = new String[]{NumberUtil.roundDouble(totalDist, 3) + SettingsBean.getInstance().getParamUnitsDistance(), (int)Math.round(calculatedAltAmsl) + SettingsBean.getInstance().getParamUnitsAltitude() + " AMSL", (int)Math.round(calculatedAltAgl) + SettingsBean.getInstance().getParamUnitsAltitude() + " AGL"};
            int idx = 0;
            int maxSize = 0;
            for (int i = 0; i < txt.length; ++i) {
                if (txt[i].length() <= maxSize) continue;
                maxSize = txt[i].length();
                idx = i;
            }
            g.setStroke(new BasicStroke(1.0f));
            g.setColor(TEXT_CROSS_COLOR);
            g.drawLine(75 + this.getImagePosX() - 1, this.mousePosY, this.getImagePosX() + this.getImage().getWidth() - 75 - 1, this.mousePosY);
            g.drawLine(this.mousePosX, 75 + this.getImagePosY() - 1, this.mousePosX, this.getImagePosY() + this.getImage().getHeight() - 75 - 1);
            g.setStroke(new BasicStroke(1.0f));
            g.setFont(TEXT_UNDER_CURSOR_LABEL_FONT);
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D rect = fm.getStringBounds(txt[idx], g);
            int height = (int)rect.getHeight() * txt.length + 8;
            int posX = this.mousePosX + 20;
            int posY = this.mousePosY;
            g.setColor(TEXT_UNDER_CURSOR_BACKGROUND_COLOR);
            g.fillRect(posX, posY, (int)rect.getWidth() + 10, height);
            g.setColor(TEXT_UNDER_CURSOR_BORDER_COLOR);
            g.drawRect(posX - 1, posY, (int)rect.getWidth() + 11, height + 1);
            g.setColor(Color.BLACK);
            for (int i = 0; i < txt.length; ++i) {
                g.drawString(txt[i], posX + 5, posY + (i + 1) * (int)rect.getHeight());
            }
        }
    }

    private void paintPlane(Graphics2D g) {
        if (this.currentIndex < this.getPoints().size() && this.currentIndex < this.userTrack.size()) {
            int posX = this.currentIndex * this.zoom + this.getImagePosX() + 75;
            g.setStroke(new BasicStroke(1.0f));
            g.setColor(new Color(1.0f, 0.0f, 0.0f, 0.25f));
            g.drawLine(posX, 75 + this.getImagePosY() - 1, posX, this.getImagePosY() + this.getImage().getHeight() - 75 - 1);
            GraphicsUtil.drawUserPlaneSide(g, posX, this.getImagePosY() + (int)this.getPoints().get(this.currentIndex).getY(), this.userTrack.get(this.currentIndex).getUserPitch(), 3 + this.zoom, true);
        }
    }

    private void paintSelection(Graphics2D g) {
        if (SimConnectUtil.getInstance().getSelectionEnd() != null && SimConnectUtil.getInstance().getSelectionStart() != null) {
            if (SimConnectUtil.getInstance().getSelectionEnd() < SimConnectUtil.getInstance().getSelectionStart()) {
                int temp = SimConnectUtil.getInstance().getSelectionEnd();
                SimConnectUtil.getInstance().setSelectionEnd((int)SimConnectUtil.getInstance().getSelectionStart());
                SimConnectUtil.getInstance().setSelectionStart(temp);
            }
            g.setColor(SELECTION_FILL_COLOR);
            g.fillRect(SimConnectUtil.getInstance().getSelectionStart() * this.zoom + this.getImagePosX() + 75, this.getImagePosY() + 75 - 1, (SimConnectUtil.getInstance().getSelectionEnd() - SimConnectUtil.getInstance().getSelectionStart()) * this.zoom, this.maxHeight + 1);
            g.setColor(SELECTION_BORDER_COLOR);
            g.setStroke(new BasicStroke(3.0f));
            g.drawLine(SimConnectUtil.getInstance().getSelectionStart() * this.zoom + this.getImagePosX() + 75, this.getImagePosY() + 75, SimConnectUtil.getInstance().getSelectionStart() * this.zoom + this.getImagePosX() + 75, this.getImagePosY() + this.getHeight() - 75 - 1);
            g.drawLine(SimConnectUtil.getInstance().getSelectionEnd() * this.zoom + this.getImagePosX() + 75, this.getImagePosY() + 75, SimConnectUtil.getInstance().getSelectionEnd() * this.zoom + this.getImagePosX() + 75, this.getImagePosY() + this.getHeight() - 75 - 1);
            double dist = this.totalDistance[SimConnectUtil.getInstance().getSelectionEnd()] - this.totalDistance[SimConnectUtil.getInstance().getSelectionStart()];
            if (!"nm".equals(SettingsBean.getInstance().getParamUnitsDistance())) {
                dist = UnitUtil.recalculateDistance(dist, "nm", SettingsBean.getInstance().getParamUnitsDistance(), false);
            }
            StringBuilder sb = new StringBuilder(NumberUtil.roundDouble(dist, 3) + SettingsBean.getInstance().getParamUnitsDistance());
            if (!"km".equals(SettingsBean.getInstance().getParamUnitsDistance())) {
                dist = UnitUtil.recalculateDistance(this.totalDistance[SimConnectUtil.getInstance().getSelectionEnd()] - this.totalDistance[SimConnectUtil.getInstance().getSelectionStart()], "nm", "m", false);
                sb.append(" / ");
                sb.append(Math.round(dist) + "m");
            }
            g.setFont(INFO_LABEL_FONT);
            String txt = sb.toString();
            int x = (int)Math.round((double)((SimConnectUtil.getInstance().getSelectionStart() + SimConnectUtil.getInstance().getSelectionEnd()) * this.zoom - GraphicsUtil.getStringWidth(g, txt)) / 2.0 + (double)this.getImagePosX() + 75.0);
            g.drawString(sb.toString(), x, -75 + this.getImagePosY() + this.getImage().getHeight() + 15);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getWheelRotation() > 0 && this.zoom > 1 || e.getWheelRotation() < 0 && this.zoom < 10) {
            this.zoom -= e.getWheelRotation();
            this.calculateHeightRatio(true);
            Dimension dim = this.mainDialog.getSize();
            this.mainDialog.setSize(new Dimension((int)dim.getWidth() + 1, (int)dim.getHeight()));
            this.mainDialog.setSize(new Dimension((int)dim.getWidth() - 1, (int)dim.getHeight()));
            this.revalidate();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getModifiers() == 16 && !this.mousePressed) {
            SimConnectUtil.getInstance().setSelectionStart(this.translatePositionToIndex(e.getX()));
        } else if (e.getModifiers() == 4 && e.isPopupTrigger()) {
            this.doPop(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getModifiers() == 16) {
            this.mousePressed = false;
        } else if (e.getModifiers() == 4 && e.isPopupTrigger()) {
            this.doPop(e);
        }
    }

    private void doPop(MouseEvent e) {
        int x = e.getX() - this.getImagePosX() + 1;
        int y = e.getY() - this.getImagePosY() + 1;
        if (x >= 0 && y >= 0) {
            UserTrackPanelPopupMenu popupMenu = new UserTrackPanelPopupMenu(this, x, y);
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int zoom) {
        this.zoom = zoom;
    }

    public List<Point2D> getPoints() {
        if (this.points == null) {
            this.points = new LinkedList<Point2D>();
        }
        return this.points;
    }

    public void setPoints(List<Point2D> points) {
        this.points = points;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(int currentIndex) {
        this.currentIndex = currentIndex;
    }

    public boolean isDrawPositionOnMap() {
        return this.drawPositionOnMap;
    }

    public void setDrawPositionOnMap(boolean drawPositionOnMap) {
        this.drawPositionOnMap = drawPositionOnMap;
    }

    public ExtConnectBean getCurrentUserBean() {
        return this.getUserTrack().get(this.currentIndex);
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    public void findTakeOff() {
        for (int i = this.currentIndex + 1; i < this.getUserTrack().size() - 1; ++i) {
            if (!this.userTrack.get(i).isOnGround() || this.userTrack.get(i + 1).isOnGround()) continue;
            this.mainDialog.getSlider().setValue(i + 1);
            break;
        }
    }

    public void findTouchDown() {
        for (int i = this.currentIndex + 1; i < this.getUserTrack().size() - 1; ++i) {
            if (this.userTrack.get(i).isOnGround() || !this.userTrack.get(i + 1).isOnGround()) continue;
            this.mainDialog.getSlider().setValue(i + 1);
            break;
        }
    }

    public void setIndex(int value) {
        this.setCurrentIndex(value);
        this.repaint();
        if (this.isDrawPositionOnMap()) {
            SimConnectUtil.getInstance().setSelectedUserTrackPoint(this.getCurrentIndex());
            MapFrame.getInstance().updateMap();
        }
    }

    public boolean isFollowMousePosition() {
        return this.followMousePosition;
    }

    public void setFollowMousePosition(boolean followMousePosition) {
        this.followMousePosition = followMousePosition;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (e.getModifiers() == 16) {
            if (this.mousePressed) {
                SimConnectUtil.getInstance().setSelectionEnd(this.translatePositionToIndex(e.getX()));
                MapFrame.getInstance().updateMap();
                this.repaint();
            }
            this.mousePressed = true;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.followMousePosition) {
            this.mainDialog.getSlider().setValue(this.translatePositionToIndex(e.getX()));
        }
        if (this.showFps || !this.followMousePosition && this.showMouseInfo) {
            this.mousePosX = e.getX();
            this.mousePosY = e.getY();
            this.repaint();
        }
    }

    private int translatePositionToIndex(int posX) {
        return this.translatePositionToIndex(posX, true);
    }

    private int translatePositionToIndex(int posX, boolean forceBounds) {
        int index = (int)Math.floor((posX - this.getImagePosX() + 1 - 75) / this.zoom);
        if (index < 0) {
            index = forceBounds ? 0 : -1;
        } else if (index >= this.userTrack.size()) {
            index = forceBounds ? this.userTrack.size() - 1 : -1;
        }
        return index;
    }

    public void selectionClearAction() {
        SimConnectUtil.getInstance().setSelectionStart(null);
        SimConnectUtil.getInstance().setSelectionEnd(null);
        MapFrame.getInstance().updateMap();
        this.repaint();
    }

    public boolean isShowMouseInfo() {
        return this.showMouseInfo;
    }

    public void setShowMouseInfo(boolean showMouseInfo) {
        this.showMouseInfo = showMouseInfo;
    }

    public UserTrackAnalyzerDialog getMainDialog() {
        return this.mainDialog;
    }

    public void setMainDialog(UserTrackAnalyzerDialog mainDialog) {
        this.mainDialog = mainDialog;
    }

    public boolean isShowFps() {
        return this.showFps;
    }

    public void setShowFps(boolean showFps) {
        this.showFps = showFps;
    }

    public FpsStats getFpsStats() {
        return this.fpsStats;
    }

    public void setFpsStats(FpsStats fpsStats) {
        this.fpsStats = fpsStats;
    }

    public void getFpsStatsAction() {
        StringBuilder sb = new StringBuilder("<html>");
        if (this.fpsStats.getMin() != null) {
            sb.append("<strong>");
            sb.append(Messages.getInstance().get("user_track_analyzer_panel_fps_min"));
            sb.append(":</strong>&nbsp;");
            sb.append(NumberUtil.roundFloat(this.fpsStats.getMin().floatValue(), 1));
            sb.append("<br/>");
        }
        if (this.fpsStats.getMax() != null) {
            sb.append("<strong>");
            sb.append(Messages.getInstance().get("user_track_analyzer_panel_fps_max"));
            sb.append(":</strong>&nbsp;");
            sb.append(NumberUtil.roundFloat(this.fpsStats.getMax().floatValue(), 1));
            sb.append("<br/>");
        }
        if (this.fpsStats.getAverage() != null) {
            sb.append("<strong>");
            sb.append(Messages.getInstance().get("user_track_analyzer_panel_fps_avg"));
            sb.append(":</strong>&nbsp;");
            sb.append(NumberUtil.roundFloat(this.fpsStats.getAverage().floatValue(), 1));
            sb.append("<br/>");
        }
        if (this.fpsStats.getMedian() != null) {
            sb.append("<strong>");
            sb.append(Messages.getInstance().get("user_track_analyzer_panel_fps_median"));
            sb.append(":</strong>&nbsp;");
            sb.append(NumberUtil.roundFloat(this.fpsStats.getMedian().floatValue(), 1));
            sb.append("<br/>");
        }
        if (this.fpsStats.getStdDev() != null) {
            sb.append("<strong>");
            sb.append(Messages.getInstance().get("user_track_analyzer_panel_fps_std_dev"));
            sb.append(":</strong>&nbsp;");
            sb.append(NumberUtil.roundFloat(this.fpsStats.getStdDev().floatValue(), 3));
            sb.append("<br/>");
        }
        sb.append("</html>");
        JOptionPane.showMessageDialog(this.mainDialog, sb.toString(), "", 1);
    }

    public boolean isShowFpsLines() {
        return this.showFpsLines;
    }

    public void setShowFpsLines(boolean showFpsLines) {
        this.showFpsLines = showFpsLines;
    }

    public List<ExtConnectBean> getUserTrack() {
        return this.userTrack;
    }

    public void setUserTrack(List<ExtConnectBean> userTrack) {
        this.userTrack = userTrack;
    }
}

