/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.swing.panel.track;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.api.ExtConnectBean;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.UnitUtil;

public class InfoPanel
extends JPanel {
    private static final long serialVersionUID = -1553459351453233592L;
    private ExtConnectBean bean;
    private float groundAltitudeOffset = 0.0f;
    private static final Font LABEL_TIMESTAMP_FONT = new Font("Monospaced", 1, 10);
    private static final int LABEL_FONT_SIZE = 13;
    private static final Font LABEL_FONT = new Font("SansSerif", 0, 13);
    private final Color backgroundColor;

    public InfoPanel(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Override
    public void paintComponent(Graphics g) {
        double userIndAmslAlt;
        double gs;
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        GraphicsUtil.setRenderingHints(g2d, SettingsBean.getInstance().getRenderingHintsQuality());
        g2d.setColor(this.backgroundColor);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        double ias = this.bean.getUserIndicatedSpeed() != null ? (double)this.bean.getUserIndicatedSpeed().floatValue() : 0.0;
        double d = gs = this.bean.getUserGs() != null ? (double)this.bean.getUserGs().floatValue() : 0.0;
        if (!"kt".equals(SettingsBean.getInstance().getParamUnitsSpeed())) {
            ias = UnitUtil.recalculateSpeed(ias, "kt", SettingsBean.getInstance().getParamUnitsSpeed(), false);
            gs = UnitUtil.recalculateSpeed(gs, "kt", SettingsBean.getInstance().getParamUnitsSpeed(), false);
        }
        double groundAlt = 0.0;
        double amslAlt = this.bean.getUserAlt() != null ? (double)this.bean.getUserAlt().floatValue() : 0.0;
        double d2 = userIndAmslAlt = this.bean.getUserIndicatedAlt() != null ? (double)this.bean.getUserIndicatedAlt().floatValue() : 0.0;
        if (!this.bean.isOnGround() && this.bean.getUserAltAboveTerrain() != null) {
            groundAlt = this.bean.getUserAltAboveTerrain().floatValue() + this.groundAltitudeOffset;
        }
        if (!"ft".equals(SettingsBean.getInstance().getParamUnitsSpeed())) {
            groundAlt = UnitUtil.recalculateAltitude(groundAlt, "ft", SettingsBean.getInstance().getParamUnitsAltitude(), false);
            amslAlt = UnitUtil.recalculateAltitude(amslAlt, "ft", SettingsBean.getInstance().getParamUnitsAltitude(), false);
            userIndAmslAlt = UnitUtil.recalculateAltitude(userIndAmslAlt, "ft", SettingsBean.getInstance().getParamUnitsAltitude(), false);
        }
        String vSpeed = null;
        if (this.bean.getUserVerticalSpeed() != null && !"ft".equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
            vSpeed = String.valueOf(UnitUtil.recalculateVerticalSpeed(this.bean.getUserVerticalSpeed().floatValue(), "fpm", "m/s", true));
        } else if (this.bean.getUserVerticalSpeed() != null) {
            vSpeed = String.valueOf(Math.round(this.bean.getUserVerticalSpeed().floatValue()));
        }
        int yOffset = 25;
        g2d.setFont(LABEL_FONT);
        String[] txt = new String[]{"IAS " + Math.round(ias) + SettingsBean.getInstance().getParamUnitsSpeed(), "GS " + Math.round(gs) + SettingsBean.getInstance().getParamUnitsSpeed(), Math.round(groundAlt) + SettingsBean.getInstance().getParamUnitsAltitude() + " AGL", Math.round(amslAlt) + SettingsBean.getInstance().getParamUnitsAltitude() + " AMSL", "(BARO) " + Math.round(userIndAmslAlt) + SettingsBean.getInstance().getParamUnitsAltitude() + " AMSL", vSpeed != null ? vSpeed + ("ft".equals(SettingsBean.getInstance().getParamUnitsAltitude()) ? "fpm" : "m/s") : "", this.bean.getgForce() != null ? NumberUtil.roundFloat(this.bean.getgForce().floatValue(), 3) + "g" : ""};
        int maxWidth = 0;
        for (String t : txt) {
            int w = (int)Math.round(g2d.getFontMetrics().getStringBounds(t, g2d).getWidth());
            if (w <= maxWidth) continue;
            maxWidth = w;
        }
        GraphicsUtil.fillRectWithBorder(g2d, Math.round((this.getWidth() - (maxWidth += 20)) / 2), yOffset - 20, maxWidth, 13 * txt.length + 30, new Color(200, 200, 200), Color.LIGHT_GRAY);
        g2d.setColor(Color.RED);
        GraphicsUtil.drawCenteredString(g, txt[0], yOffset + 13, this.getWidth());
        GraphicsUtil.drawCenteredString(g, txt[1], yOffset + 26, this.getWidth());
        g2d.setColor(Color.MAGENTA);
        GraphicsUtil.drawCenteredString(g2d, txt[2], yOffset + 39, this.getWidth());
        GraphicsUtil.drawCenteredString(g2d, txt[3], yOffset + 52, this.getWidth());
        GraphicsUtil.drawCenteredString(g2d, txt[4], yOffset + 65, this.getWidth());
        g2d.setColor(Color.BLUE);
        GraphicsUtil.drawCenteredString(g, txt[5], yOffset + 78, this.getWidth());
        g2d.setColor(Color.WHITE);
        GraphicsUtil.drawCenteredString(g, txt[6], yOffset + 91, this.getWidth());
        if (this.bean.getTimestamp() != null) {
            g2d.setColor(Color.BLACK);
            g2d.setFont(LABEL_TIMESTAMP_FONT);
            GraphicsUtil.drawCenteredString(g, FormatUtil.formatTimestamp(this.bean.getTimestamp()), yOffset - 5, this.getWidth());
        }
    }

    public ExtConnectBean getBean() {
        return this.bean;
    }

    public void setBean(ExtConnectBean bean) {
        this.bean = bean;
    }

    public float getGroundAltitudeOffset() {
        return this.groundAltitudeOffset;
    }

    public void setGroundAltitudeOffset(float groundAltitudeOffset) {
        this.groundAltitudeOffset = groundAltitudeOffset;
    }
}

