/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.swing.panel.track;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.guru.vfrflight.util.UnitUtil;

public class HeadingPanel
extends JPanel {
    private static final long serialVersionUID = 1746210599816485314L;
    private double heading;
    private double windDirection;
    private double windVelocity;
    private Color WIND_ARROW_COLOR = Color.LIGHT_GRAY;
    private static final Font LABEL_WIND_FONT = new Font("Monospaced", 0, 10);
    private final Color backgroundColor;

    public HeadingPanel(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        GraphicsUtil.setRenderingHints(g2d, SettingsBean.getInstance().getRenderingHintsQuality());
        g2d.setColor(this.backgroundColor);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        int size = Math.min(this.getWidth(), this.getHeight()) - 4;
        g2d.setColor(Color.BLUE);
        g2d.setStroke(new BasicStroke(3.0f));
        g2d.drawOval(Math.round((this.getWidth() - size) / 2), Math.round((this.getHeight() - size) / 2), size, size);
        g2d.setColor(Color.BLACK);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.drawOval(Math.round((this.getWidth() - size) / 2), Math.round((this.getHeight() - size) / 2), size, size);
        int cx = Math.round(this.getWidth() / 2);
        int cy = Math.round(this.getHeight() / 2);
        GraphicsUtil.drawWindArrow(g2d, cx, cy, this.getHeight(), this.windDirection, 25, this.WIND_ARROW_COLOR);
        g2d.setFont(LABEL_WIND_FONT);
        g2d.setColor(Color.BLACK);
        String windSpeed = null;
        windSpeed = !"kt".equals(SettingsBean.getInstance().getParamUnitsWindSpeed()) ? String.valueOf(UnitUtil.recalculateWindSpeed(this.windVelocity, "kt", SettingsBean.getInstance().getParamUnitsWindSpeed(), true)) : String.valueOf(Math.round(this.windVelocity));
        g2d.drawString(FormatUtil.formattedCourse(this.windDirection, true) + "@" + windSpeed, cx, cy + 40);
        size = Math.min(this.getWidth() / 20, this.getHeight() / 20);
        GraphicsUtil.drawUserPlaneTop(g2d, cx, cy, Float.valueOf((float)this.heading), size, false);
    }

    public double getHeading() {
        return this.heading;
    }

    public void setHeading(double heading) {
        this.heading = heading;
    }

    public double getWindDirection() {
        return this.windDirection;
    }

    public void setWindDirection(double windDirection) {
        this.windDirection = windDirection;
    }

    public double getWindVelocity() {
        return this.windVelocity;
    }

    public void setWindVelocity(double windVelocity) {
        this.windVelocity = windVelocity;
    }
}

