/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.swing.panel.track;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.util.GraphicsUtil;

public class ControlsPanel
extends JPanel {
    private static final long serialVersionUID = 8051497676094651620L;
    private float yokeXPosition;
    private float yokeYPosition;
    private float rudderPedalsPosition;
    private short flapsPosition;
    private final Color backgroundColor;

    public ControlsPanel(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        GraphicsUtil.setRenderingHints(g2d, SettingsBean.getInstance().getRenderingHintsQuality());
        g2d.setColor(this.backgroundColor);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        int size = Math.min(this.getWidth(), this.getHeight()) - 24;
        int halfsize = Math.round(size / 2);
        g2d.setColor(Color.BLUE);
        g2d.setStroke(new BasicStroke(3.0f));
        g2d.drawOval(2, 2, size, size);
        g2d.setColor(Color.BLACK);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.drawOval(2, 2, size, size);
        g2d.setColor(Color.LIGHT_GRAY);
        g2d.drawLine(5, 2 + halfsize, 2 + size - 3, 2 + halfsize);
        g2d.drawLine(2 + halfsize, 5, 2 + halfsize, 2 + size - 3);
        g2d.drawLine(2, this.getHeight() - 10, this.getWidth() - 22, this.getHeight() - 10);
        g2d.drawLine(2 + halfsize, this.getHeight() - 17, 2 + halfsize, this.getHeight() - 2);
        g2d.drawLine(2 + size + 10, 2, 2 + size + 10, 2 + size);
        g2d.setColor(Color.BLACK);
        g2d.setStroke(new BasicStroke(5.0f));
        g2d.drawLine(Math.round((float)(2 + halfsize) + this.rudderPedalsPosition * (float)halfsize), this.getHeight() - 17, Math.round((float)(2 + halfsize) + this.rudderPedalsPosition * (float)halfsize), this.getHeight() - 2);
        g2d.drawLine(2 + size + 5, 2 + (int)Math.round((double)this.flapsPosition / 100.0 * (double)size), 2 + size + 15, 2 + (int)Math.round((double)this.flapsPosition / 100.0 * (double)size));
        g2d.setStroke(new BasicStroke(1.0f));
        GraphicsUtil.fillOvalWithBorder(g2d, 2 + halfsize + Math.round(this.yokeXPosition * (float)halfsize) - 7, 2 + halfsize + Math.round(this.yokeYPosition * (float)halfsize) - 7, 13, 13, Color.RED, Color.WHITE);
    }

    public float getYokeXPosition() {
        return this.yokeXPosition;
    }

    public void setYokeXPosition(float yokeXPosition) {
        this.yokeXPosition = yokeXPosition;
    }

    public float getYokeYPosition() {
        return this.yokeYPosition;
    }

    public void setYokeYPosition(float yokeYPosition) {
        this.yokeYPosition = yokeYPosition;
    }

    public float getRudderPedalsPosition() {
        return this.rudderPedalsPosition;
    }

    public void setRudderPedalsPosition(float rudderPedalsPosition) {
        this.rudderPedalsPosition = rudderPedalsPosition;
    }

    public short getFlapsPosition() {
        return this.flapsPosition;
    }

    public void setFlapsPosition(short flapsPosition) {
        this.flapsPosition = flapsPosition;
    }
}

