/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.swing.panel.track;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.util.GraphicsUtil;

public class BankPanel
extends JPanel {
    private static final long serialVersionUID = 2671912509589386158L;
    private float bank = 0.0f;
    private static final Font LABEL_FONT = new Font("Monospaced", 1, 12);
    private final Color backgroundColor;

    public BankPanel(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        GraphicsUtil.setRenderingHints(g2d, SettingsBean.getInstance().getRenderingHintsQuality());
        g2d.setColor(this.backgroundColor);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        int size = Math.min(this.getWidth(), this.getHeight()) - 4;
        g2d.setColor(Color.BLUE);
        g2d.setStroke(new BasicStroke(3.0f));
        g2d.drawOval(Math.round((this.getWidth() - size) / 2), Math.round((this.getHeight() - size) / 2), size, size);
        g2d.setColor(Color.BLACK);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.drawOval(Math.round((this.getWidth() - size) / 2), Math.round((this.getHeight() - size) / 2), size, size);
        double rotation = Math.toRadians(-this.bank);
        double rotation2 = Math.toRadians(this.bank);
        if (!Double.isNaN(rotation) && !Double.isNaN(rotation2)) {
            int cx = Math.round(this.getWidth() / 2);
            int cy = Math.round(this.getHeight() / 2);
            g2d.translate(cx, cy);
            g2d.rotate(rotation);
            g2d.translate(-cx, -cy);
            g2d.setColor(Color.BLACK);
            g2d.setStroke(new BasicStroke(3.0f));
            g2d.drawLine(Math.round(size / 6), cy, cx - 6, cy);
            g2d.drawOval(cx - 6, cy - 6, 12, 12);
            g2d.drawLine(cx + 6, cy, size + 2 - Math.round(size / 6), cy);
            g2d.drawLine(cx, cy - 6, cx, cy - 25);
            g2d.translate(cx, cy);
            g2d.rotate(rotation2);
            g2d.translate(-cx, -cy);
            g2d.setFont(LABEL_FONT);
            g2d.setColor(Color.MAGENTA);
            g2d.drawString(Math.round(Math.abs(this.bank)) + "\u00b0", cx + 10, cy + 40);
        }
    }

    public float getBank() {
        return this.bank;
    }

    public void setBank(float bank) {
        this.bank = bank;
    }
}

