/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.swing.panel.image;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class ImageViewerPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private static final long serialVersionUID = 4415579846974287012L;
    private static final Logger log = Logger.getLogger(ImageViewerPanel.class);
    private static final int MAX_ZOOM = 5;
    private int zoom = 1;
    private BufferedImage originalImage;
    private BufferedImage visibleImage;
    private int imageOffsetX = 0;
    private int imageOffsetY = 0;
    private int visibleWidth;
    private int visibleHeight;
    private int visiblePosX;
    private int visiblePosY;
    private int prevMouseX = 0;
    private int prevMouseY = 0;
    private boolean mousePressed = false;

    public ImageViewerPanel() {
        this((String)null);
    }

    public ImageViewerPanel(String path) {
        if (path != null) {
            this.loadImage(path);
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getWheelRotation() > 0 && this.getZoom() > 1 || e.getWheelRotation() < 0 && this.getZoom() < 5) {
            this.setZoom(this.getZoom() - e.getWheelRotation());
            this.updateVisibleImage();
        }
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int zoom) {
        this.zoom = zoom;
    }

    public void updateVisibleImage() {
        int w = (int)Math.floor(this.visibleWidth / this.zoom);
        int h = (int)Math.floor(this.visibleHeight / this.zoom);
        log.info("updateVisibleImage: " + this.imageOffsetX + "; " + this.imageOffsetY + "; " + this.zoom + "; " + w + "; " + h);
        if (w > 0 && h > 0) {
            BufferedImage croppedImage = new BufferedImage(w, h, 2);
            Graphics2D g2 = croppedImage.createGraphics();
            g2.drawImage((Image)this.originalImage, -this.imageOffsetX, -this.imageOffsetY, null);
            g2.dispose();
            if (this.zoom != 1) {
                Image tmp = croppedImage.getScaledInstance(croppedImage.getWidth() * this.getZoom(), croppedImage.getHeight() * this.getZoom(), 1);
                BufferedImage dimg = new BufferedImage(croppedImage.getWidth() * this.getZoom(), croppedImage.getHeight() * this.getZoom(), 2);
                Graphics2D g2d = dimg.createGraphics();
                g2d.drawImage(tmp, 0, 0, null);
                g2d.dispose();
                this.setVisibleImage(dimg);
            } else {
                this.setVisibleImage(croppedImage);
            }
        }
        this.repaint();
    }

    public BufferedImage getOriginalImage() {
        return this.originalImage;
    }

    public void setOriginalImage(BufferedImage originalImage) {
        this.originalImage = originalImage;
    }

    public void loadImage(String path) {
        this.visiblePosX = 0;
        this.visiblePosY = 0;
        this.visibleWidth = 0;
        this.visibleHeight = 0;
        try {
            this.setVisibleImage(ImageIO.read(new File(path)));
            if (this.visibleWidth == 0) {
                this.visibleWidth = this.visibleImage.getWidth() / 2;
            }
            if (this.visibleHeight == 0) {
                this.visibleHeight = this.visibleImage.getHeight() / 2;
            }
        }
        catch (IOException e) {
            log.error(e);
        }
        this.setOriginalImage(this.getVisibleImage());
    }

    public BufferedImage getVisibleImage() {
        return this.visibleImage;
    }

    public void setVisibleImage(BufferedImage visibleImage) {
        this.visibleImage = visibleImage;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.visibleImage != null) {
            g.drawImage(this.visibleImage, this.visiblePosX, this.visiblePosY, null);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.visibleImage != null) {
            return new Dimension(this.visibleImage.getWidth(), this.visibleImage.getHeight());
        }
        return new Dimension(0, 0);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (this.mousePressed) {
            int dx = this.prevMouseX - x;
            int dy = this.prevMouseY - y;
            this.imageOffsetX += (int)Math.ceil(dx / this.zoom);
            this.imageOffsetY += (int)Math.ceil(dy / this.zoom);
            if (this.imageOffsetX < 0) {
                this.imageOffsetX = 0;
            } else if (this.imageOffsetX > this.visibleWidth * this.zoom - this.visibleImage.getWidth()) {
                this.imageOffsetX = this.visibleWidth * this.zoom - this.visibleImage.getWidth();
            }
            if (this.imageOffsetY < 0) {
                this.imageOffsetY = 0;
            } else if (this.imageOffsetY > this.visibleHeight * this.zoom - this.visibleImage.getHeight()) {
                this.imageOffsetY = this.visibleHeight * this.zoom - this.visibleImage.getHeight();
            }
            this.updateVisibleImage();
            this.setCursor(Cursor.getPredefinedCursor(13));
        }
        this.mousePressed = true;
        this.prevMouseX = x;
        this.prevMouseY = y;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.mousePressed = false;
    }
}

