/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.swing.panel.image;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import main.java.guru.vfrflight.util.GraphicsUtil;
import org.apache.log4j.Logger;

public class CenteredImagePanel
extends JPanel {
    private static final Logger log = Logger.getLogger(CenteredImagePanel.class);
    private static final long serialVersionUID = -2097108452952712788L;
    private BufferedImage image;
    private BufferedImage originalImage;
    private int imagePosX = 0;
    private int imagePosY = 0;
    private boolean shrinkToFit = false;
    private boolean enlargeToFit = false;

    public CenteredImagePanel() {
    }

    public CenteredImagePanel(boolean scaleToFit) {
        this.shrinkToFit = scaleToFit;
        this.enlargeToFit = scaleToFit;
    }

    public CenteredImagePanel(BufferedImage image) {
        this.image = image;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image != null) {
            this.imagePosX = (int)Math.round((this.getBounds().getWidth() - (double)this.image.getWidth()) / 2.0);
            this.imagePosY = (int)Math.round((this.getBounds().getHeight() - (double)this.image.getHeight()) / 2.0);
            if (this.imagePosX >= 0 && this.imagePosY >= 0) {
                if (!this.enlargeToFit || this.imagePosX == 0 && this.imagePosY == 0) {
                    g.drawImage(this.image, this.imagePosX, this.imagePosY, null);
                } else {
                    this.scaleToFitAndDraw(g);
                }
            } else if (this.shrinkToFit) {
                this.scaleToFitAndDraw(g);
            } else {
                int w = this.image.getWidth();
                int h = this.image.getHeight();
                int cx = 0;
                int cy = 0;
                if (this.imagePosX < 0) {
                    w += this.imagePosX * 2;
                    cx = -this.imagePosX;
                    this.imagePosX = 0;
                }
                if (this.imagePosY < 0) {
                    h += this.imagePosY * 2;
                    cy = -this.imagePosY;
                    this.imagePosY = 0;
                }
                g.drawImage(this.image.getSubimage(cx, cy, w, h), this.imagePosX, this.imagePosY, null);
            }
        }
    }

    private void scaleToFitAndDraw(Graphics g) {
        if (this.originalImage == null) {
            this.originalImage = this.image;
        }
        double wRatio = this.getBounds().getWidth() / (double)this.originalImage.getWidth();
        double hRatio = this.getBounds().getHeight() / (double)this.originalImage.getHeight();
        double ratio = Math.min(wRatio, hRatio);
        int w = (int)Math.round((double)this.originalImage.getWidth() * ratio);
        int h = (int)Math.round((double)this.originalImage.getHeight() * ratio);
        BufferedImage resizedImage = new BufferedImage(w, h, this.originalImage.getType());
        Graphics2D g2 = resizedImage.createGraphics();
        GraphicsUtil.setRenderingHintsHighQuality(g2);
        g2.drawImage(this.originalImage, 0, 0, w, h, null);
        g2.dispose();
        this.image = resizedImage;
        this.imagePosX = (int)Math.round((this.getBounds().getWidth() - (double)this.image.getWidth()) / 2.0);
        this.imagePosY = (int)Math.round((this.getBounds().getHeight() - (double)this.image.getHeight()) / 2.0);
        g.drawImage(this.image, this.imagePosX, this.imagePosY, w, h, null);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.image != null) {
            return new Dimension(this.image.getWidth(), this.image.getHeight());
        }
        return new Dimension(0, 0);
    }

    public void loadImage(String path) {
        try {
            this.setImage(ImageIO.read(new File(path)));
        }
        catch (IOException e) {
            log.error(e, e);
        }
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void clearImage() {
        this.setImage(null);
    }

    public void setImage(BufferedImage image) {
        this.originalImage = null;
        this.image = image;
        if (image != null) {
            this.setPreferredSize(new Dimension(image.getWidth(), image.getHeight()));
        }
        this.repaint();
    }

    public int getImagePosX() {
        return this.imagePosX;
    }

    public int getImagePosY() {
        return this.imagePosY;
    }
}

