/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.swing.panel.file;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.ExtensionFileFilter;
import main.java.guru.vfrflight.util.GuiUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UrlUtil;

public class HgtFileChooserPanel
extends JPanel {
    private static final long serialVersionUID = -2612400375157168882L;
    private JTextField sceneryConfigPathTextField;
    private final boolean file;
    private String chosenPath = "";
    private final String extDescription;
    private final String extension;
    private JButton selectButton;
    private JButton openInBrowserButton;
    private JButton autoDownloadButton;
    private JLabel sceneryConfigFile;
    private JPanel buttonPanel;

    public HgtFileChooserPanel(String label, String extDescription, String extension, boolean file, int columns) {
        this.setLayout(new BorderLayout(0, 0));
        JPanel sceneryConfigPathFileChooserPanel = new JPanel();
        this.add((Component)sceneryConfigPathFileChooserPanel, "Center");
        this.sceneryConfigPathTextField = new JTextField();
        this.sceneryConfigPathTextField.setEditable(false);
        sceneryConfigPathFileChooserPanel.add(this.sceneryConfigPathTextField);
        this.sceneryConfigPathTextField.setColumns(columns);
        this.selectButton = new JButton(Messages.getInstance().get("select_button") + " ...");
        this.selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                HgtFileChooserPanel.this.selectPathAction();
            }
        });
        sceneryConfigPathFileChooserPanel.add(this.selectButton);
        JPanel labelPanel = new JPanel();
        this.add((Component)labelPanel, "North");
        this.sceneryConfigFile = new JLabel(label);
        labelPanel.add(this.sceneryConfigFile);
        this.sceneryConfigFile.setHorizontalAlignment(0);
        this.file = file;
        this.extDescription = extDescription;
        this.extension = extension;
        this.buttonPanel = new JPanel();
        this.add((Component)this.buttonPanel, "South");
        this.openInBrowserButton = new JButton(Messages.getInstance().get("hgt_file_chooser_open_in_browser_button"));
        this.buttonPanel.add(this.openInBrowserButton);
        this.autoDownloadButton = new JButton(Messages.getInstance().get("hgt_file_chooser_auto_download_files_button"));
        this.buttonPanel.add(this.autoDownloadButton);
        this.openInBrowserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                HgtFileChooserPanel.this.openInBrowserAction();
            }
        });
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.selectButton.setEnabled(enabled);
        this.openInBrowserButton.setEnabled(enabled);
        this.sceneryConfigFile.setEnabled(enabled);
        this.sceneryConfigPathTextField.setEnabled(enabled);
        this.autoDownloadButton.setEnabled(enabled);
    }

    public void openInBrowserAction() {
        UrlUtil.openUrlInBrowser("http://www.viewfinderpanoramas.org/Coverage%20map%20viewfinderpanoramas_org3.htm");
    }

    public void selectPathAction() {
        JFileChooser chooser = GuiUtil.getFileChooser(Messages.getInstance().get(this.isFile() ? "select_file" : "select_directory"), Messages.getInstance().get("select"));
        chooser.setFileSelectionMode(this.isFile() ? 0 : 1);
        if (this.extDescription != null && this.extension != null) {
            chooser.setFileFilter(new ExtensionFileFilter(this.extDescription, new String[]{this.extension}));
        }
        if (!StringUtil.isEmpty(this.chosenPath)) {
            chooser.setSelectedFile(new File(this.chosenPath));
        }
        if (chooser.showOpenDialog(this) == 0) {
            this.setChosenPath(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    public String getChosenPath() {
        return this.chosenPath;
    }

    public void setChosenPath(String chosenPath) {
        this.chosenPath = chosenPath;
        this.sceneryConfigPathTextField.setText(chosenPath);
    }

    public boolean isFile() {
        return this.file;
    }

    public boolean isPathSelected() {
        return !StringUtil.isEmpty(this.chosenPath);
    }

    public JButton getAutoDownloadButton() {
        return this.autoDownloadButton;
    }

    public void setAutoDownloadButton(JButton autoDownloadButton) {
        this.autoDownloadButton = autoDownloadButton;
    }
}

