/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.swing.panel.file;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.ExtensionFileFilter;
import main.java.guru.vfrflight.util.GuiUtil;
import main.java.guru.vfrflight.util.StringUtil;

public class FileChooserPanel
extends JPanel {
    private static final long serialVersionUID = -2612400375157168882L;
    private JTextField sceneryConfigPathTextField;
    private final boolean file;
    private String chosenPath = "";
    private final String extDescription;
    private final String extension;
    private JButton selectButton;

    public FileChooserPanel(String label, boolean file) {
        this(label, null, null, file, 40);
    }

    public FileChooserPanel(String label, String extDescription, String extension, boolean file, int columns) {
        this.setLayout(new BorderLayout(0, 0));
        JPanel sceneryConfigPathFileChooserPanel = new JPanel();
        this.add((Component)sceneryConfigPathFileChooserPanel, "Center");
        this.sceneryConfigPathTextField = new JTextField();
        this.sceneryConfigPathTextField.setEditable(false);
        sceneryConfigPathFileChooserPanel.add(this.sceneryConfigPathTextField);
        this.sceneryConfigPathTextField.setColumns(columns);
        this.selectButton = new JButton(Messages.getInstance().get("select_button") + " ...");
        this.selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FileChooserPanel.this.selectPathAction();
            }
        });
        sceneryConfigPathFileChooserPanel.add(this.selectButton);
        JPanel labelPanel = new JPanel();
        this.add((Component)labelPanel, "North");
        JLabel lblSceneryConfigFile = new JLabel(label);
        labelPanel.add(lblSceneryConfigFile);
        lblSceneryConfigFile.setHorizontalAlignment(0);
        this.file = file;
        this.extDescription = extDescription;
        this.extension = extension;
    }

    public void selectPathAction() {
        JFileChooser chooser = GuiUtil.getFileChooser(Messages.getInstance().get(this.isFile() ? "select_file" : "select_directory"), Messages.getInstance().get("select"));
        chooser.setFileSelectionMode(this.isFile() ? 0 : 1);
        if (this.extDescription != null && this.extension != null) {
            chooser.setFileFilter(new ExtensionFileFilter(this.extDescription, new String[]{this.extension}));
        }
        if (!StringUtil.isEmpty(this.chosenPath)) {
            chooser.setSelectedFile(new File(this.chosenPath));
        }
        if (chooser.showOpenDialog(this) == 0) {
            this.setChosenPath(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    public String getChosenPath() {
        return this.chosenPath;
    }

    public void setChosenPath(String chosenPath) {
        this.chosenPath = chosenPath;
        this.sceneryConfigPathTextField.setText(chosenPath);
    }

    public boolean isFile() {
        return this.file;
    }

    public boolean isPathSelected() {
        return !StringUtil.isEmpty(this.chosenPath);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.selectButton.setEnabled(enabled);
    }
}

