/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.swing.panel;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.GraphicsUtil;

public class WindCanvas
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -5316651789756263207L;
    private Color backgroundColor = Color.WHITE;
    private Color backgroundArrowColor = Color.WHITE;
    private static final int ARROW_LENGTH = 15;
    private Double windDir = null;
    private int cx;
    private int cy;

    public WindCanvas() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.cx = Math.round(this.getWidth() / 2);
        this.cy = Math.round(this.getHeight() / 2);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        GraphicsUtil.setRenderingHints(g2d, SettingsBean.getInstance().getRenderingHintsQuality());
        g2d.setColor(this.backgroundColor);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setColor(this.backgroundArrowColor);
        g2d.setStroke(new BasicStroke(3.0f));
        g2d.drawOval(2, 2, this.getWidth() - 4, this.getHeight() - 4);
        g2d.setColor(Color.BLACK);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.drawOval(2, 2, this.getWidth() - 4, this.getHeight() - 4);
        if (this.windDir != null) {
            int cx = this.getWidth() / 2;
            int cy = this.getHeight() / 2;
            GraphicsUtil.drawWindArrow(g2d, cx, cy, this.getHeight(), this.windDir, 15, Color.BLACK);
        }
    }

    public void setWind(Double windDir) {
        this.windDir = windDir;
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (e.getModifiers() == 16) {
            int mx = e.getX();
            int my = e.getY();
            if (mx < 0) {
                mx = 0;
            } else if (mx > this.getWidth()) {
                mx = this.getWidth();
            }
            if (my < 0) {
                my = 0;
            } else if (my > this.getHeight()) {
                my = this.getHeight();
            }
            double dx = 179.0 / (double)this.cx * (double)(this.cx - mx);
            double dy = 89.0 / (double)this.cy * (double)(my - this.cy);
            LineSegment segment = GpsUtil.getLineSegment(new GpsPlace(new GpsCoord(0.0), new GpsCoord(0.0)), new GpsPlace(new GpsCoord(dy), new GpsCoord(dx)));
            this.windDir = segment.getCourse();
            MapFrame.getInstance().getUIPanel().updateWindDirection(this.windDir);
        }
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        int r = backgroundColor.getRed() - 25;
        int g = backgroundColor.getGreen() - 25;
        int b = backgroundColor.getBlue() - 25;
        if (r < 0) {
            r = 0;
        }
        if (g < 0) {
            g = 0;
        }
        if (b < 0) {
            b = 0;
        }
        this.backgroundArrowColor = new Color(r, g, b);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

