/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.swing.panel;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.VfrUtil;

public class TimeTextField
extends JPanel {
    private static final long serialVersionUID = -5316651789756263207L;
    private JTextField textField;
    private boolean enabled;
    private JButton decButton;
    private JButton incButton;

    public TimeTextField(double hour, boolean enabled) {
        this.setLayout(new FlowLayout(1, 5, 5));
        this.decButton = new JButton("(-)");
        this.decButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeTextField.this.decAction();
            }
        });
        this.add(this.decButton);
        this.textField = new JTextField(VfrUtil.parseStringFromTime(hour));
        this.add(this.textField);
        this.textField.setColumns(5);
        this.textField.setHorizontalAlignment(0);
        this.textField.setEditable(false);
        this.incButton = new JButton("(+)");
        this.incButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TimeTextField.this.incAction();
            }
        });
        this.add(this.incButton);
        this.setEnabled(enabled);
    }

    public Double getValue() {
        if (StringUtil.isEmpty(this.textField.getText())) {
            return null;
        }
        return VfrUtil.parseTimeFromString(this.textField.getText());
    }

    protected void decAction() {
        double hour = VfrUtil.parseTimeFromString(this.textField.getText()) - 1.0;
        if (hour < 0.0) {
            hour = 23.0;
        }
        this.textField.setText(VfrUtil.parseStringFromTime(hour));
    }

    protected void incAction() {
        double hour = (VfrUtil.parseTimeFromString(this.textField.getText()) + 1.0) % 24.0;
        this.textField.setText(VfrUtil.parseStringFromTime(hour));
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.decButton.setEnabled(enabled);
        this.textField.setEnabled(enabled);
        this.incButton.setEnabled(enabled);
    }
}

