/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.swing.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.gui.swing.panel.LatCoordsPanel;
import main.java.guru.vfrflight.gui.swing.panel.LonCoordsPanel;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.VfrUtil;

public class JCoordsPanel
extends JPanel {
    private static final long serialVersionUID = 4138626647496521243L;
    private final LatCoordsPanel latPanel;
    private final LonCoordsPanel lonPanel;
    private final JRadioButton latLonRadioButton;
    private final JRadioButton decimalRadioButton;
    private JButton fromClipboardButton;

    public JCoordsPanel(String title, GpsPlace place, boolean decimal) {
        this.setLayout(new BorderLayout(0, 0));
        JPanel headerPanel = new JPanel();
        this.add((Component)headerPanel, "North");
        if (!StringUtil.isEmpty(title)) {
            JLabel titleLabel = new JLabel(title);
            headerPanel.add(titleLabel);
        }
        JPanel panel = new JPanel();
        this.add((Component)panel, "Center");
        panel.setLayout(new BorderLayout(0, 0));
        JPanel panel_1 = new JPanel();
        panel.add(panel_1);
        this.latLonRadioButton = new JRadioButton(Messages.getInstance().get("coords_panel_lat_lon"), !decimal);
        this.latLonRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JCoordsPanel.this.decimalAction();
            }
        });
        panel_1.add(this.latLonRadioButton);
        this.decimalRadioButton = new JRadioButton(Messages.getInstance().get("coords_panel_decimal"), decimal);
        this.decimalRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JCoordsPanel.this.decimalAction();
            }
        });
        panel_1.add(this.decimalRadioButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.latLonRadioButton);
        buttonGroup.add(this.decimalRadioButton);
        this.fromClipboardButton = new JButton(Messages.getInstance().get("coords_panel_from_clipboard").toUpperCase());
        this.fromClipboardButton.setFont(new Font("Tahoma", 1, 8));
        this.fromClipboardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent paramActionEvent) {
                JCoordsPanel.this.fromClipboardAction();
            }
        });
        panel_1.add(this.fromClipboardButton);
        JPanel contentPanel = new JPanel();
        panel.add((Component)contentPanel, "North");
        contentPanel.setLayout(new BorderLayout(0, 0));
        GpsCoord lat = null;
        GpsCoord lon = null;
        if (place != null) {
            lat = place.getLat();
            lon = place.getLon();
        }
        this.latPanel = new LatCoordsPanel(Messages.getInstance().get("coords_panel_lat"), lat, decimal);
        contentPanel.add((Component)this.latPanel, "North");
        this.lonPanel = new LonCoordsPanel(Messages.getInstance().get("coords_panel_lon"), lon, decimal);
        contentPanel.add(this.lonPanel);
    }

    protected void fromClipboardAction() {
        GpsPlace place = VfrUtil.getGpsPlaceFromWindowsClipboard();
        if (place != null) {
            this.latPanel.setValue(place.getLat());
            this.lonPanel.setValue(place.getLon());
        } else {
            JOptionPane.showMessageDialog(this, Messages.getInstance().get("coords_panel_from_clipboard_parsing_error"), "", 0);
        }
    }

    protected void decimalAction() {
        boolean decimal = this.decimalRadioButton.isSelected();
        if (decimal) {
            GpsCoord coord;
            if (this.latPanel.getDegValue() != null && this.latPanel.getMinValue() != null && this.latPanel.getSecValue() != null) {
                coord = new GpsCoord(this.latPanel.getDegValue(), this.latPanel.getMinValue(), this.latPanel.getSecValue());
                coord.setMinusValue(this.latPanel.getValue().isMinusValue());
                this.latPanel.setValue(coord);
            }
            if (this.lonPanel.getDegValue() != null && this.lonPanel.getMinValue() != null && this.lonPanel.getSecValue() != null) {
                coord = new GpsCoord(this.lonPanel.getDegValue(), this.lonPanel.getMinValue(), this.lonPanel.getSecValue());
                coord.setMinusValue(this.lonPanel.getValue().isMinusValue());
                this.lonPanel.setValue(coord);
            }
        } else {
            GpsCoord coord;
            if (this.latPanel.getDecimalValue() != null) {
                coord = new GpsCoord(this.latPanel.getDecimalValue());
                coord.setMinusValue(this.latPanel.getValue().isMinusValue());
                this.latPanel.setValue(coord);
            }
            if (this.lonPanel.getDecimalValue() != null) {
                coord = new GpsCoord(this.lonPanel.getDecimalValue());
                coord.setMinusValue(this.lonPanel.getValue().isMinusValue());
                this.lonPanel.setValue(coord);
            }
        }
        this.latPanel.setDecimalVisibility(decimal);
        this.lonPanel.setDecimalVisibility(decimal);
    }

    public List<String> getValidationErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        if (!this.latPanel.hasAllValues()) {
            errors.add(Messages.getInstance().get("coords_panel_lat_invalid"));
        }
        if (!this.lonPanel.hasAllValues()) {
            errors.add(Messages.getInstance().get("coords_panel_lon_invalid"));
        }
        return errors;
    }

    public GpsPlace getValue() {
        if (!this.latPanel.hasAllValues() || !this.lonPanel.hasAllValues()) {
            return null;
        }
        return new GpsPlace(this.latPanel.getValue(), this.lonPanel.getValue());
    }
}

