/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.swing.panel;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.gui.swing.panel.CollapsablePanel;
import main.java.guru.vfrflight.util.GraphicsUtil;
import org.apache.log4j.Logger;

public class HeaderPanel
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = -1507162997868432583L;
    private String text;
    private Font font;
    private BufferedImage open;
    private BufferedImage closed;
    private final int OFFSET = 30;
    private final CollapsablePanel collapsablePanel;
    private final Color backgroundColor;
    private final Color selectedBackgroundColor;
    private static final Logger log = Logger.getLogger(HeaderPanel.class);

    public HeaderPanel(CollapsablePanel collapsablePanel, String text) {
        int i;
        this.addMouseListener(this);
        float[] rgb = new float[3];
        this.getBackground().getRGBColorComponents(rgb);
        for (i = 0; i < 3; ++i) {
            rgb[i] = rgb[i] - 0.04f;
            if (!(rgb[i] < 0.0f)) continue;
            rgb[i] = 0.0f;
        }
        this.backgroundColor = new Color(rgb[0], rgb[1], rgb[2]);
        this.setBackground(this.backgroundColor);
        for (i = 0; i < 3; ++i) {
            rgb[i] = rgb[i] - 0.06f;
            if (!(rgb[i] < 0.0f)) continue;
            rgb[i] = 0.0f;
        }
        this.selectedBackgroundColor = new Color(rgb[0], rgb[1], rgb[2]);
        this.collapsablePanel = collapsablePanel;
        this.text = text.toUpperCase();
        this.font = new Font("SansSerif", 1, 11);
        this.setPreferredSize(new Dimension(collapsablePanel.getWidth(), 25));
        try {
            this.open = ImageIO.read(new File("img/gui/hide_up.png"));
            this.closed = ImageIO.read(new File("img/gui/show_down.png"));
        }
        catch (IOException e) {
            log.error(e, e);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        GraphicsUtil.setRenderingHints(g2d, SettingsBean.getInstance().getRenderingHintsQuality());
        int h = this.getHeight();
        if (this.collapsablePanel.isExpanded()) {
            g2d.drawImage((Image)this.open, 7, 2, this);
        } else {
            g2d.drawImage((Image)this.closed, 7, 2, this);
        }
        g2d.setFont(this.font);
        FontRenderContext frc = g2d.getFontRenderContext();
        LineMetrics lm = this.font.getLineMetrics(this.text, frc);
        float height = lm.getAscent() + lm.getDescent();
        float x = 30.0f;
        float y = ((float)h + height) / 2.0f - lm.getDescent();
        g2d.drawString(this.text, x, y);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setBackground(this.selectedBackgroundColor);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.setBackground(this.backgroundColor);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.collapsablePanel.toggleSelection();
    }
}

