/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.swing.panel;

import java.awt.FlowLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import main.java.guru.vfrflight.bean.combo.item.NumericComboBoxItem;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.gui.swing.textfield.DecimalTextField;
import main.java.guru.vfrflight.gui.swing.textfield.IntegerTextField;
import main.java.guru.vfrflight.util.NumberUtil;

public class CoordsPanel
extends JPanel {
    private static final long serialVersionUID = 7201378458777426090L;
    private final IntegerTextField degField;
    private final IntegerTextField minField;
    private final DecimalTextField secField;
    private final DecimalTextField decimalValueField;
    private JComboBox<NumericComboBoxItem> hemisphereCombo;
    private boolean decimal;
    private JLabel degLabel;
    private JLabel minLabel;
    private JLabel secLabel;
    private final NumericComboBoxItem[] hemisphereComboValues;

    public CoordsPanel(String title, NumericComboBoxItem[] hemisphereComboValues, GpsCoord coord, boolean decimal) {
        this.setLayout(new FlowLayout(1, 5, 5));
        this.add(new JLabel(title));
        this.degField = new IntegerTextField(1);
        this.add(this.degField);
        this.degField.setColumns(3);
        this.degLabel = new JLabel("\u00b0");
        this.add(this.degLabel);
        this.minField = new IntegerTextField(1);
        this.add(this.minField);
        this.minField.setColumns(3);
        this.minLabel = new JLabel("'");
        this.add(this.minLabel);
        this.secField = new DecimalTextField(1);
        this.add(this.secField);
        this.secField.setColumns(5);
        this.secLabel = new JLabel("\"");
        this.add(this.secLabel);
        this.decimalValueField = new DecimalTextField(1);
        this.add(this.decimalValueField);
        this.decimalValueField.setColumns(10);
        this.decimalValueField.setHorizontalAlignment(0);
        this.hemisphereCombo = new JComboBox();
        this.hemisphereCombo.setModel(new DefaultComboBoxModel<NumericComboBoxItem>(hemisphereComboValues));
        this.add(this.hemisphereCombo);
        this.hemisphereComboValues = hemisphereComboValues;
        this.setValue(coord);
        this.setDecimalVisibility(decimal);
    }

    public void setValue(GpsCoord coord) {
        if (coord != null) {
            this.degField.setValue(coord.getDeg());
            this.minField.setValue(coord.getMin());
            this.secField.setValue(coord.getSec());
            this.decimalValueField.setValue(Math.abs(NumberUtil.roundDouble(coord.getValue(), 6)));
            int coordVal = coord.isMinusValue() ? -1 : 1;
            for (int i = 0; i < this.hemisphereComboValues.length; ++i) {
                if (this.hemisphereComboValues[i].getValue() != coordVal) continue;
                this.hemisphereCombo.setSelectedIndex(i);
                break;
            }
        }
    }

    public void setDecimalVisibility(boolean decimal) {
        this.decimal = decimal;
        this.degField.setVisible(!decimal);
        this.degLabel.setVisible(!decimal);
        this.minField.setVisible(!decimal);
        this.minLabel.setVisible(!decimal);
        this.secField.setVisible(!decimal);
        this.secLabel.setVisible(!decimal);
        this.decimalValueField.setVisible(decimal);
    }

    public Integer getDegValue() {
        return this.degField.getValue();
    }

    public Integer getMinValue() {
        return this.minField.getValue();
    }

    public Double getSecValue() {
        return this.secField.getValue();
    }

    public Double getDecimalValue() {
        return this.decimalValueField.getValue();
    }

    public boolean hasAllValues() {
        if (this.decimal) {
            return this.getDecimalValue() != null;
        }
        return this.getDegValue() != null && this.getMinValue() != null && this.getSecValue() != null;
    }

    public GpsCoord getValue() {
        if (!this.hasAllValues()) {
            return null;
        }
        GpsCoord coords = null;
        coords = this.decimal ? new GpsCoord(this.getDecimalValue()) : new GpsCoord(this.getDegValue(), this.getMinValue(), this.getSecValue());
        NumericComboBoxItem selVal = (NumericComboBoxItem)this.hemisphereCombo.getSelectedItem();
        coords.setMinusValue(-1 == selVal.getValue());
        return coords;
    }
}

