/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.swing.panel;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.core.sql.type.MapObjectType;
import main.java.guru.vfrflight.gui.flightplan.AddWithAlignDialog;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.GraphicsUtil;

public class AlignCanvas
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -5316651789756263207L;
    private final Color backgroundColor;
    private double direction;
    private double distance;
    private final MapObjectType objectType;
    private final GpsPlace object;
    private int cx;
    private int cy;
    private AddWithAlignDialog parentDialog;
    private boolean enabled = true;

    public AlignCanvas(AddWithAlignDialog parentDialog, GpsPlace object, MapObjectType objectType, Color backgroundColor) {
        this.parentDialog = parentDialog;
        this.backgroundColor = backgroundColor;
        this.object = object;
        this.objectType = objectType;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.cx = Math.round(this.getWidth() / 2);
        this.cy = Math.round(this.getHeight() / 2);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        GraphicsUtil.setRenderingHints(g2d, SettingsBean.getInstance().getRenderingHintsQuality());
        g2d.setColor(this.backgroundColor);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        double dir = this.direction;
        dir = dir <= 180.0 ? (dir -= 180.0) : (dir += 180.0);
        double rotation = Math.toRadians(dir);
        double rotation2 = Math.toRadians(-dir);
        if (!Double.isNaN(rotation) && !Double.isNaN(rotation2)) {
            int x = Math.round(this.getWidth() / 2);
            int y = Math.round(this.getHeight() / 2);
            int margin = (int)Math.round((double)Math.max(this.getWidth(), this.getHeight()) / 10.0);
            g2d.translate(x, y);
            g2d.rotate(rotation);
            g2d.translate(-x, -y);
            GraphicsUtil.drawWaypoint(g2d, x, this.getHeight() - margin, SettingsBean.getInstance().getColorTheme().getWpColor(false), SettingsBean.getInstance().getColorTheme().getWpStrokeColor(false));
            g2d.setColor(Color.BLACK);
            g2d.setStroke(new BasicStroke(3.0f));
            g2d.drawLine(x, this.getHeight() - margin - 12 - 5, x, this.cy + 15);
            g2d.translate(x, y);
            g2d.rotate(-rotation);
            g2d.translate(-x, -y);
            if (MapObjectType.AIRPORT.equals((Object)this.objectType)) {
                GraphicsUtil.drawAirport(g2d, this.cx, this.cy, 9, this.object.getDataInt("mainRwy"), SettingsBean.getInstance().getColorTheme().getAirportColorOnMap(true), SettingsBean.getInstance().getColorTheme().getAirportStrokeColorOnMap());
            } else if (MapObjectType.NDB.equals((Object)this.objectType)) {
                GraphicsUtil.drawNdb(g2d, this.cx, this.cy, SettingsBean.getInstance().getColorTheme().getNdbColorOnMap(), SettingsBean.getInstance().getColorTheme().getNdbStrokeColorOnMap());
            } else if (MapObjectType.ROUTE_NDB.equals((Object)this.objectType)) {
                GraphicsUtil.drawNdb(g2d, this.cx, this.cy, SettingsBean.getInstance().getColorTheme().getNdbColor(), SettingsBean.getInstance().getColorTheme().getNdbStrokeColor());
            } else if (MapObjectType.VORDME.equals((Object)this.objectType)) {
                boolean nav = "VOR".equals(this.object.getType()) || "VOR-DME".equals(this.object.getType());
                boolean dme = "DME".equals(this.object.getType()) || "VOR-DME".equals(this.object.getType());
                GraphicsUtil.drawVorDme(g2d, this.cx, this.cy, 6, nav, dme, SettingsBean.getInstance().getColorTheme().getVorColorOnMap(), SettingsBean.getInstance().getColorTheme().getVorStrokeColorOnMap());
            } else if (MapObjectType.ROUTE_VORDME.equals((Object)this.objectType)) {
                boolean nav = "VOR".equals(this.object.getType()) || "VOR-DME".equals(this.object.getType());
                boolean dme = "DME".equals(this.object.getType()) || "VOR-DME".equals(this.object.getType());
                GraphicsUtil.drawVorDme(g2d, this.cx, this.cy, 6, nav, dme, SettingsBean.getInstance().getColorTheme().getVorColor(false), SettingsBean.getInstance().getColorTheme().getVorStrokeColor(false));
            } else if (MapObjectType.USER_POINT.equals((Object)this.objectType)) {
                GraphicsUtil.drawUserPoint(g2d, x, y, SettingsBean.getInstance().getColorTheme().getUserPointColorOnMap(), SettingsBean.getInstance().getColorTheme().getUserPointStrokeColorOnMap());
            } else if (MapObjectType.ROUTE_WAYPOINT.equals((Object)this.objectType)) {
                GraphicsUtil.drawWaypoint(g2d, x, y, SettingsBean.getInstance().getColorTheme().getWpColor(false), SettingsBean.getInstance().getColorTheme().getWpStrokeColor(false));
            }
        }
    }

    public double getDirection() {
        return this.direction;
    }

    public void setDirection(double direction) {
        this.direction = direction;
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.enabled && e.getModifiers() == 16) {
            int mx = e.getX();
            int my = e.getY();
            if (mx < 0) {
                mx = 0;
            } else if (mx > this.getWidth()) {
                mx = this.getWidth();
            }
            if (my < 0) {
                my = 0;
            } else if (my > this.getHeight()) {
                my = this.getHeight();
            }
            double dx = 179.0 / (double)this.cx * (double)(this.cx - mx);
            double dy = 89.0 / (double)this.cy * (double)(my - this.cy);
            LineSegment segment = GpsUtil.getLineSegment(new GpsPlace(new GpsCoord(dy), new GpsCoord(dx)), new GpsPlace(new GpsCoord(0.0), new GpsCoord(0.0)));
            double dir = this.direction = GpsUtil.normalizeCourse(segment.getCourse());
            if (this.parentDialog.getMagneticRadioButton().isSelected() && this.parentDialog.getMagVar() != null) {
                dir += this.parentDialog.getMagVar().doubleValue();
            }
            if (this.parentDialog.getIndirectCheckBox().isSelected()) {
                dir += 180.0;
            }
            this.parentDialog.getDirectionTextField().setText(FormatUtil.formattedCourse(dir, false));
            this.repaint();
        }
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

