/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.swing.list;

import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import main.java.guru.vfrflight.core.sql.entity.UserPoint;

public class UserPointsListModel
extends DefaultListModel<String> {
    private static final long serialVersionUID = -197356195932881632L;
    private List<UserPoint> userPoints = new ArrayList<UserPoint>();

    public UserPointsListModel(List<UserPoint> userPoints) {
        for (UserPoint p : userPoints) {
            this.addUserPoint(p);
        }
    }

    @Override
    public String remove(int index) {
        if (index >= 0 && index < this.userPoints.size()) {
            this.userPoints.remove(index);
            return (String)super.remove(index);
        }
        return null;
    }

    public void addUserPoint(UserPoint section) {
        this.addUserPoint(null, section);
    }

    public void addUserPoint(Integer index, UserPoint point) {
        if (index != null) {
            this.userPoints.add(index, point);
            this.add(index, point.getName());
        } else {
            this.userPoints.add(point);
            this.addElement(point.getName());
        }
    }

    public boolean moveUp(int index) {
        if (this.userPoints.size() > 1 && index > 0) {
            UserPoint tempType = this.userPoints.get(index - 1);
            this.remove(index - 1);
            this.addUserPoint(index, tempType);
            return true;
        }
        return false;
    }

    public boolean moveDown(int index) {
        if (this.userPoints.size() > 1 && index < this.userPoints.size() - 1) {
            UserPoint tempType = this.userPoints.get(index + 1);
            this.remove(index + 1);
            this.addUserPoint(index, tempType);
            return true;
        }
        return false;
    }

    public List<UserPoint> getUserPoints() {
        return this.userPoints;
    }
}

