/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.swing.list;

import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.pdf.sections.type.PdfSectionType;

public class PdfSettingsListModel
extends DefaultListModel<String> {
    private static final long serialVersionUID = 1984353870883118811L;
    private List<PdfSectionType> types = new ArrayList<PdfSectionType>();

    public List<PdfSectionType> getTypes() {
        return this.types;
    }

    public PdfSettingsListModel(List<PdfSectionType> types) {
        for (PdfSectionType section : types) {
            this.addSection(section);
        }
    }

    @Override
    public String remove(int index) {
        if (index >= 0 && index < this.types.size()) {
            this.types.remove(index);
            return (String)super.remove(index);
        }
        return null;
    }

    public void addSection(PdfSectionType section) {
        this.addSection(null, section);
    }

    public void addSection(Integer index, PdfSectionType section) {
        String key = "pdf_section_type_" + section.toString().toLowerCase();
        String value = null;
        value = Messages.getInstance().exists(key) ? Messages.getInstance().get(key) : section.toString();
        if (index != null) {
            this.types.add(index, section);
            this.add(index, value);
        } else {
            this.types.add(section);
            this.addElement(value);
        }
    }

    public boolean moveUp(int index) {
        if (this.types.size() > 1 && index > 0) {
            PdfSectionType tempType = this.types.get(index - 1);
            this.remove(index - 1);
            this.addSection(index, tempType);
            return true;
        }
        return false;
    }

    public boolean moveDown(int index) {
        if (this.types.size() > 1 && index < this.types.size() - 1) {
            PdfSectionType tempType = this.types.get(index + 1);
            this.remove(index + 1);
            this.addSection(index, tempType);
            return true;
        }
        return false;
    }
}

