/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.swing.list;

import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import main.java.org.jdesktop.swingx.mapviewer.TileFactoryInfo;

public class MapTypesListModel
extends DefaultListModel<String> {
    private static final long serialVersionUID = 8788116564889105016L;
    private List<TileFactoryInfo> types = new ArrayList<TileFactoryInfo>();

    public List<TileFactoryInfo> getTypes() {
        return this.types;
    }

    public MapTypesListModel(List<TileFactoryInfo> types) {
        for (TileFactoryInfo type : types) {
            this.addType(type);
        }
    }

    @Override
    public String remove(int index) {
        if (index >= 0 && index < this.types.size()) {
            this.types.remove(index);
            return (String)super.remove(index);
        }
        return null;
    }

    public void addType(TileFactoryInfo type) {
        this.addType(null, type);
    }

    public void addType(Integer index, TileFactoryInfo type) {
        if (index != null) {
            this.types.add(index, type);
            this.add(index, type.getName());
        } else {
            this.types.add(type);
            this.addElement(type.getName());
        }
    }

    public boolean moveUp(int index) {
        if (this.types.size() > 1 && index > 0) {
            TileFactoryInfo tempType = this.types.get(index - 1);
            this.remove(index - 1);
            this.addType(index, tempType);
            return true;
        }
        return false;
    }

    public boolean moveDown(int index) {
        if (this.types.size() > 1 && index < this.types.size() - 1) {
            TileFactoryInfo tempType = this.types.get(index + 1);
            this.remove(index + 1);
            this.addType(index, tempType);
            return true;
        }
        return false;
    }
}

