/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.swing.button;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicButtonUI;
import main.java.guru.vfrflight.util.ColorUtil;
import main.java.guru.vfrflight.util.GraphicsUtil;

public class ToolbarStateButton
extends JButton
implements MouseListener {
    private static final long serialVersionUID = 3909293967181085206L;
    private boolean mouseButtonHold = false;

    public ToolbarStateButton(String iconPath, String tooltip, boolean pressed, boolean large) {
        super(large ? GraphicsUtil.getResizedIcon(iconPath, 1.5) : new ImageIcon(iconPath));
        this.setBorderPainted(false);
        this.setToolTipText(tooltip);
        MyButtonUI ui = new MyButtonUI(pressed, (Color)UIManager.get("Panel.background"));
        this.setUI(ui);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.mouseButtonHold = true;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.isEnabled()) {
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.getMyUI().setMouseEntered(true);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.getMyUI().setMouseEntered(false);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseButtonHold = true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.toggle();
        this.mouseButtonHold = false;
    }

    @Override
    public boolean isSelected() {
        return this.mouseButtonHold ? !this.isPressed() : this.isPressed();
    }

    @Override
    public void setSelected(boolean value) {
        super.setSelected(value);
        this.getMyUI().setPressed(value);
    }

    public boolean isPressed() {
        return this.getMyUI().isPressed();
    }

    protected MyButtonUI getMyUI() {
        return (MyButtonUI)this.getUI();
    }

    public void toggle() {
        MyButtonUI ui;
        ui.setPressed(!(ui = this.getMyUI()).isPressed());
        this.repaint();
    }

    private class MyButtonUI
    extends BasicButtonUI {
        private boolean pressed;
        private boolean mouseEntered = false;
        private final Color offColor;
        private final Color onColor;
        private final Color pressedColor;
        private final Color mouseEnteredOffColor;
        private final Color mouseEnteredOnColor;

        public MyButtonUI(boolean pressed, Color offColor) {
            this.pressed = pressed;
            this.offColor = offColor;
            this.pressedColor = ColorUtil.getDarkerColor(offColor, 20);
            this.onColor = ColorUtil.getDarkerColor(offColor, 40);
            this.mouseEnteredOffColor = ColorUtil.getDarkerColor(offColor, 10);
            this.mouseEnteredOnColor = ColorUtil.getDarkerColor(this.onColor, 10);
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            JButton myButton = (JButton)c;
            ButtonModel buttonModel = myButton.getModel();
            if (!buttonModel.isPressed() && this.isPressed()) {
                g.setColor(this.mouseEntered ? this.mouseEnteredOnColor : this.onColor);
            } else if (buttonModel.isPressed()) {
                g.setColor(this.pressedColor);
            } else if (this.mouseEntered) {
                g.setColor(this.isPressed() ? this.mouseEnteredOnColor : this.mouseEnteredOffColor);
            } else {
                g.setColor(this.offColor);
            }
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
            super.paint(g, c);
        }

        public boolean isPressed() {
            return this.pressed;
        }

        public void setPressed(boolean pressed) {
            this.pressed = pressed;
        }

        public void setMouseEntered(boolean mouseEntered) {
            this.mouseEntered = mouseEntered;
        }
    }
}

