/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.swing.button;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicButtonUI;
import main.java.guru.vfrflight.util.ColorUtil;
import main.java.guru.vfrflight.util.GraphicsUtil;

public class ToolbarButton
extends JButton
implements MouseListener {
    private static final long serialVersionUID = -8065495410246456870L;

    public ToolbarButton(String iconPath, String tooltip, boolean large) {
        super(large ? GraphicsUtil.getResizedIcon(iconPath, 1.5) : new ImageIcon(iconPath));
        this.setBorderPainted(false);
        this.setToolTipText(tooltip);
        MyButtonUI ui = new MyButtonUI((Color)UIManager.get("Panel.background"));
        this.setUI(ui);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.isEnabled()) {
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.getMyUI().setMouseEntered(true);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.getMyUI().setMouseEntered(false);
    }

    protected MyButtonUI getMyUI() {
        return (MyButtonUI)this.getUI();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private class MyButtonUI
    extends BasicButtonUI {
        private final Color offColor;
        private final Color pressedColor;
        private final Color mouseEnteredColor;
        private boolean mouseEntered = false;

        public MyButtonUI(Color offColor) {
            this.offColor = offColor;
            this.mouseEnteredColor = ColorUtil.getDarkerColor(offColor, 20);
            this.pressedColor = ColorUtil.getDarkerColor(offColor, 40);
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            JButton myButton = (JButton)c;
            ButtonModel buttonModel = myButton.getModel();
            if (buttonModel.isPressed()) {
                g.setColor(this.pressedColor);
            } else if (this.mouseEntered) {
                g.setColor(this.mouseEnteredColor);
            } else {
                g.setColor(this.offColor);
            }
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
            super.paint(g, c);
        }

        public void setMouseEntered(boolean mouseEntered) {
            this.mouseEntered = mouseEntered;
        }
    }
}

