/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.swing.button;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicButtonUI;
import main.java.guru.vfrflight.util.ColorUtil;
import main.java.guru.vfrflight.util.GraphicsUtil;

public class ToggleUIPButton
extends JButton
implements MouseListener {
    private static final long serialVersionUID = -4502683307267232214L;

    public ToggleUIPButton(String iconPath, boolean large) {
        super(large ? GraphicsUtil.getResizedIcon(iconPath, 1.5) : new ImageIcon(iconPath));
        float[] rgb = new float[3];
        Color backgroundColor = (Color)UIManager.get("Panel.background");
        backgroundColor.getColorComponents(rgb);
        for (int i = 0; i < 3; ++i) {
            rgb[i] = rgb[i] - 0.04f;
            if (!(rgb[i] < 0.0f)) continue;
            rgb[i] = 0.0f;
        }
        Color selectedBackgroundColor = new Color(rgb[0], rgb[1], rgb[2]);
        this.setUI(new MyButtonUI(backgroundColor, selectedBackgroundColor));
        this.addMouseListener(this);
    }

    protected MyButtonUI getMyUI() {
        return (MyButtonUI)this.getUI();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.getMyUI().setMouseEntered(true);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.getMyUI().setMouseEntered(false);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private class MyButtonUI
    extends BasicButtonUI {
        private final Color offColor;
        private final Color mouseEnteredColor;
        private boolean mouseEntered = false;

        public MyButtonUI(Color offColor, Color mouseEnteredColor) {
            this.offColor = offColor;
            this.mouseEnteredColor = ColorUtil.getDarkerColor(offColor, 20);
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            JButton myButton = (JButton)c;
            ButtonModel buttonModel = myButton.getModel();
            if (!buttonModel.isPressed() && this.mouseEntered) {
                g.setColor(this.mouseEnteredColor);
            } else {
                g.setColor(this.offColor);
            }
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
            super.paint(g, c);
        }

        public void setMouseEntered(boolean mouseEntered) {
            this.mouseEntered = mouseEntered;
        }
    }
}

