/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.tilefactory.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import main.java.guru.vfrflight.bean.constants.Constants;
import main.java.guru.vfrflight.gui.map.tilefactory.CopyrightNotice;
import main.java.guru.vfrflight.gui.map.tilefactory.TileFactoryInfoFactory;
import main.java.guru.vfrflight.gui.map.tilefactory.TileFactoryInfoType;
import main.java.guru.vfrflight.util.IO.IOUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.org.jdesktop.swingx.mapviewer.TileFactoryInfo;
import org.apache.log4j.Logger;

public class TileFactoryInfoUtil {
    private static final Logger log = Logger.getLogger(TileFactoryInfoUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TileFactoryInfo> load(String filename) {
        ArrayList<TileFactoryInfo> result = new ArrayList<TileFactoryInfo>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(filename));
            String line = br.readLine();
            int num = Integer.valueOf(line);
            for (int i = 0; i < num; ++i) {
                TileFactoryInfoType type = TileFactoryInfoType.valueOf(br.readLine());
                String name = br.readLine();
                String url = StringUtil.emptyToNull(br.readLine());
                String copyrightNotice = StringUtil.emptyToNull(br.readLine());
                String copyrightLink = StringUtil.emptyToNull(br.readLine());
                result.add(TileFactoryInfoFactory.create(type, name, url, copyrightNotice, copyrightLink));
            }
        }
        catch (Exception e) {
            try {
                log.error("Error loading from file " + filename, e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(br);
                throw throwable;
            }
            IOUtil.closeQuietly(br);
        }
        IOUtil.closeQuietly(br);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(String filename, List<TileFactoryInfo> tileFactories) {
        PrintWriter out = null;
        try {
            out = new PrintWriter(filename);
            out.write(tileFactories.size() + Constants.EOL);
            for (TileFactoryInfo info : tileFactories) {
                if (info.getType() == null) continue;
                out.write(info.getType().toString() + Constants.EOL);
                out.write(info.getName() + Constants.EOL);
                out.write(StringUtil.nullToEmpty(info.getBaseURL()) + Constants.EOL);
                out.write(StringUtil.nullToEmpty(info.getCopyrightNotice()) + Constants.EOL);
                out.write(StringUtil.nullToEmpty(info.getCopyrightLink()) + Constants.EOL);
            }
        }
        catch (Exception e) {
            try {
                log.error(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(out);
                throw throwable;
            }
            IOUtil.closeQuietly(out);
        }
        IOUtil.closeQuietly(out);
    }

    public static String getCopyrightLink(TileFactoryInfo tilefactoryInfo) {
        if (tilefactoryInfo instanceof CopyrightNotice) {
            return ((CopyrightNotice)((Object)tilefactoryInfo)).getCopyrightLink();
        }
        return null;
    }

    public static String getCopyrightNotice(TileFactoryInfo tilefactoryInfo) {
        if (tilefactoryInfo instanceof CopyrightNotice) {
            return ((CopyrightNotice)((Object)tilefactoryInfo)).getCopyrightNotice();
        }
        return null;
    }
}

