/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.tilefactory;

import java.util.ArrayList;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.combo.item.StringComboBoxItem;
import main.java.guru.vfrflight.gui.map.tilefactory.MapBoxTileFactoryInfo;
import main.java.guru.vfrflight.gui.map.tilefactory.MeteoTileFactoryInfo;
import main.java.guru.vfrflight.gui.map.tilefactory.OSMTileFactoryInfo;
import main.java.guru.vfrflight.gui.map.tilefactory.OfflineOSMTileFactoryInfo;
import main.java.guru.vfrflight.gui.map.tilefactory.SkyVectorLowTileFactoryInfo;
import main.java.guru.vfrflight.gui.map.tilefactory.SkyVectorWorldVfrTileFactoryInfo;
import main.java.guru.vfrflight.gui.map.tilefactory.TileFactoryInfoType;
import main.java.org.jdesktop.swingx.VirtualEarthTileFactoryInfo;
import main.java.org.jdesktop.swingx.mapviewer.TileFactoryInfo;

public class TileFactoryInfoFactory {
    public static TileFactoryInfo create(TileFactoryInfoType type) {
        return TileFactoryInfoFactory.create(type, null, null, null, null);
    }

    public static TileFactoryInfo create(TileFactoryInfoType type, String name, String baseUrl) {
        return TileFactoryInfoFactory.create(type, name, baseUrl, null, null);
    }

    public static TileFactoryInfo create(TileFactoryInfoType type, String name, String baseUrl, String copyrightNotice, String copyrightLink) {
        if (TileFactoryInfoType.VIRTUAL_EARTH_MAP.equals((Object)type)) {
            return new VirtualEarthTileFactoryInfo(name, VirtualEarthTileFactoryInfo.MAP, copyrightNotice, copyrightLink);
        }
        if (TileFactoryInfoType.VIRTUAL_EARTH_SATELLITE.equals((Object)type)) {
            return new VirtualEarthTileFactoryInfo(name, VirtualEarthTileFactoryInfo.SATELLITE, copyrightNotice, copyrightLink);
        }
        if (TileFactoryInfoType.VIRTUAL_EARTH_HYBRID.equals((Object)type)) {
            return new VirtualEarthTileFactoryInfo(name, VirtualEarthTileFactoryInfo.HYBRID, copyrightNotice, copyrightLink);
        }
        if (TileFactoryInfoType.SKY_VECTOR_WORLD_VFR.equals((Object)type)) {
            return new SkyVectorWorldVfrTileFactoryInfo(name, baseUrl);
        }
        if (TileFactoryInfoType.SKY_VECTOR_LOW.equals((Object)type)) {
            return new SkyVectorLowTileFactoryInfo(name, baseUrl);
        }
        if (TileFactoryInfoType.METEO.equals((Object)type)) {
            return new MeteoTileFactoryInfo(name, copyrightNotice, copyrightLink);
        }
        if (TileFactoryInfoType.OFFLINE_OSM.equals((Object)type)) {
            return new OfflineOSMTileFactoryInfo(name, baseUrl, copyrightNotice, copyrightLink);
        }
        if (TileFactoryInfoType.MAPBOX.equals((Object)type)) {
            return new MapBoxTileFactoryInfo(name, baseUrl);
        }
        return new OSMTileFactoryInfo(name, baseUrl, copyrightNotice, copyrightLink);
    }

    public static StringComboBoxItem[] createComboBoxValues() {
        ArrayList<StringComboBoxItem> result = new ArrayList<StringComboBoxItem>();
        for (TileFactoryInfoType type : TileFactoryInfoType.values()) {
            String key = "tile_factory_info_type_" + type.toString().toLowerCase();
            String label = null;
            label = Messages.getInstance().exists(key) ? Messages.getInstance().get(key) : type.toString().toUpperCase();
            result.add(new StringComboBoxItem(label, type.toString()));
        }
        return result.toArray(new StringComboBoxItem[result.size()]);
    }
}

