/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.tilefactory;

import main.java.guru.vfrflight.gui.map.tilefactory.CopyrightNotice;
import main.java.guru.vfrflight.gui.map.tilefactory.TileFactoryInfoType;
import main.java.guru.vfrflight.util.AiracHelper;
import main.java.org.jdesktop.swingx.mapviewer.TileFactoryInfo;

public class SkyVectorLowTileFactoryInfo
extends TileFactoryInfo
implements CopyrightNotice {
    private static final int[] ZOOM_LEVELS = new int[]{2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22};
    private final String airac;

    public SkyVectorLowTileFactoryInfo(String name, String baseUrl) {
        super(name, 9, 17, 19, 256, true, true, baseUrl, "", "", "");
        AiracHelper helper = new AiracHelper();
        this.airac = helper.getCurrentAirac();
    }

    @Override
    public String[] getTileUrl(int x, int y, int zoom) {
        String url = this.baseURL.replaceAll("\\{airac\\}", this.airac).replaceAll("\\{level\\}", String.valueOf(ZOOM_LEVELS[zoom - this.getMinimumZoomLevel()])).replaceAll("\\{col\\}", String.valueOf(x)).replaceAll("\\{row\\}", String.valueOf(y));
        return new String[]{url};
    }

    @Override
    public String getCopyrightNotice() {
        return "Map Data \u00a92013 SkyVector, ARINC, OpenStreetMap";
    }

    @Override
    public String getCopyrightLink() {
        return "http://www.skyvector.com";
    }

    @Override
    public TileFactoryInfoType getType() {
        return TileFactoryInfoType.SKY_VECTOR_LOW;
    }
}

