/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.tilefactory;

import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.gui.map.tilefactory.CopyrightNotice;
import main.java.guru.vfrflight.gui.map.tilefactory.TileFactoryInfoType;
import main.java.org.jdesktop.swingx.mapviewer.TileFactoryInfo;

public class OSMTileFactoryInfo
extends TileFactoryInfo
implements CopyrightNotice {
    private final String copyrightNotice;
    private final String copyrightLink;

    public OSMTileFactoryInfo(String name, String baseUrl, String copyrightNotice, String copyrightLink) {
        super(name, 1, 17, 19, 256, true, true, baseUrl, "", "", "");
        this.copyrightNotice = copyrightNotice;
        this.copyrightLink = copyrightLink;
    }

    @Override
    public String[] getTileUrl(int x, int y, int zoom) {
        int z = this.getMaximumZoomLevel() + 1 - zoom + this.getMinimumZoomLevel();
        String url = this.baseURL.replaceAll("\\{level\\}", String.valueOf(z)).replaceAll("\\{col\\}", String.valueOf(x)).replaceAll("\\{row\\}", String.valueOf(y));
        return new String[]{url};
    }

    @Override
    public String getCopyrightNotice() {
        return this.copyrightNotice == null ? Messages.getInstance().get("openstreetmap_copyright") : this.copyrightNotice;
    }

    @Override
    public String getCopyrightLink() {
        return this.copyrightLink == null ? Messages.getInstance().get("openstreetmap_copyright_link") : this.copyrightLink;
    }

    @Override
    public TileFactoryInfoType getType() {
        return TileFactoryInfoType.OSM;
    }
}

