/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.tilefactory;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import main.java.org.jdesktop.swingx.mapviewer.Tile;
import main.java.org.jdesktop.swingx.mapviewer.TileFactory;
import main.java.org.jdesktop.swingx.mapviewer.TileFactoryInfo;

public class NoMapTileFactory
extends TileFactory {
    private final BufferedImage emptyTile;

    public NoMapTileFactory(Color backgroundColor) {
        this(new TileFactoryInfo("NoMapTileFactory 256x256", 1, 15, 17, 256, true, true, "", "x", "y", "z"), backgroundColor);
    }

    public NoMapTileFactory(TileFactoryInfo info, Color backgroundColor) {
        super(info);
        int tileSize = info.getTileSize(info.getMinimumZoomLevel());
        this.emptyTile = new BufferedImage(tileSize, tileSize, 2);
        Graphics2D g = this.emptyTile.createGraphics();
        g.setColor(backgroundColor);
        g.fillRect(0, 0, tileSize, tileSize);
        g.dispose();
    }

    @Override
    public Tile getTile(int x, int y, int zoom) {
        return new Tile(x, y, zoom){

            @Override
            public synchronized boolean isLoaded() {
                return true;
            }

            @Override
            public BufferedImage getImage() {
                return NoMapTileFactory.this.emptyTile;
            }
        };
    }

    @Override
    public void dispose() {
    }

    @Override
    protected void startLoading(Tile tile) {
    }
}

