/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.tilefactory;

import java.text.DecimalFormat;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.meteo.MeteoMapBean;
import main.java.guru.vfrflight.gui.map.tilefactory.CopyrightNotice;
import main.java.guru.vfrflight.gui.map.tilefactory.TileFactoryInfoType;
import main.java.org.jdesktop.swingx.mapviewer.TileFactoryInfo;

public class MeteoTileFactoryInfo
extends TileFactoryInfo
implements CopyrightNotice {
    private final String copyrightNotice;
    private final String copyrightLink;
    private static final double OFFSET = 2.0037508342788696E7;

    public MeteoTileFactoryInfo(String name, String copyrightNotice, String copyrightLink) {
        super(name, 1, 17, 19, 256, true, true, "", "", "", "");
        this.copyrightLink = copyrightLink;
        this.copyrightNotice = copyrightNotice;
    }

    @Override
    public String[] getTileUrl(int x, int y, int zoom) {
        MeteoMapBean meteoBean = MapObjectsBean.getInstance().getMeteoMapBean();
        int meteoZoom = 19 - zoom;
        StringBuffer sb = new StringBuffer(meteoBean.getLink());
        DecimalFormat df = new DecimalFormat("#.0000000000");
        int a = (int)Math.pow(2.0, meteoZoom - 1);
        double TILE_WIDTH = 2.0037508342788696E7 / (double)a;
        double sx = (double)x * TILE_WIDTH - 2.0037508342788696E7;
        double ex = sx + TILE_WIDTH;
        double sy = (double)(a - y - 1) * TILE_WIDTH;
        double ey = sy + TILE_WIDTH;
        sb.append("&BBOX=");
        sb.append(df.format(sx).replace(",", "."));
        sb.append(",");
        sb.append(df.format(sy).replace(",", "."));
        sb.append(",");
        sb.append(df.format(ex).replace(",", "."));
        sb.append(",");
        sb.append(df.format(ey).replace(",", "."));
        if (!meteoBean.isBackgroundMap() || meteoBean.getPreviousTileFactory() == null) {
            return new String[]{sb.toString()};
        }
        String[] url = new String[]{sb.toString(), meteoBean.getPreviousTileFactory().getTileUrl(x, y, zoom)[0]};
        return url;
    }

    @Override
    public String getCopyrightNotice() {
        return this.copyrightNotice != null ? this.copyrightNotice : "(c) meteo.pl";
    }

    @Override
    public String getCopyrightLink() {
        return this.copyrightLink != null ? this.copyrightLink : "http://mapy.meteo.pl";
    }

    @Override
    public TileFactoryInfoType getType() {
        return TileFactoryInfoType.METEO;
    }
}

