/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.shape;

import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.AirspaceAreaVertex;
import main.java.guru.vfrflight.core.sql.entity.UserPoint;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;

public class MapShapeVertex {
    private Double lat;
    private Double lon;
    private Boolean clockwise;
    private Double radius;
    private boolean selected = false;

    public MapShapeVertex() {
    }

    public MapShapeVertex(AirspaceAreaVertex v) {
        this.lat = v.getLat();
        this.lon = v.getLon();
        this.clockwise = v.getClockwise();
        this.radius = v.getRadius();
    }

    public MapShapeVertex(GpsPlace place) {
        this(place.getLat().getValue(), place.getLon().getValue());
    }

    public MapShapeVertex(Double lat, Double lon, Double radius) {
        this.lat = lat;
        this.lon = lon;
        this.radius = radius;
    }

    public MapShapeVertex(Double lat, Double lon) {
        this.lat = lat;
        this.lon = lon;
    }

    public MapShapeVertex(UserPoint p) {
        this(p.getLat(), p.getLon());
    }

    public Double getLat() {
        return this.lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    public Double getLon() {
        return this.lon;
    }

    public void setLon(Double lon) {
        this.lon = lon;
    }

    public Boolean getClockwise() {
        return this.clockwise;
    }

    public void setClockwise(Boolean clockwise) {
        this.clockwise = clockwise;
    }

    public Double getRadius() {
        return this.radius;
    }

    public void setRadius(Double radius) {
        this.radius = radius;
    }

    public boolean isVertex() {
        return this.radius == null;
    }

    public boolean isClockwise() {
        return this.getClockwise() != null ? this.getClockwise() : true;
    }

    public GpsPlace getGpsPlace() {
        return new GpsPlace(this.lat, this.lon);
    }

    public GeoPosition getGeoPosition() {
        return new GeoPosition(this.lat, this.lon);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void setPosition(GpsPlace pos) {
        this.lat = pos.getLat().getValue();
        this.lon = pos.getLon().getValue();
    }

    public boolean isInside(GpsArea area) {
        if (area == null) {
            return false;
        }
        return this.lat <= area.getMaxLat() && this.lat >= area.getMinLat() && this.lon >= area.getMinLon() && this.lon <= area.getMaxLon();
    }

    public MapShapeVertex clone() {
        MapShapeVertex v = new MapShapeVertex();
        v.setLat(this.lat);
        v.setLon(this.lon);
        v.setClockwise(this.clockwise);
        v.setRadius(this.radius);
        v.setSelected(this.selected);
        return v;
    }
}

