/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.shape;

import java.awt.Color;
import java.awt.Stroke;
import java.util.LinkedList;
import java.util.List;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.GpsVertex;
import main.java.guru.vfrflight.gui.map.shape.MapShapeVertex;
import main.java.guru.vfrflight.util.AirspacesUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;

public class MapShape {
    private MapShapeVertex[] vertices;
    private Double radius;
    private Double circleCenterLat;
    private Double circleCenterLon;
    private Color color;
    private Color backgroundColor;
    private Color secondaryStrokeColor;
    private Stroke stroke;
    private Stroke secondaryStroke;
    private GpsArea rectangleOver;
    private GeoPosition center;

    public MapShape clone() {
        MapShape s = new MapShape();
        s.setBackgroundColor(this.backgroundColor);
        s.setCenter(this.center);
        s.setCircleCenterLat(this.circleCenterLat);
        s.setCircleCenterLon(this.circleCenterLon);
        s.setColor(this.backgroundColor);
        s.setRadius(this.radius);
        s.setRectangleOver(this.rectangleOver);
        s.setStroke(this.stroke);
        s.setSecondaryStroke(this.secondaryStroke);
        s.setSecondaryStrokeColor(this.secondaryStrokeColor);
        s.setVertices(this.vertices);
        return s;
    }

    public GeoPosition getCenter() {
        if (this.center == null) {
            this.center = this.isCircle() ? new GeoPosition(this.circleCenterLat, this.circleCenterLon) : GpsUtil.getRectangleOverVertices(this.getGpsVertices()).getCenter().geoPosition();
        }
        return this.center;
    }

    public Color getSecondaryStrokeColor() {
        return this.secondaryStrokeColor;
    }

    public void setSecondaryStrokeColor(Color secondaryStrokeColor) {
        this.secondaryStrokeColor = secondaryStrokeColor;
    }

    public Stroke getSecondaryStroke() {
        return this.secondaryStroke;
    }

    public void setSecondaryStroke(Stroke secondaryStroke) {
        this.secondaryStroke = secondaryStroke;
    }

    public void setCenter(GeoPosition center) {
        this.center = center;
    }

    public boolean isPoly() {
        return this.vertices != null && this.vertices.length > 1;
    }

    public boolean isCircle() {
        return this.radius != null && (this.circleCenterLat != null || this.circleCenterLon != null);
    }

    public boolean isInside(GpsArea area) {
        if (this.getRectangleOver() == null) {
            return false;
        }
        return this.getRectangleOver().isInside(area) || area.isInside(this.getRectangleOver());
    }

    public GpsArea getRectangleOver() {
        if (this.rectangleOver == null && this.isPoly() && this.vertices.length > 0) {
            this.rectangleOver = GpsUtil.getRectangleOverVertices(this.getGpsVertices());
        } else if (this.rectangleOver == null && this.isCircle()) {
            this.rectangleOver = GpsUtil.getCircleArea(this.getCircleCenter(), this.getRadius());
        }
        return this.rectangleOver;
    }

    public GpsPlace getCircleCenter() {
        if (this.circleCenterLat != null && this.circleCenterLon != null) {
            return new GpsPlace(new GpsCoord(this.circleCenterLat), new GpsCoord(this.circleCenterLon));
        }
        return null;
    }

    public void setCircleCenter(GpsPlace circleCenter) {
        this.circleCenterLat = circleCenter.getLat().getValue();
        this.circleCenterLon = circleCenter.getLon().getValue();
    }

    public boolean hasArc() {
        for (MapShapeVertex vertex : this.getVertices()) {
            if (vertex.isVertex()) continue;
            return true;
        }
        return false;
    }

    public MapShapeVertex[] getVertices() {
        return this.vertices;
    }

    public void setVertices(MapShapeVertex[] vertices) {
        this.vertices = vertices;
    }

    public Double getRadius() {
        return this.radius;
    }

    public void setRadius(Double radius) {
        this.radius = radius;
    }

    public Double getCircleCenterLat() {
        return this.circleCenterLat;
    }

    public void setCircleCenterLat(Double circleCenterLat) {
        this.circleCenterLat = circleCenterLat;
    }

    public Double getCircleCenterLon() {
        return this.circleCenterLon;
    }

    public void setCircleCenterLon(Double circleCenterLon) {
        this.circleCenterLon = circleCenterLon;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public void setRectangleOver(GpsArea rectangleOver) {
        this.rectangleOver = rectangleOver;
    }

    public void calculateRectangleOverIfEmpty(JXMapViewer map) {
        if (this.rectangleOver == null) {
            this.calculateRectangleOver(map);
        }
    }

    public void calculateRectangleOver(JXMapViewer map) {
        if (this.isPoly() && this.vertices.length > 0) {
            MapShapeVertex[] vertices = null;
            vertices = this.hasArc() ? AirspacesUtil.convertArcAirspaceToPolygon(map, this.getVertices(), 2) : this.getVertices();
            LinkedList<GpsVertex> result = new LinkedList<GpsVertex>();
            for (MapShapeVertex v : vertices) {
                result.add(v.getGpsPlace());
            }
            this.rectangleOver = GpsUtil.getRectangleOverVertices(result);
        } else if (this.isCircle()) {
            this.rectangleOver = GpsUtil.getCircleArea(this.getCircleCenter(), this.getRadius());
        }
    }

    public List<GpsVertex> getGpsVertices() {
        LinkedList<GpsVertex> result = new LinkedList<GpsVertex>();
        for (MapShapeVertex v : this.getVertices()) {
            result.add(v.getGpsPlace());
        }
        return result;
    }
}

