/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.popup;

import java.awt.Color;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.SimConnectBean;
import main.java.guru.vfrflight.bean.api.ExtConnectBean;
import main.java.guru.vfrflight.core.dto.AirportDTO;
import main.java.guru.vfrflight.core.dto.ElevationDTO;
import main.java.guru.vfrflight.core.dto.RunwayExtensionDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.GpsPoint;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.core.map.MapObject;
import main.java.guru.vfrflight.core.sql.type.MapObjectType;
import main.java.guru.vfrflight.gui.flightplan.AddUserPointDialog;
import main.java.guru.vfrflight.gui.flightplan.AddWithAlignDialog;
import main.java.guru.vfrflight.gui.flightplan.EngineLossRangeDialog;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.SunriseSunsetCalculatorDialog;
import main.java.guru.vfrflight.gui.flightplan.UserTrackAnalyzerDialog;
import main.java.guru.vfrflight.gui.map.VfrMapViewer;
import main.java.guru.vfrflight.gui.map.listener.AddMapRadialsListener;
import main.java.guru.vfrflight.gui.map.listener.AddNewAlternateAirportListener;
import main.java.guru.vfrflight.gui.map.listener.AddNewLandmarkListener;
import main.java.guru.vfrflight.gui.map.listener.AddNewPointListener;
import main.java.guru.vfrflight.gui.map.listener.AddNewUserPointListener;
import main.java.guru.vfrflight.gui.map.listener.AddNewVorListener;
import main.java.guru.vfrflight.gui.map.listener.DeleteMapRadialsListener;
import main.java.guru.vfrflight.gui.map.listener.EditMapRadialsListener;
import main.java.guru.vfrflight.gui.map.listener.EditWpListener;
import main.java.guru.vfrflight.gui.map.listener.GetMeteoAtPosListener;
import main.java.guru.vfrflight.gui.map.listener.OpenAirportInfoListener;
import main.java.guru.vfrflight.gui.map.listener.OpenSkyVectorInfoListener;
import main.java.guru.vfrflight.gui.map.listener.RemoveMapObjectListener;
import main.java.guru.vfrflight.gui.task.api.ExtConnectTaskSupport;
import main.java.guru.vfrflight.sql.facade.UserPointFacade;
import main.java.guru.vfrflight.util.ColorUtil;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.ElevationsUtil;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.MapUtil;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.SimConnectUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.UrlUtil;
import main.java.guru.vfrflight.util.VfrUtil;
import main.java.guru.vfrflight.weather.WeatherUtil;

public class VfrMapPopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = -8658087926173038865L;
    private final MapFrame mapFrame;

    /*
     * WARNING - void declaration
     */
    public VfrMapPopupMenu(final MapFrame mapFrame, final int mouseX, final int mouseY) {
        boolean addSeparator;
        AirportDTO airport;
        this.mapFrame = mapFrame;
        final GpsPlace pos = mapFrame.getMapViewer().getGeoPositionAtPos(mouseX, mouseY).gpsPlace();
        boolean separator = false;
        if (SettingsBean.getInstance().isConnectedToSimAndHasData()) {
            ExtConnectTaskSupport support = SettingsBean.getInstance().getExtConnectTask().getSupport();
            JMenu simConnectMenu = new JMenu(Messages.getInstance().get("popup_menu_simconnect"));
            this.add(simConnectMenu);
            if (support.isSupportForMoveHere()) {
                JCheckBoxMenuItem moveHere = new JCheckBoxMenuItem(Messages.getInstance().get("popup_menu_move_here"));
                moveHere.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        GpsPlace position = mapFrame.getMapViewer().getGpsPlaceAtMapPosition(mouseX, mouseY);
                        SimConnectBean bean = (SimConnectBean)SimConnectUtil.getInstance().getExtConnectBean();
                        if (bean != null) {
                            SimConnectUtil.setUserPosition(null, (float)position.getLat().getValue(), (float)position.getLon().getValue(), bean.getUserAlt().floatValue());
                        }
                    }
                });
                simConnectMenu.add(moveHere);
            }
            if (SettingsBean.getInstance().getSimConnectConfigBean().isTraceUserPosition()) {
                ExtConnectBean bean = SimConnectUtil.getInstance().getExtConnectBean();
                LineSegment seg = GpsUtil.getLineSegment(bean.getGpsPlace(), pos);
                double dist = seg.getDistance();
                if (!"nm".equals(SettingsBean.getInstance().getParamUnitsDistance())) {
                    dist = UnitUtil.recalculateDistance(dist, "nm", SettingsBean.getInstance().getParamUnitsDistance(), false);
                }
                double magCrs = GpsUtil.normalizeCourse(seg.getCourse() - VfrUtil.getMagneticDeclination(seg));
                StringBuilder sb = new StringBuilder();
                sb.append(NumberUtil.roundDouble(dist, 1));
                sb.append(SettingsBean.getInstance().getParamUnitsDistance());
                sb.append(" / ");
                sb.append(SettingsBean.getInstance().getTrueTrackPrefix());
                sb.append(FormatUtil.formattedCourse(seg.getCourse(), true));
                sb.append(" ");
                sb.append(SettingsBean.getInstance().getMagTrackPrefix());
                sb.append(FormatUtil.formattedCourse(magCrs, true));
                JMenuItem segmentInfo = new JMenuItem(sb.toString());
                this.add(segmentInfo);
                if (support.isSupportForVector()) {
                    JMenuItem addVector = new JMenuItem(Messages.getInstance().get("popup_menu_simconnect_add_vector"));
                    addVector.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            GpsPlace stickyTo;
                            GpsPoint vectorTo = MapUtil.getPixelPositionOnMap(mapFrame.getMapViewer(), mouseX, mouseY);
                            GpsPlace result = null;
                            if (SettingsBean.getInstance().isStickyMode() && (stickyTo = mapFrame.getMapViewer().getStickyGpsPlace(vectorTo, mouseX, mouseY, true, true)) != null) {
                                result = stickyTo;
                            }
                            if (result == null) {
                                result = mapFrame.getMapViewer().getGpsPlace(vectorTo);
                            }
                            SettingsBean.getInstance().getSimConnectConfigBean().setVectorTo(result);
                            SettingsBean.getInstance().getSimConnectConfigBean().setVectorInfoPos(null);
                            mapFrame.updateMap();
                        }
                    });
                    simConnectMenu.add(addVector);
                    if (SettingsBean.getInstance().getSimConnectConfigBean().isDrawVector()) {
                        JMenuItem removeVector = new JMenuItem(Messages.getInstance().get("popup_menu_simconnect_remove_vector"));
                        removeVector.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                SettingsBean.getInstance().getSimConnectConfigBean().setVectorTo(null);
                                SettingsBean.getInstance().getSimConnectConfigBean().setVectorInfoPos(null);
                                mapFrame.updateMap();
                            }
                        });
                        simConnectMenu.add(removeVector);
                    }
                }
                simConnectMenu.add(new JSeparator());
            }
            if (support.isSupportForFollowPosition()) {
                if (SettingsBean.getInstance().getSimConnectConfigBean().isTraceUserPosition()) {
                    JCheckBoxMenuItem followUserPosition = new JCheckBoxMenuItem(Messages.getInstance().get("popup_menu_follow_user_position"), SettingsBean.getInstance().isFollowUserPosition());
                    followUserPosition.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            mapFrame.toggleFollowUserPosition();
                        }
                    });
                    simConnectMenu.add(followUserPosition);
                }
                simConnectMenu.add(new JSeparator());
            }
            if (support.isSupportForSetAltitude()) {
                JCheckBoxMenuItem setAltitude = new JCheckBoxMenuItem(Messages.getInstance().get("popup_menu_set_altitude"));
                setAltitude.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SimConnectBean bean;
                        Float alt = null;
                        String txt = null;
                        do {
                            if ((txt = JOptionPane.showInputDialog(mapFrame, (Object)"")) == null) continue;
                            try {
                                alt = Float.valueOf(txt);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        } while (alt == null && txt != null);
                        if (alt != null && (bean = (SimConnectBean)SimConnectUtil.getInstance().getExtConnectBean()) != null) {
                            SimConnectUtil.setUserPosition(null, bean.getUserLat().floatValue(), bean.getUserLon().floatValue(), alt.floatValue());
                        }
                    }
                });
                simConnectMenu.add(setAltitude);
            }
            if (support.isSupportForUpdateFromSim()) {
                JMenu updateFromSimMenu = new JMenu(Messages.getInstance().get("popup_menu_update_from_sim"));
                simConnectMenu.add(updateFromSimMenu);
                if (support.isSupportForUpdateWind()) {
                    JCheckBoxMenuItem updateWindFromSim = new JCheckBoxMenuItem(Messages.getInstance().get("popup_menu_update_wind_from_sim"), SettingsBean.getInstance().getSimConnectConfigBean().isUpdateWindFromSim());
                    updateWindFromSim.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            SettingsBean.getInstance().getSimConnectConfigBean().setUpdateWindFromSim(!SettingsBean.getInstance().getSimConnectConfigBean().isUpdateWindFromSim());
                            mapFrame.updateMap();
                        }
                    });
                    updateFromSimMenu.add(updateWindFromSim);
                }
                if (support.isSupportForUpdateTas()) {
                    JCheckBoxMenuItem updateTasFromSim = new JCheckBoxMenuItem(Messages.getInstance().get("popup_menu_update_tas_from_sim"), SettingsBean.getInstance().getSimConnectConfigBean().isUpdateTasFromSim());
                    updateTasFromSim.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            SettingsBean.getInstance().getSimConnectConfigBean().setUpdateTasFromSim(!SettingsBean.getInstance().getSimConnectConfigBean().isUpdateTasFromSim());
                        }
                    });
                    updateFromSimMenu.add(updateTasFromSim);
                }
                if (support.isSupportForUpdateWind() && support.isSupportForUpdateTas()) {
                    updateFromSimMenu.add(new JSeparator());
                    boolean updateAll = SettingsBean.getInstance().getSimConnectConfigBean().isUpdateTasFromSim() && SettingsBean.getInstance().getSimConnectConfigBean().isUpdateWindFromSim();
                    JCheckBoxMenuItem updateAllFromSim = new JCheckBoxMenuItem(Messages.getInstance().get("popup_menu_update_all_from_sim"), updateAll);
                    updateAllFromSim.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (SettingsBean.getInstance().getSimConnectConfigBean().isUpdateWindFromSim() && SettingsBean.getInstance().getSimConnectConfigBean().isUpdateTasFromSim()) {
                                SettingsBean.getInstance().getSimConnectConfigBean().setUpdateWindFromSim(false);
                                SettingsBean.getInstance().getSimConnectConfigBean().setUpdateTasFromSim(false);
                            } else {
                                SettingsBean.getInstance().getSimConnectConfigBean().setUpdateWindFromSim(true);
                                SettingsBean.getInstance().getSimConnectConfigBean().setUpdateTasFromSim(true);
                            }
                            mapFrame.updateMap();
                        }
                    });
                    updateFromSimMenu.add(updateAllFromSim);
                    simConnectMenu.add(new JSeparator());
                }
            }
            if (support.isSupportForOptimizeForPerformance()) {
                JCheckBoxMenuItem optimizeForMaxPerformance = new JCheckBoxMenuItem(Messages.getInstance().get("popup_menu_optimize_for_max_performance"));
                optimizeForMaxPerformance.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ExtConnectBean bean = SimConnectUtil.getInstance().getExtConnectBean();
                        if (bean != null) {
                            VfrUtil.optimizeForMaxPerformance(new GpsPlace(bean.getUserLat().floatValue(), bean.getUserLon().floatValue()), FlightPlanBean.getInstance().getRoute());
                        }
                    }
                });
                simConnectMenu.add(optimizeForMaxPerformance);
            }
            separator = true;
        } else if (SettingsBean.getInstance().isDrawUserTrack() && mapFrame.getMapViewer().isUserPointAtPixelPos(mouseX, mouseY)) {
            JCheckBoxMenuItem exportToGoogleEarth = new JCheckBoxMenuItem(Messages.getInstance().get("popup_menu_export_track_to_ge"));
            exportToGoogleEarth.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SimConnectUtil.exportUserTrackToGoogleEarthAction(SimConnectUtil.getInstance().getUserTrack());
                }
            });
            this.add(exportToGoogleEarth);
            JMenuItem exportToCsv = new JMenuItem(Messages.getInstance().get("popup_menu_export_track_to_csv"));
            exportToCsv.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SimConnectUtil.exportUserTrackToCsvAction(SimConnectUtil.getInstance().getUserTrack());
                }
            });
            this.add(exportToCsv);
            JMenuItem exportToGpx = new JMenuItem(Messages.getInstance().get("popup_menu_export_track_to_gpx"));
            exportToGpx.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SimConnectUtil.exportUserTrackToGpxAction(SimConnectUtil.getInstance().getUserTrack());
                }
            });
            this.add(exportToGpx);
            JCheckBoxMenuItem analyzeTrack = new JCheckBoxMenuItem(Messages.getInstance().get("popup_menu_analyze_track"));
            analyzeTrack.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new UserTrackAnalyzerDialog(mapFrame, SimConnectUtil.getInstance().getUserTrack(), 300);
                }
            });
            this.add(analyzeTrack);
            JCheckBoxMenuItem clearTrack = new JCheckBoxMenuItem(Messages.getInstance().get("popup_menu_remove_track"));
            clearTrack.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SimConnectUtil.getInstance().clearUserTrack();
                    mapFrame.updateMap();
                }
            });
            this.add(clearTrack);
            separator = true;
        }
        if (!mapFrame.isOnCalculatedFrame()) {
            int vorNdbIdx;
            if (separator) {
                this.add(new JSeparator());
            }
            List<MapObject> mapObjectsListClicked = mapFrame.getMapViewer().getMapObjectsListAtPixelPos(mouseX, mouseY);
            int routePointIdx = mapFrame.getMapViewer().getWpIndexAtPixelPos(mouseX, mouseY);
            if (routePointIdx >= 0) {
                GpsPlace wp = FlightPlanBean.getInstance().getRoute().getPoints().get(routePointIdx);
                mapObjectsListClicked.add(new MapObject(MapObjectType.ROUTE_WAYPOINT, null, wp.getName(), wp));
                JMenuItem editWpItem = new JMenuItem(Messages.getInstance().get("popup_menu_edit_wp"));
                editWpItem.addActionListener(new EditWpListener(routePointIdx));
                this.add(editWpItem);
                this.add(new JSeparator());
            }
            if ((vorNdbIdx = mapFrame.getMapViewer().getVorIndexAtPixelPos(mouseX, mouseY)) >= 0) {
                GpsPlace vorNdb = FlightPlanBean.getInstance().getRoute().getVors().get(vorNdbIdx);
                mapObjectsListClicked.add(new MapObject(vorNdb.isNdb() ? MapObjectType.ROUTE_NDB : MapObjectType.ROUTE_VORDME, null, vorNdb.getName(), vorNdb));
            }
            if (mapObjectsListClicked.size() > 0) {
                GpsPlace clickedGpsPlace = mapFrame.getMapViewer().getGpsPlaceOnMap(mouseX, mouseY);
                this.createMenuAddFor(mapObjectsListClicked, clickedGpsPlace, MapObjectType.AIRPORT);
                this.createMenuAddFor(mapObjectsListClicked, clickedGpsPlace, MapObjectType.ILS);
                this.createMenuAddFor(mapObjectsListClicked, clickedGpsPlace, MapObjectType.VORDME);
                this.createMenuAddFor(mapObjectsListClicked, clickedGpsPlace, MapObjectType.NDB);
                this.createMenuAddFor(mapObjectsListClicked, clickedGpsPlace, MapObjectType.RUNWAY_EXTENSION);
                this.createMenuAddFor(mapObjectsListClicked, clickedGpsPlace, MapObjectType.CITY, MapObjectType.IFR_POINT, MapObjectType.VFR_POINT, MapObjectType.USER_POINT);
            }
            JMenuItem addItem = new JMenuItem(Messages.getInstance().get("popup_menu_add_point_at", FormatUtil.formatGpsPos(pos, SettingsBean.getInstance().isParamUseMapDecimalCoords())));
            addItem.setIcon(new ImageIcon("img/gui/new_wp.png"));
            addItem.addActionListener(new AddNewPointListener(pos.clone()));
            this.add(addItem);
            GpsPlace navaid = mapFrame.getMapViewer().getMapVorNdbAtPosition(mouseX, mouseY);
            if (navaid != null) {
                JMenuItem addVorItem = new JMenuItem(Messages.getInstance().get("popup_menu_add_vor_here", navaid.getType() + " " + navaid.getName()));
                addVorItem.setIcon(new ImageIcon("NDB".equals(navaid.getType()) ? "img/gui/layer_ndb.png" : "img/gui/layer_vor.png"));
                addVorItem.addActionListener(new AddNewVorListener(mouseX, mouseY));
                this.add(addVorItem);
            }
            if (mapFrame.isSegmentAtPosition(mouseX, mouseY)) {
                JMenuItem addLandmarkItem = new JMenuItem(Messages.getInstance().get("popup_menu_add_landmark_here"));
                addLandmarkItem.addActionListener(new AddNewLandmarkListener(mouseX, mouseY));
                this.add(addLandmarkItem);
            }
            for (MapObject o : mapObjectsListClicked) {
                if (!MapObjectType.AIRPORT.equals((Object)o.getType()) || FlightPlanBean.getInstance().getRoute().containsAlternateAirports(o.getPosition())) continue;
                JMenuItem jMenuItem = new JMenuItem(Messages.getInstance().get("popup_menu_mark_airport_as_alternate", o.getName()));
                jMenuItem.setIcon(new ImageIcon("img/gui/new_alternate.png"));
                jMenuItem.addActionListener(new AddNewAlternateAirportListener(o.getId()));
                this.add(jMenuItem);
            }
            if (routePointIdx >= 0 || vorNdbIdx >= 0 || mapFrame.isLandmarkAtPosition(mouseX, mouseY)) {
                String label = "";
                if (routePointIdx >= 0) {
                    GpsPlace place = FlightPlanBean.getInstance().getRoute().getPoints().get(routePointIdx);
                    label = Messages.getInstance().get("remove_from_route", place.getName());
                    JMenuItem jMenuItem = new JMenuItem(Messages.getInstance().get("popup_menu_add_user_point_at", place.getName()));
                    jMenuItem.setIcon(new ImageIcon("img/gui/layer_user.png"));
                    jMenuItem.addActionListener(new AddNewUserPointListener(place.clone()));
                    this.add(jMenuItem);
                } else if (vorNdbIdx >= 0) {
                    GpsPlace n = FlightPlanBean.getInstance().getRoute().getVors().get(vorNdbIdx);
                    label = Messages.getInstance().get("remove_from_route", n.getType() + " " + n.getName());
                } else {
                    label = Messages.getInstance().get("remove_landmark");
                }
                JMenuItem deleteItem = new JMenuItem(label);
                deleteItem.setIcon(new ImageIcon("img/gui/remove_vor_wp.png"));
                deleteItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int idx;
                        if (!mapFrame.isVorsMouseDrag() && (idx = mapFrame.getMapViewer().getVorIndexAtPixelPos(mouseX, mouseY)) >= 0) {
                            mapFrame.getUIPanel().delVorAction(idx);
                        }
                        mapFrame.deleteSelected();
                    }
                });
                this.add(deleteItem);
            }
            if (FlightPlanBean.getInstance().getRoute().getVors().size() > 0) {
                Integer mapRadialIdx = mapFrame.getMapRadialsAtPosition(mouseX, mouseY);
                if (mapRadialIdx == null) {
                    JMenuItem addMapRadialsItem = new JMenuItem(Messages.getInstance().get("popup_menu_add_map_radials_here"));
                    addMapRadialsItem.addActionListener(new AddMapRadialsListener(mouseX, mouseY));
                    this.add(addMapRadialsItem);
                } else {
                    JMenuItem editMapRadialsItem = new JMenuItem(Messages.getInstance().get("popup_menu_edit_map_radials_here"));
                    editMapRadialsItem.addActionListener(new EditMapRadialsListener(mapRadialIdx));
                    this.add(editMapRadialsItem);
                    JMenuItem jMenuItem = new JMenuItem(Messages.getInstance().get("popup_menu_delete_map_radials_here"));
                    jMenuItem.addActionListener(new DeleteMapRadialsListener(mapRadialIdx));
                    this.add(jMenuItem);
                }
            }
            if (routePointIdx < 0) {
                for (final MapObject mapObject : mapObjectsListClicked) {
                    if (!MapObjectType.USER_POINT.equals((Object)mapObject.getType())) continue;
                    JMenuItem jMenuItem = new JMenuItem(Messages.getInstance().get("popup_menu_edit_user_point", mapObject.getName()));
                    jMenuItem.setIcon(new ImageIcon("img/gui/layer_user.png"));
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            UserPointFacade facade = new UserPointFacade(DBUtil.getDataSource());
                            AddUserPointDialog userPointDialog = new AddUserPointDialog((Window)mapFrame, facade.findUserPointById(mapObject.getId()));
                            userPointDialog.setVisible(true);
                        }
                    });
                    this.add(jMenuItem);
                }
                JMenuItem addUserPoint = new JMenuItem(Messages.getInstance().get("popup_menu_add_user_point_at", FormatUtil.formatGpsPos(pos, SettingsBean.getInstance().isParamUseMapDecimalCoords())));
                addUserPoint.setIcon(new ImageIcon("img/gui/layer_user.png"));
                addUserPoint.addActionListener(new AddNewUserPointListener(pos.clone()));
                this.add(addUserPoint);
            }
            if (mapObjectsListClicked.size() > 0) {
                ArrayList<JMenuItem> deleteMenuItems = new ArrayList<JMenuItem>();
                for (MapObject mapObject : mapObjectsListClicked) {
                    if (!MapObjectType.AIRPORT.equals((Object)mapObject.getType()) && !MapObjectType.VORDME.equals((Object)mapObject.getType()) && !MapObjectType.NDB.equals((Object)mapObject.getType()) && !MapObjectType.USER_POINT.equals((Object)mapObject.getType()) && !MapObjectType.CITY.equals((Object)mapObject.getType()) && !MapObjectType.VFR_POINT.equals((Object)mapObject.getType()) && !MapObjectType.IFR_POINT.equals((Object)mapObject.getType()) && !MapObjectType.AIRSPACE_AREA.equals((Object)mapObject.getType())) continue;
                    JMenuItem deleteMapObjectItem = new JMenuItem(Messages.getInstance().get("delete_map_object_" + mapObject.getType().toString().toLowerCase(), mapObject.getName()));
                    deleteMapObjectItem.addActionListener(new RemoveMapObjectListener(mapObject));
                    deleteMapObjectItem.setIcon(new ImageIcon("img/gui/bin_closed.png"));
                    deleteMenuItems.add(deleteMapObjectItem);
                }
                if (deleteMenuItems.size() > 0) {
                    this.add(new JSeparator());
                    JMenu deleteMapObjectMenu = new JMenu(Messages.getInstance().get("delete_map_object"));
                    this.add(deleteMapObjectMenu);
                    for (JMenuItem item : deleteMenuItems) {
                        deleteMapObjectMenu.add(item);
                    }
                }
            }
        }
        if (mapFrame.getZoom() <= 11 && SettingsBean.getInstance().isDrawAllAirports() && (airport = mapFrame.getAirportAtPosition(mouseX, mouseY)) != null) {
            if (!mapFrame.isOnCalculatedFrame()) {
                this.add(new JSeparator());
            }
            JMenuItem openAirportInfoItem = new JMenuItem(Messages.getInstance().get("popup_menu_open_airport_info", airport.getIdentOrName()));
            openAirportInfoItem.addActionListener(new OpenAirportInfoListener(airport.getName()));
            this.add(openAirportInfoItem);
            if (!SettingsBean.getInstance().isOfflineMode() && airport.getName() != null) {
                JMenuItem openAirportSkyVectorInfoItem = new JMenuItem(Messages.getInstance().get("popup_menu_open_skyvector_airport_info", airport.getName()));
                openAirportSkyVectorInfoItem.addActionListener(new OpenSkyVectorInfoListener(airport.getName()));
                this.add(openAirportSkyVectorInfoItem);
            }
        }
        this.add(new JSeparator());
        if (!mapFrame.isOnCalculatedFrame()) {
            if (!SettingsBean.getInstance().isOfflineMode() && WeatherUtil.isMeteoAvailable(mapFrame.getGpsPlaceAtMapPosition(mouseX, mouseY))) {
                JMenuItem showMeteoItem = new JMenuItem(Messages.getInstance().get("popup_menu_show_meteo"));
                showMeteoItem.addActionListener(new GetMeteoAtPosListener(mouseX, mouseY));
                this.add(showMeteoItem);
                JMenuItem getSunriseSunsetItem = new JMenuItem(Messages.getInstance().get("popup_menu_get_sunset_sunrise"));
                getSunriseSunsetItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SunriseSunsetCalculatorDialog dialog = new SunriseSunsetCalculatorDialog(mapFrame.getMapViewer().getGpsPlaceAtMapPosition(mouseX, mouseY));
                        dialog.setVisible(true);
                    }
                });
                this.add(getSunriseSunsetItem);
                this.add(new JSeparator());
            }
            JCheckBoxMenuItem stickyMode = new JCheckBoxMenuItem(Messages.getInstance().get("popup_menu_sticky_mode"), SettingsBean.getInstance().isStickyMode());
            stickyMode.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SettingsBean.getInstance().setStickyMode(!SettingsBean.getInstance().isStickyMode());
                }
            });
            this.add(stickyMode);
            JCheckBoxMenuItem lockPoints = new JCheckBoxMenuItem(Messages.getInstance().get("popup_menu_show_lock_points"), mapFrame.isPointsLocked());
            lockPoints.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    mapFrame.togglePointsLock();
                }
            });
            this.add(lockPoints);
        }
        if (pos != null) {
            final String zip = ElevationsUtil.getZipHgtFilenameForPlace(pos, SettingsBean.getInstance().getHgtZipFilesMappings());
            if (zip != null) {
                String filename = FormatUtil.getHgtFilename(pos.getLat().getValue(), pos.getLon().getValue());
                JMenuItem zipWithHgtItem = new JMenuItem(Messages.getInstance().get("popup_menu_download_zip_with_hgt", UrlUtil.getFilenameFromPath(zip), filename));
                zipWithHgtItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        mapFrame.downloadZipWithHgt(zip);
                    }
                });
                this.add(zipWithHgtItem);
            }
            final String posTxt = FormatUtil.formatAixmGpsLat(pos.getLat().getValue()) + "," + FormatUtil.formatAixmGpsLon(pos.getLon().getValue());
            final String posTxt2 = FormatUtil.formatDecimalGps(pos);
            final String posTxt3 = FormatUtil.formatGps(pos);
            JMenuItem copyPosToClipboard2 = new JMenuItem(posTxt2);
            copyPosToClipboard2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StringUtil.copyToClipboard(posTxt2);
                }
            });
            JMenuItem copyPosToClipboard3 = new JMenuItem(posTxt3);
            copyPosToClipboard3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StringUtil.copyToClipboard(posTxt3);
                }
            });
            JMenuItem copyPosToClipboard = new JMenuItem(posTxt);
            copyPosToClipboard.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StringUtil.copyToClipboard(posTxt);
                }
            });
            JMenu jMenu = new JMenu(Messages.getInstance().get("popup_menu_show_copy_pos_to_clipboard"));
            this.add(jMenu);
            jMenu.add(copyPosToClipboard2);
            jMenu.add(copyPosToClipboard3);
            jMenu.add(copyPosToClipboard);
            this.add(new JSeparator());
            JMenuItem calculateEngineLossRange = new JMenuItem(Messages.getInstance().get("popup_menu_calculate_engine_loss_range"));
            calculateEngineLossRange.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EngineLossRangeDialog dialog = new EngineLossRangeDialog(mapFrame, pos);
                    dialog.setVisible(true);
                }
            });
            this.add(calculateEngineLossRange);
            if (MapObjectsBean.getInstance().getEngineLossSegments() != null) {
                JMenuItem removeEngineLossRange = new JMenuItem(Messages.getInstance().get("popup_menu_remove_engine_loss_range"));
                removeEngineLossRange.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MapObjectsBean.getInstance().setEngineLossSegments(null);
                        MapObjectsBean.getInstance().setHighlightedMapShape(null);
                        mapFrame.updateMap();
                    }
                });
                this.add(removeEngineLossRange);
            }
        }
        this.add(new JSeparator());
        JMenu exportMapAs = new JMenu(Messages.getInstance().get("popup_menu_export_map_as"));
        this.add(exportMapAs);
        JMenuItem exportMapAsPdf = new JMenuItem(Messages.getInstance().get("popup_menu_export_map_as_pdf"));
        exportMapAsPdf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mapFrame.exportMapAsPdf();
            }
        });
        exportMapAs.add(exportMapAsPdf);
        JMenuItem exportMapAsPng = new JMenuItem(Messages.getInstance().get("popup_menu_export_map_as_png"));
        exportMapAsPng.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mapFrame.exportMapAsPng();
            }
        });
        exportMapAs.add(exportMapAsPng);
        ElevationDTO msa = this.getMsaInformation(mouseX, mouseY);
        List<String> vorRadials = this.getVorRadialsInformation(pos);
        boolean bl = addSeparator = msa != null || vorRadials.size() > 0;
        if (addSeparator) {
            this.add(new JSeparator());
        }
        if (vorRadials.size() > 0) {
            int i = 0;
            StringBuilder stringBuilder = new StringBuilder();
            for (String radial : vorRadials) {
                void var13_68;
                var13_68.append(radial);
                var13_68.append("     ");
                if (++i % 2 != 0) continue;
                JMenuItem radialInfo = new JMenuItem(var13_68.toString().trim());
                radialInfo.setForeground(Color.BLACK);
                this.add(radialInfo);
                StringBuilder stringBuilder2 = new StringBuilder();
            }
            if (vorRadials.size() % 2 == 1) {
                JMenuItem radialInfo = new JMenuItem(vorRadials.get(vorRadials.size() - 1).toString().trim());
                radialInfo.setForeground(Color.BLACK);
                this.add(radialInfo);
            }
        }
        if (msa != null) {
            JMenuItem elevationInfo = new JMenuItem(Messages.getInstance().get("text_under_cursor_msa_in_radius") + " " + msa.getAlt() * 100 + SettingsBean.getInstance().getParamUnitsAltitude());
            elevationInfo.setForeground(Color.BLACK);
            elevationInfo.setBackground(ColorUtil.newColorWithOpacity(SettingsBean.getInstance().getColorTheme().getElevColorOnMap(false), 0.45f));
            this.add(elevationInfo);
        }
    }

    private List<String> getVorRadialsInformation(GpsPlace pos) {
        ArrayList<String> resultList = new ArrayList<String>();
        Map<String, LineSegment> vorRadials = FlightPlanBean.getInstance().getRoute().getVorRadials(pos);
        for (Map.Entry<String, LineSegment> pair : vorRadials.entrySet()) {
            LineSegment radial = pair.getValue();
            double dist = radial.getDistance();
            if (!(dist <= 200.0)) continue;
            String txt = pair.getKey();
            txt = dist >= 1.0 ? txt + " R" + FormatUtil.formattedCourse(radial.getMagneticCourse(), false) : txt + "-- ";
            if (!"nm".equals(SettingsBean.getInstance().getParamUnitsDistance())) {
                UnitUtil.recalculateDistance(dist, "nm", SettingsBean.getInstance().getParamUnitsDistance(), false);
            }
            txt = txt + " / " + NumberUtil.roundDouble(dist, 1) + SettingsBean.getInstance().getParamUnitsDistance();
            resultList.add(txt);
        }
        return resultList;
    }

    private ElevationDTO getMsaInformation(int mouseX, int mouseY) {
        VfrMapViewer map = this.mapFrame.getMapViewer();
        if (map.getZoom() <= 11 && SettingsBean.getInstance().isDrawElevations()) {
            int delta = (int)Math.round(Math.sqrt(map.getZoom()) * 7.0);
            GpsPlace topLeft = map.getTileFactory().pixelToGeo(MapUtil.getPixelPositionOnMap(map, mouseX - delta, mouseY - delta), map.getZoom()).gpsPlace();
            GpsPlace bottomRight = map.getTileFactory().pixelToGeo(MapUtil.getPixelPositionOnMap(map, mouseX + delta, mouseY + delta), map.getZoom()).gpsPlace();
            GpsArea mouseArea = new GpsArea(topLeft, bottomRight);
            return ElevationsUtil.findMsaInRadius(MapObjectsBean.getInstance().getElevations(mouseArea), mouseArea.getCenter(), 25.0);
        }
        return null;
    }

    private void createMenuAddFor(List<MapObject> mapObjectsListClicked, final GpsPlace clickedGpsPlace, MapObjectType ... mapObjectTypesArray) {
        List<MapObjectType> mapObjectsTypes = Arrays.asList(mapObjectTypesArray);
        for (final MapObject mapObject : mapObjectsListClicked) {
            JMenuItem addObjectType;
            JMenuItem addOnIlsGs;
            if (mapObjectsTypes.contains((Object)MapObjectType.ILS) && MapObjectType.ILS.equals((Object)mapObject.getType())) {
                addOnIlsGs = new JMenuItem(Messages.getInstance().get("popup_menu_add_new_on_ils_gs", "ILS  " + mapObject.getName()));
                addOnIlsGs.setIcon(new ImageIcon("img/gui/new_wp.png"));
                addOnIlsGs.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        GpsPlace ilsPlace = mapObject.getPosition();
                        double distNm = GpsUtil.getDistance(ilsPlace, clickedGpsPlace);
                        double dist = UnitUtil.recalculateDistance(distNm, SettingsBean.getInstance().getParamUnitsDistance(), SettingsBean.getInstance().getParamUnitsAltitude(), false);
                        double alt = Math.tan(Math.toRadians(ilsPlace.getDataDouble("pitch"))) * dist;
                        double heading = GpsUtil.normalizeCourse(180.0 + ilsPlace.getDataDouble("heading"));
                        GpsPlace resultPoint = GpsUtil.getPointPositionByDistanceAndBearing(ilsPlace, heading, distNm);
                        resultPoint.setAlt(Double.valueOf(Math.round(alt += UnitUtil.recalculateAltitude(ilsPlace.getDataInt("elev").intValue(), "ft", SettingsBean.getInstance().getParamUnitsAltitude(), false))));
                        VfrMapPopupMenu.this.mapFrame.getUIPanel().addNewPoint(resultPoint, null);
                    }
                });
                this.add(addOnIlsGs);
                continue;
            }
            if (mapObjectsTypes.contains((Object)MapObjectType.AIRPORT) && MapObjectType.AIRPORT.equals((Object)mapObject.getType())) {
                addObjectType = new JMenuItem(Messages.getInstance().get("popup_menu_add_airport_to_route", mapObject.getName()));
                addObjectType.setIcon(new ImageIcon("img/gui/new_wp.png"));
                GpsPlace place = mapObject.getPosition();
                place.setName(mapObject.getName());
                addObjectType.addActionListener(new AddNewPointListener(place.clone()));
                this.add(addObjectType);
                JMenuItem addWithAlignItem = new JMenuItem(Messages.getInstance().get("popup_menu_add_new_with_align", mapObject.getPosition().getName()));
                addWithAlignItem.setIcon(new ImageIcon("img/gui/new_wp.png"));
                addWithAlignItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (mapObject.getPosition().getAlt() != null) {
                            mapObject.getPosition().setAlt(UnitUtil.recalculateAltitude(mapObject.getPosition().getAlt(), "ft", SettingsBean.getInstance().getParamUnitsAltitude(), false));
                        }
                        mapObject.getPosition().setAlt(mapObject.getPosition().getAlt());
                        AddWithAlignDialog dialog = new AddWithAlignDialog(VfrMapPopupMenu.this.mapFrame, mapObject);
                        dialog.setVisible(true);
                    }
                });
                this.add(addWithAlignItem);
                continue;
            }
            if (mapObjectsTypes.contains((Object)MapObjectType.VORDME) && MapObjectType.VORDME.equals((Object)mapObject.getType()) || mapObjectsTypes.contains((Object)MapObjectType.NDB) && MapObjectType.NDB.equals((Object)mapObject.getType())) {
                addObjectType = new JMenuItem(Messages.getInstance().get("popup_menu_add_airport_to_route", (Object)((Object)mapObject.getType()) + " " + mapObject.getName()));
                addObjectType.setIcon(new ImageIcon("img/gui/new_wp.png"));
                addObjectType.addActionListener(new AddNewPointListener(mapObject.getPosition().clone()));
                this.add(addObjectType);
                continue;
            }
            if (mapObjectsTypes.contains((Object)MapObjectType.CITY) && MapObjectType.CITY.equals((Object)mapObject.getType()) || mapObjectsTypes.contains((Object)MapObjectType.IFR_POINT) && MapObjectType.IFR_POINT.equals((Object)mapObject.getType()) || mapObjectsTypes.contains((Object)MapObjectType.VFR_POINT) && MapObjectType.VFR_POINT.equals((Object)mapObject.getType()) || mapObjectsTypes.contains((Object)MapObjectType.USER_POINT) && MapObjectType.USER_POINT.equals((Object)mapObject.getType())) {
                addObjectType = new JMenuItem(Messages.getInstance().get("popup_menu_add_airport_to_route", mapObject.getName()));
                addObjectType.setIcon(new ImageIcon("img/gui/new_wp.png"));
                addObjectType.addActionListener(new AddNewPointListener(mapObject.getPosition().clone()));
                this.add(addObjectType);
                continue;
            }
            if (!mapObjectsTypes.contains((Object)MapObjectType.RUNWAY_EXTENSION) || !MapObjectType.RUNWAY_EXTENSION.equals((Object)mapObject.getType())) continue;
            addOnIlsGs = new JMenuItem(Messages.getInstance().get("popup_menu_add_new_on_runway_extension", mapObject.getName()));
            addOnIlsGs.setIcon(new ImageIcon("img/gui/new_wp.png"));
            addOnIlsGs.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RunwayExtensionDTO ext = MapObjectsBean.getInstance().getRunwayExtensions()[mapObject.getId()];
                    GpsPlace ilsPlace = mapObject.getPosition();
                    double distNm = GpsUtil.getDistance(ilsPlace, clickedGpsPlace);
                    double dist = UnitUtil.recalculateDistance(distNm, SettingsBean.getInstance().getParamUnitsDistance(), SettingsBean.getInstance().getParamUnitsAltitude(), false);
                    double alt = 0.0;
                    if (ext.getElev() != null) {
                        alt = Math.tan(Math.toRadians(3.0)) * dist + (double)ext.getElev().intValue();
                    }
                    GpsPlace resultPoint = GpsUtil.getPointPositionByDistanceAndBearing(ilsPlace, ext.getHeading(), distNm);
                    resultPoint.setAlt(Double.valueOf(Math.round(alt)));
                    VfrMapPopupMenu.this.mapFrame.getUIPanel().addNewPoint(resultPoint, null);
                }
            });
            this.add(addOnIlsGs);
        }
    }
}

