/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.WindSock;
import main.java.guru.vfrflight.core.dto.WindSockDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.gui.map.painter.VfrPainter;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;

public class WindSockPainter
extends VfrPainter {
    private WindSockDTO windSock = null;
    private final Double sizeModificator;

    public WindSockPainter(GpsArea visibleArea, WindSock wSock, Double windDirection, Double windSpeed, Double sizeModificator) {
        this.visibleArea = visibleArea;
        this.windSock = new WindSockDTO(windDirection, windSpeed, wSock.getCalcRadius());
        this.windSock.setPosition(new GeoPosition(wSock.getLat(), wSock.getLon()));
        this.sizeModificator = sizeModificator;
    }

    @Override
    public void draw(Graphics2D g, JXMapViewer map, GpsArea visibleArea) {
        if (this.windSock.isInside(visibleArea)) {
            Point2D center = map.getTileFactory().geoToPixel(this.windSock.getPosition(), map.getZoom());
            int cx = (int)Math.round(center.getX());
            int cy = (int)Math.round(center.getY());
            int r = 0;
            r = this.sizeModificator == null ? (int)Math.round(this.windSock.getRadius()) : (int)Math.round(this.windSock.getRadius() * this.sizeModificator);
            Font windSockFont = new Font("Monospaced", 1, Math.round(r / 3));
            Graphics2D g2d = g;
            double navDir = GpsUtil.getNavigationalWindDir(this.windSock.getWindDir());
            Double rotation = Math.toRadians(navDir - 90.0);
            Double rotation2 = Math.toRadians(-navDir + 90.0);
            if (!Double.isNaN(rotation) && !Double.isNaN(rotation2)) {
                g2d.translate(cx, cy);
                g2d.rotate(rotation);
                g2d.translate(-cx, -cy);
                g2d.setColor(SettingsBean.getInstance().getColorTheme().getWindSockStrokeColor());
                g2d.setStroke(new BasicStroke(5.0f));
                GraphicsUtil.drawArrow(g, cx, cy, r + 3);
                g2d.setColor(SettingsBean.getInstance().getColorTheme().getWindSockColor());
                g2d.setStroke(new BasicStroke(3.0f));
                GraphicsUtil.drawArrow(g, cx, cy, r);
                g2d.setFont(windSockFont);
                FontMetrics fm = g2d.getFontMetrics();
                StringBuilder txt = new StringBuilder();
                txt.append(FormatUtil.formattedCourse(this.windSock.getWindDir(), false));
                txt.append("/");
                txt.append(Math.round(this.windSock.getWindSpeed()));
                String str = txt.toString();
                Rectangle2D rect = fm.getStringBounds(str, g2d);
                if (navDir >= 0.0 && navDir < 180.0) {
                    GraphicsUtil.drawOutlinedString(g, cx - (int)Math.round(rect.getWidth() / 1.5), cy - 5, str, windSockFont, SettingsBean.getInstance().getColorTheme().getWindSockColor(), SettingsBean.getInstance().getColorTheme().getWindSockStrokeColor(), 3.0f);
                } else {
                    g2d.translate(cx, cy);
                    g2d.rotate(Math.toRadians(180.0));
                    g2d.translate(-cx, -cy);
                    GraphicsUtil.drawOutlinedString(g, cx - (int)Math.round(rect.getWidth() / 3.0), cy - 5, str, windSockFont, SettingsBean.getInstance().getColorTheme().getWindSockColor(), SettingsBean.getInstance().getColorTheme().getWindSockStrokeColor(), 3.0f);
                    g2d.translate(cx, cy);
                    g2d.rotate(Math.toRadians(-180.0));
                    g2d.translate(-cx, -cy);
                }
                g2d.translate(cx, cy);
                g2d.rotate(rotation2);
                g2d.translate(-cx, -cy);
            }
            g2d.dispose();
        }
    }
}

