/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.List;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.dto.StationDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.gui.map.painter.VfrPainter;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.guru.vfrflight.util.MapUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.metar.Clouds;
import main.java.guru.vfrflight.weather.core.Station;
import main.java.org.jdesktop.swingx.JXMapViewer;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;

public class WeatherPainter
extends VfrPainter {
    private static final Font CLOUDS_LABEL_FONT = new Font("SansSerif", 1, 12);
    private static final Font STATIONS_LABEL_FONT = new Font("SansSerif", 1, 12);
    private StationDTO[] stationsList;

    public WeatherPainter(GpsArea visibleArea, List<Station> stations) {
        this.visibleArea = visibleArea;
        LinkedList<StationDTO> list = new LinkedList<StationDTO>();
        for (Station wp : stations) {
            GeoPosition gp = new GeoPosition(wp.getLat(), wp.getLon());
            StationDTO vmwp = new StationDTO();
            vmwp.setPosition(gp);
            vmwp.setName(wp.getIcao());
            if (wp.isMetarRecentAndValid()) {
                vmwp.setMetarData(wp.getReport().getMetarData());
            }
            list.add(vmwp);
        }
        this.stationsList = list.toArray(new StationDTO[list.size()]);
    }

    @Override
    public void draw(Graphics2D g, JXMapViewer map, GpsArea visibleArea) {
        for (StationDTO wp : this.stationsList) {
            GpsPlace centerPlace = wp.getPosition().gpsPlace();
            if (!centerPlace.isInside(visibleArea)) continue;
            Point2D center = map.getTileFactory().geoToPixel(wp.getPosition(), map.getZoom());
            int x = (int)Math.round(center.getX());
            int y = (int)Math.round(center.getY());
            boolean drawStationSymbol = true;
            if (wp.getMetarData() != null) {
                Double visRad = null;
                if (wp.getMetarData().getVisibility() != null) {
                    visRad = MapUtil.calculateRadiusToPixels(map, centerPlace, UnitUtil.recalculateDistance(wp.getMetarData().getVisibility(), "m", "nm", false));
                    Ellipse2D.Double shape = new Ellipse2D.Double(center.getX() - visRad + 1.0, center.getY() - visRad + 1.0, visRad * 2.0 + 1.0, visRad * 2.0 + 1.0);
                    if (wp.getMetarData().getVisibility() < 5000.0) {
                        g.setColor(new Color(1.0f, 0.0f, 0.0f, 0.4f));
                    } else if (wp.getMetarData().getVisibility() < 9999.0) {
                        g.setColor(new Color(1.0f, 0.0f, 0.5647059f, 0.2f));
                    } else {
                        g.setColor(new Color(1.0f, 1.0f, 1.0f, 0.4f));
                    }
                    g.fill(shape);
                    g.setColor(Color.LIGHT_GRAY);
                    g.draw(shape);
                    drawStationSymbol = false;
                }
                if (wp.getMetarData().getSpeed() != null) {
                    int size = (int)Math.round(MapUtil.calculateRadiusToPixels(map, centerPlace, 5.0));
                    if (size > 100) {
                        size = 100;
                    }
                    if (wp.getMetarData().getMinimumDirection() != null && wp.getMetarData().getMaximumDirection() != null) {
                        int size2 = (int)Math.round(0.75 * (double)size);
                        GraphicsUtil.drawWindSymbol(g, x, y, wp.getMetarData().getMinimumDirection().shortValue(), (short)Math.round(wp.getMetarData().getSpeed()), size2, new Color(0.0f, 0.0f, 0.0f, 0.3f), new Color(1.0f, 1.0f, 1.0f, 0.5f));
                        GraphicsUtil.drawWindSymbol(g, x, y, wp.getMetarData().getMaximumDirection().shortValue(), (short)Math.round(wp.getMetarData().getSpeed()), size2, new Color(0.0f, 0.0f, 0.0f, 0.3f), new Color(1.0f, 1.0f, 1.0f, 0.5f));
                        drawStationSymbol = false;
                    }
                    if (wp.getMetarData().getDirection() != null) {
                        GraphicsUtil.drawWindSymbol(g, x, y, wp.getMetarData().getDirection().shortValue(), (short)Math.round(wp.getMetarData().getSpeed()), size, Color.BLACK, Color.WHITE);
                        drawStationSymbol = false;
                    }
                }
                if (SettingsBean.getInstance().isDrawTextLabels() && wp.getMetarData().getClouds().size() > 0) {
                    int starty = y + 20;
                    if (visRad != null) {
                        starty = (int)Math.round(center.getY() - visRad + 5.0);
                    }
                    g.setFont(CLOUDS_LABEL_FONT);
                    g.setColor(Color.BLACK);
                    FontMetrics fm = g.getFontMetrics();
                    int i = 1;
                    for (Clouds clouds : wp.getMetarData().getClouds()) {
                        String txt = clouds.toString();
                        int tx = (int)Math.round((double)x - fm.getStringBounds(txt, g).getWidth() / 2.0);
                        int ty = starty + i * 12;
                        this.applyTextLabelsRotation(g, tx, ty);
                        g.drawString(txt, tx, ty);
                        this.removeTextLabelsRotation(g, tx, ty);
                        ++i;
                    }
                }
            }
            if (drawStationSymbol) {
                g.setColor(SettingsBean.getInstance().getColorTheme().getStationBorderColor());
                g.setStroke(new BasicStroke(3.0f));
                GraphicsUtil.drawTriangle(g, x, y, 10);
                g.setColor(SettingsBean.getInstance().getColorTheme().getStationInsideColor());
                g.setStroke(new BasicStroke(1.0f));
                GraphicsUtil.drawTriangle(g, x, y, 10);
            }
            if (!SettingsBean.getInstance().isDrawTextLabels()) continue;
            g.setColor(SettingsBean.getInstance().getColorTheme().getStationBorderColor());
            g.setFont(STATIONS_LABEL_FONT);
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D rect = fm.getStringBounds(wp.getName(), g);
            g.drawString(wp.getName(), (int)Math.round((double)x - rect.getWidth() / 2.0), y + 25);
        }
    }
}

