/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.map.painter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.List;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.dto.WaypointDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.RoutePlace;
import main.java.guru.vfrflight.gui.map.painter.VfrPainter;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.guru.vfrflight.util.MapUtil;
import main.java.org.jdesktop.swingx.JXMapViewer;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;

public class VorNdbPainter
extends VfrPainter {
    private WaypointDTO[] vorsList;
    private boolean onCalculatedFrame;
    private boolean paintVorRadials;
    private static final float[] dash = new float[]{5.0f};
    private static final BasicStroke PHANTOM_STROKE_4 = new BasicStroke(4.0f, 0, 0, 3.0f, dash, 0.0f);
    private static final BasicStroke BASIC_STROKE_4 = new BasicStroke(4.0f);
    private static final BasicStroke PHANTOM_STROKE_2 = new BasicStroke(2.0f, 0, 0, 3.0f, dash, 0.0f);
    private static final BasicStroke BASIC_STROKE_2 = new BasicStroke(2.0f);
    private final Font labelFont;

    public VorNdbPainter(GpsArea visibleArea, List<RoutePlace> vors, boolean onCalculatedFrame, boolean paintVorRadials, int fontSizeModificator) {
        this.visibleArea = visibleArea;
        LinkedList<WaypointDTO> list = new LinkedList<WaypointDTO>();
        for (RoutePlace vor : vors) {
            GeoPosition gp = new GeoPosition(vor.getLat().getValue(), vor.getLon().getValue());
            WaypointDTO vmwp = new WaypointDTO();
            vmwp.setPosition(gp);
            vmwp.setSelected(vor.isSelected());
            vmwp.setName(vor.getName());
            vmwp.setPhantom(vor.isPhantom());
            vmwp.setAlt(vor.getAlt());
            vmwp.setData(vor.getData());
            vmwp.setType(vor.getType());
            vmwp.setDataDouble("magvar", vor.getMagvar());
            list.add(vmwp);
        }
        this.vorsList = list.toArray(new WaypointDTO[list.size()]);
        this.onCalculatedFrame = onCalculatedFrame;
        this.paintVorRadials = paintVorRadials;
        this.labelFont = new Font("SansSerif", 1, 12 + fontSizeModificator);
    }

    @Override
    public void draw(Graphics2D g, JXMapViewer map, GpsArea visibleArea) {
        for (WaypointDTO wp : this.vorsList) {
            if (!wp.isInside(visibleArea)) continue;
            Point2D center = map.getTileFactory().geoToPixel(wp.getPosition(), map.getZoom());
            int x = (int)Math.round(center.getX());
            int y = (int)Math.round(center.getY());
            this.applyTextLabelsRotation(g, x, y);
            Color color = null;
            Color strokeColor = null;
            if ("NDB".equals(wp.getType())) {
                color = wp.isSelected() ? SettingsBean.getInstance().getColorTheme().getVorColor(true) : SettingsBean.getInstance().getColorTheme().getNdbColor();
                strokeColor = SettingsBean.getInstance().getColorTheme().getNdbStrokeColor();
                GraphicsUtil.drawNdb(g, x, y, color, strokeColor);
            } else {
                if (wp.isSelected()) {
                    if (this.isOnCalculatedFrame() && this.isPaintVorRadials()) {
                        strokeColor = SettingsBean.getInstance().getColorTheme().getVorRadialStrokeColor(false, wp.getAlt() != null);
                        color = SettingsBean.getInstance().getColorTheme().getVorRadialColor(false, wp.getAlt() != null);
                    } else {
                        strokeColor = SettingsBean.getInstance().getColorTheme().getVorStrokeColor(true);
                        color = SettingsBean.getInstance().getColorTheme().getVorColor(true);
                    }
                } else {
                    strokeColor = SettingsBean.getInstance().getColorTheme().getVorStrokeColor(false);
                    color = SettingsBean.getInstance().getColorTheme().getVorColor(false);
                }
                boolean nav = "VOR".equals(wp.getType()) || "VOR-DME".equals(wp.getType());
                boolean dme = "DME".equals(wp.getType()) || "VOR-DME".equals(wp.getType());
                int pixels10nm = (int)Math.round(MapUtil.calculateRadiusToPixels(map, wp.getPosition().gpsPlace(), 10.0));
                if (wp.isPhantom()) {
                    g.setStroke(PHANTOM_STROKE_4);
                } else {
                    g.setStroke(BASIC_STROKE_4);
                }
                if (nav) {
                    g.setColor(strokeColor);
                    GraphicsUtil.drawVorShape(g, x, y, 6);
                    if (wp.getMagvar() != null) {
                        g.setColor(SettingsBean.getInstance().getColorTheme().getVorCircleStrokeColor());
                        GraphicsUtil.drawVorCircle(g, x, y, pixels10nm, wp.getMagvar());
                    }
                }
                if (dme) {
                    g.setColor(strokeColor);
                    GraphicsUtil.drawDmeShape(g, x, y, 6);
                }
                if (wp.isPhantom()) {
                    g.setStroke(PHANTOM_STROKE_2);
                } else {
                    g.setStroke(BASIC_STROKE_2);
                }
                if (nav) {
                    g.setColor(color);
                    GraphicsUtil.drawVorShape(g, x, y, 6);
                    if (wp.getMagvar() != null) {
                        g.setColor(SettingsBean.getInstance().getColorTheme().getVorCircleColor());
                        GraphicsUtil.drawVorCircle(g, x, y, pixels10nm, wp.getMagvar());
                    }
                }
                if (dme) {
                    g.setColor(color);
                    GraphicsUtil.drawDmeShape(g, x, y, 6);
                }
            }
            if (SettingsBean.getInstance().isShowCrsAndDist()) {
                boolean ndb = "NDB".equals(wp.getType());
                GraphicsUtil.drawOutlinedString(g, x + 20, y - 2, wp.getNavaidInfoName(ndb), this.labelFont, color, strokeColor, 3.0f);
                GraphicsUtil.drawOutlinedString(g, x + 20, y + 12, wp.getNavaidInfoFrequency(ndb), this.labelFont, color, strokeColor, 3.0f);
            }
            this.removeTextLabelsRotation(g, x, y);
        }
    }

    public boolean isOnCalculatedFrame() {
        return this.onCalculatedFrame;
    }

    public void setOnCalculatedFrame(boolean onCalculatedFrame) {
        this.onCalculatedFrame = onCalculatedFrame;
    }

    public boolean isPaintVorRadials() {
        return this.paintVorRadials;
    }

    public void setPaintVorRadials(boolean paintVorRadials) {
        this.paintVorRadials = paintVorRadials;
    }
}

